package cn.nexgo.hwdriver;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;

import com.nexgo.oaf.apiv3.APIProxy;
import com.nexgo.oaf.apiv3.device.beeper.Beeper;

import cn.nexgo.utils.BaseUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2018/1/5
 * Modify          : create file
 **************************************************************************************************/
public class AppBeeper {
    private boolean stop = false;
    private final int VOICE_EVENT = 2;
    private final int QUIT_EVENT = 3;
    private Handler handler = new Handler(Looper.getMainLooper()) {
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if(stop){
                beeper.beep(0);
                return;
            }

            if (msg.what == VOICE_EVENT) {
                beeper.beep(Integer.MAX_VALUE);
                handler.sendEmptyMessageDelayed(QUIT_EVENT, voiceTime);
                return;
            }

            if (msg.what == QUIT_EVENT) {
                beeper.beep(0);

                if(workTimes > 0){
                    workTimes --;
                    if(workTimes == 0){
                        return;
                    }
                }

                handler.sendEmptyMessageDelayed(VOICE_EVENT, quitTime);
                return;
            }
        }
    };

    private Beeper beeper;

    public AppBeeper() {
        beeper = APIProxy.getDeviceEngine(BaseUtils.getApp().getApplicationContext()).getBeeper();
    }

    private int voiceTime = 500;
    private int quitTime = 500;
    private int workTimes = 6;

    /**
     * @param cycleTime       unit:ms
     * @param dutyCycle (0-99)
     * @param times           work times(-1 means never stop)
     */
    public boolean startBeeper(int cycleTime, int dutyCycle, int times) {

        if ((cycleTime < 10) || (dutyCycle >= 100) || (dutyCycle < 0)) {
            return false;
        }
        handler.removeMessages(VOICE_EVENT);
        handler.removeMessages(QUIT_EVENT);

        stop = false;

        voiceTime = cycleTime * dutyCycle / 100;
        quitTime = cycleTime - voiceTime;
        if(quitTime < 0){
            quitTime = 0;
        }

        workTimes = times;

        handler.sendEmptyMessage(VOICE_EVENT);

        return true;
    }

    public void stopBeeper() {
        stop = true;
        handler.removeMessages(VOICE_EVENT);
        handler.removeMessages(QUIT_EVENT);
        beeper.beep(0);
    }

    /**
     * beep once
     * @param duration unit:ms
     * @return
     */
    public boolean startBeeper(int duration){
        stopBeeper();
        beeper.beep(duration);
        return true;
    }
}
