package cn.nexgo.inbas.transactions.reversal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.nexgo.inbas.common.Constans.CardType;
import cn.nexgo.inbas.common.GData;
import cn.nexgo.inbas.components.data.DataConstant;
import cn.nexgo.inbas.transactions.common.protocol.bean.Emv55FieldDOLType;
import cn.nexgo.inbas.transactions.common.protocol.bean.MsgBean;
import cn.nexgo.protocol.iso8583.Message;
import cn.nexgo.utils.FormatUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2018/1/31
 * Modify          : create file
 **************************************************************************************************/
public class ReversalEntity extends MsgBean.BaseTransEntity {
    private GData gData = GData.getInstance();
    private Logger mLog = LoggerFactory.getLogger(ReversalEntity.class.getSimpleName());

    public ReversalEntity() {
        setMsgType("0400");
        setEmv55FieldDOLType(Emv55FieldDOLType.DOL_REVERSAL);
    }

    @Override
    public byte[] packageMsg() {
        Message msg = super.setCommonDataIntoMsg("7024028006C08211");//modify by hassan remove field 22
        if (msg == null) {
            mLog.error("set commonData error");
            return null;
        }

        //field 22 // modify by hassan, need fix again
        msg.setFieldValue(22, getTransRecordEntity().getMsgEntryMode());

        //filed 39
        msg.setFieldValue(39, getReversalCode(getTransRecordEntity().getStatusReversalReasonEnum()));

        //field 60
        StringBuilder sb = new StringBuilder();
        //60.1
        sb.append(getTransRecordEntity().getMsgFuncCode());
        //60.2
        sb.append(FormatUtils.appendArray(getTransRecordEntity().getMsgBatchNO(), 6, true, '0'));
        //60.3
        sb.append("000");

        //60.4
        CardType cardType = getTransRecordEntity().getCardTypeEnum();
        if (cardType == CardType.MANUAL
                || cardType == CardType.ICC
                || cardType == CardType.MAG) {
            sb.append("5");
        } else if (cardType == CardType.CTLS) {
            sb.append("6");
        } else {
            sb.append("0");
        }

        //60.5
        if (getTransRecordEntity().getCardFallback() && cardType == CardType.MAG) {
            sb.append("2");
        } else {
            sb.append("0");
        }
        //60.6
        sb.append("0");
        msg.setFieldValue(60, sb.toString());

        //field 61 // modify by hassan
        if (getTransRecordEntity().getMsgOrigBatchNO() != null
                && getTransRecordEntity().getMsgOrigBatchNO().length() > 0) {
            sb = new StringBuilder();
            //61.1
            sb.append(getTransRecordEntity().getMsgBatchNO());

            //61.2
            sb.append(getTransRecordEntity().getMsgTraceNO());
            msg.setFieldValue(61, sb.toString());
        }

        return msg.formMsg(2, gData.getSetupEntity().getCommuMsgLenTypeEnum());
    }

    private String getReversalCode(DataConstant.ReversalReason reversalReason) {
        String reversalCode;
        switch (reversalReason) {
            case MAC_ERR:
                reversalCode = "A0";
                break;

            case RECV_TIMEOUT:
                reversalCode = "98";
                break;

            default:
                reversalCode = "06";
                break;
        }

        return reversalCode;
    }
}
