package cn.nexgo.inbas.transactions.common.view.result;

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.os.Bundle;
import android.view.View;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.BounceInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import butterknife.BindView;
import butterknife.OnClick;
import cn.nexgo.inbas.R;
import cn.nexgo.inbas.common.base.BaseFragment;
import cn.nexgo.inbas.common.utils.TimeCounter;
import cn.nexgo.inbas.common.widget.autofittext.AutoFitTextView;
import cn.nexgo.utils.MixUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2018/1/17
 * Modify          : create file
 **************************************************************************************************/
public class CommonResultFragment extends BaseFragment {
    private static final String RESULT_DATA = "RESULT_DATA";
    @BindView(R.id.tv_result_msg)
    AutoFitTextView tv_result_msg;
    @BindView(R.id.tv_timer_msg)
    TextView tv_timer_msg;

    @BindView(R.id.ll_back)
    LinearLayout mLlBack;
    @BindView(R.id.iv_result)
    ImageView mIvResult;

    public static CommonResultFragment newInstance(ResultBean resultData) {
        Bundle bundle = new Bundle();
        bundle.putParcelable(RESULT_DATA, resultData);

        CommonResultFragment fragment = new CommonResultFragment();
        fragment.setArguments(bundle);

        return fragment;
    }

    @Override
    protected int getLayoutId() {
        return R.layout.common_result_fragment;
    }

    private ResultBean resultData;

    @Override
    protected void initData(Bundle savedInstanceState) {
        Bundle bundle = getArguments();
//        String tmpStr = bundle.getString(RESULT_DATA);
        if (bundle != null) {
            resultData = bundle.getParcelable(RESULT_DATA);
        }else{
            resultData = savedInstanceState.getParcelable(RESULT_DATA);
        }
        if (resultData == null) {
            resultData = new ResultBean();
        }
    }

    private TimeCounter timeCounter;

    @Override
    protected void initPresenter() {
        timeCounter = new TimeCounter();
        timeCounter.startTimer(60, timerListener);
    }

    private TimeCounter.Listener timerListener = new TimeCounter.Listener() {
        @Override
        public void onTimerProcess(long time) {
            tv_timer_msg.setText(String.valueOf(time));
        }

        @Override
        public void onFinish() {
            getActivity().onBackPressed();
        }
    };

    @Override
    protected void initView(View view) {
        if (resultData.isSuccess()) {
            mIvResult.setImageResource(R.drawable.img_success_face);
            tv_result_msg.setVisibility(View.GONE);
        } else {
            mIvResult.setImageResource(R.drawable.img_failed_face);
            tv_result_msg.setText(resultData.getMsg());
            tv_result_msg.setVisibility(View.VISIBLE);
        }

        startAnimation();
    }


    private void startAnimation() {
        AnimatorSet animatorSet = new AnimatorSet();
        //image
        ObjectAnimator animator = ObjectAnimator.ofFloat(mIvResult, "alpha", 0f, 1f);
        animator.setDuration(3000);

        //back button
        ObjectAnimator transXAnimation = null;
        if (MixUtils.isRTLLayout()){
            transXAnimation = ObjectAnimator.ofFloat(mLlBack, "translationX", -500f, 0f);
        }else{
            transXAnimation = ObjectAnimator.ofFloat(mLlBack, "translationX", 500f, 0f);
        }

        transXAnimation.setDuration(1500);
        transXAnimation.setInterpolator(new AnticipateOvershootInterpolator(2f));
        ObjectAnimator transYAnimation = ObjectAnimator.ofFloat(mLlBack, "translationY", -500f, 0f);
        transYAnimation.setDuration(1500);
        transYAnimation.setInterpolator(new BounceInterpolator());

        animatorSet.play(animator).with(transXAnimation).with(transYAnimation);
        animatorSet.start();
    }


    @OnClick({R.id.ll_back})
    public void onViewClicked(View view) {
        getActivity().onBackPressed();
    }

    @Override
    public void onDestroy() {
        timeCounter.cancel();
        super.onDestroy();
    }

}
