package cn.nexgo.inbas.transactions.common.protocol.utils;

import java.util.Arrays;

import cn.nexgo.inbas.components.commu.bean.CommuObject;
import cn.nexgo.inbas.transactions.common.protocol.model.TransComb;
import cn.nexgo.utils.ConvertUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2017/12/18
 * Modify          : create file
 **************************************************************************************************/
public class Cn8583Unzip implements CommuObject.UnZipDataAction {
    private byte[] recvBuf = new byte[1024];
    private int index = 0;
    private CommuObject.ErrorCode errorCode;
    @Override
    public byte[] getRealData(byte[] recvData) {
        System.arraycopy(recvData, 0, recvBuf, index, recvData.length);
        index += recvData.length;

        if(!isRecvOver()){
            return null;
        }

        return Arrays.copyOfRange(recvBuf, TransComb.ISO8583_OFFSET, index);
    }

    private boolean isRecvOver(){
        if(index < TransComb.ISO8583_OFFSET){
            return false;
        }
        long needLen = ConvertUtils.bytesHex2Long(recvBuf, 0, 2);
        if((index - 2) < needLen){
            return false;
        }
        if((index - 2) > needLen){
            errorCode = new CommuObject.ErrorCode(9, "format error");
            return false;
        }
        return true;
    }

    @Override
    public CommuObject.ErrorCode getErrorCode() {
        return errorCode;
    }
}
