package cn.nexgo.inbas.transactions.common.protocol.model;

import java.util.List;

import cn.nexgo.inbas.common.bean.ErrorCode;
import cn.nexgo.inbas.components.commu.ICommu;
import cn.nexgo.inbas.components.commu.bean.CommuObject;
import cn.nexgo.inbas.components.commu.socket.SocketObject;
import cn.nexgo.inbas.transactions.common.protocol.MsgModel;
import cn.nexgo.inbas.transactions.common.protocol.bean.MsgBean;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2018/1/12
 * Modify          : create file
 **************************************************************************************************/
public class TransLoopComb {
    private TransComb transComb;
    private int maxRetryTimes = 3;
    private TransLoopCB cb;
    private MsgBean.BaseTransEntity requestBean;
    private MsgBean.BaseTransEntity responseBaseBean;
    private ICommu commu;
    private List<SocketObject.SocketConnectEntity> socketConnectEntitys;
    private boolean disconnectAfterRecv;
    private int macKeyIndex;
    private boolean checkMacEn;
    private boolean addSTAN;
    public TransLoopComb(){
        transComb = new TransComb();
    }

    public void startTrans(ICommu commu, List<SocketObject.SocketConnectEntity> socketConnectEntitys,
                           boolean disconnectAfterRecv, boolean addSTAN, int macKeyIndex,
                           boolean checkMacEn, TransLoopCB cb, int maxRetryTimes){
        this.maxRetryTimes = maxRetryTimes;
        this.cb = cb;
        this.commu = commu;
        this.socketConnectEntitys = socketConnectEntitys;
        this.disconnectAfterRecv = disconnectAfterRecv;
        this.macKeyIndex = macKeyIndex;
        this.checkMacEn = checkMacEn;
        this.addSTAN = addSTAN;

        this.retryTimes = 0;
        transLoop();
    }

    private int retryTimes = 0;
    private void transLoop(){
//        requestBean = cb.getRequestEntity();

        for (; retryTimes < maxRetryTimes; retryTimes++) {
            requestBean = cb.getRequestEntity();
            if(requestBean != null){
                break;
            }
        }

        if(requestBean == null){
            finishLoopTrans();
            return;
        }

        responseBaseBean = cb.getResponseEntity();

        transComb.doTrans(commu, socketConnectEntitys, requestBean, responseBaseBean, false, macKeyIndex,
                checkMacEn, addSTAN, modelListener);
    }

    private MsgModel.ModelListener modelListener = new MsgModel.ModelListener() {
        @Override
        public void onConnectError(ErrorCode errorCode) {
            cb.onFail(errorCode);
        }

        @Override
        public void onConnectSuccess() {

        }

        @Override
        public void onSendError(ErrorCode errorCode) {
            transLoop();
        }

        @Override
        public void onSendSuccess() {

        }

        @Override
        public void onReceiveError(ErrorCode errorCode) {
            transLoop();
        }

        @Override
        public void onReceiveSuccess(MsgBean.BaseTransEntity responseBean) {
            cb.onUnitFinish(requestBean, responseBean);

            transLoop();
        }
    };

    private void finishLoopTrans(){
        if(!disconnectAfterRecv){
            cb.onFinish();
            return;
        }

        commu.disconnect(1000, new CommuObject.CommonResultListener() {
            @Override
            public void onSuccess() {
                cb.onFinish();
            }

            @Override
            public void onFail(CommuObject.ErrorCode error) {
                cb.onFinish();
            }
        });
    }

    public interface TransLoopCB{
        MsgBean.BaseTransEntity getRequestEntity();
        MsgBean.BaseTransEntity getResponseEntity();

        void onFail(ErrorCode errorCode);

        void onUnitFinish(MsgBean.BaseTransEntity requestBean, MsgBean.BaseTransEntity responseBaseBean);

        void onFinish();
    }

}
