package cn.nexgo.inbas.transactions.common.protocol.bean;

import com.nexgo.common.ByteUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import cn.nexgo.inbas.common.Constans.CardType;
import cn.nexgo.inbas.common.GData;
import cn.nexgo.inbas.components.data.DataConstant;
import cn.nexgo.inbas.components.data.bean.TransRecordEntity;
import cn.nexgo.protocol.iso8583.ConfigParser;
import cn.nexgo.protocol.iso8583.Message;
import cn.nexgo.protocol.iso8583.MessageFactory;
import cn.nexgo.utils.AppTlvUtils;
import cn.nexgo.utils.BitUtils;
import cn.nexgo.utils.ConvertUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2017/12/15
 * Modify          : create file
 **************************************************************************************************/
public class MsgBean {
    public static Logger mLog = LoggerFactory.getLogger(MsgBean.class.getSimpleName());

    private static MessageFactory iso8583MsgFactory;
    private static GData gData = GData.getInstance();

    public static boolean configCfgFile(InputStream is) {
        iso8583MsgFactory = ConfigParser.creatFromStream(is);
        if (iso8583MsgFactory == null) {
            mLog.error("configCfgFile error");
            return false;
        }
        return true;
    }

    private static boolean setField55(String field55Request, TransRecordEntity recordEntity) {
//        TlvUtils.decodingTLV()
        Map<String, String> field55Data = AppTlvUtils.parse(field55Request);
        if (field55Data == null) {
            return false;
        }
        String tmp;

        mLog.error("setField55->" + field55Request);

        tmp = field55Data.get("9F26");
        if (tmp != null) {
            recordEntity.setEmvAC(tmp);
        }

        tmp = field55Data.get("9F27");
        if (tmp != null) {
            recordEntity.setEmvCID(tmp);
        }

        tmp = field55Data.get("9F10");
        if (tmp != null) {
            recordEntity.setEmvIAD(tmp);
        }

        tmp = field55Data.get("9F37");
        if (tmp != null) {
            recordEntity.setEmvUN(tmp);
        }

        tmp = field55Data.get("9F36");
        if (tmp != null) {
            recordEntity.setEmvATC(tmp);
        }

        tmp = field55Data.get("95");
        if (tmp != null) {
            recordEntity.setEmvTVR(tmp);
        }

        tmp = field55Data.get("9A");
        if (tmp != null) {
            recordEntity.setEmvTransDate(tmp);
        }

        tmp = field55Data.get("9C");
        if (tmp != null) {
            recordEntity.setEmvTransType(tmp);
        }

        tmp = field55Data.get("9F02");
        if (tmp != null) {
            recordEntity.setEmvTransAmount(tmp);
        }

        tmp = field55Data.get("5F2A");
        if (tmp != null) {
            recordEntity.setEmvCurrencyCode(tmp);
        }

        tmp = field55Data.get("9F1A");
        if (tmp != null) {
            recordEntity.setEmvCountryCode(tmp);
        }

        tmp = field55Data.get("82");
        if (tmp != null) {
            recordEntity.setEmvAIP(tmp);
        }

        tmp = field55Data.get("9F33");
        if (tmp != null) {
            recordEntity.setEmvTermCap(tmp);
        }

        tmp = field55Data.get("9F34");
        if (tmp != null) {
            recordEntity.setEmvCVMResult(tmp);
        }

        tmp = field55Data.get("9F03");
        if (tmp != null) {
            recordEntity.setEmvAmountOther(tmp);
        }

        tmp = field55Data.get("84");
        if (tmp != null) {
            recordEntity.setEmvAID(tmp);
        }

        tmp = field55Data.get("9F08");
        if (tmp != null) {
            recordEntity.setEmvAppVer(tmp);
        }

        tmp = field55Data.get("9F09");
        if (tmp != null) {
            recordEntity.setEmvTermAppVer(tmp);
        }

        tmp = field55Data.get("9F35");
        if (tmp != null) {
            recordEntity.setEmvTermType(tmp);
        }

        tmp = field55Data.get("9F1E");
        if (tmp != null) {
            recordEntity.setEmvIFDSN(tmp);
        }

        tmp = field55Data.get("9F53");
        if (tmp != null) {
            recordEntity.setEmvCategoryCode(tmp);
        }

        tmp = field55Data.get("9F41");
        if (tmp != null) {
            recordEntity.setEmvTransSeqCnt(tmp);
        }

        tmp = field55Data.get("9F6E");
        if (tmp != null) {
            recordEntity.setEmvFFI(tmp);
        }

        tmp = field55Data.get("9F4C");
        if (tmp != null) {
            recordEntity.setEmvIDN(tmp);
        }

        tmp = field55Data.get("9F5D");
        if (tmp != null) {
            recordEntity.setEmvAOSA(tmp);
        }

        tmp = field55Data.get("9B");
        if (tmp != null) {
            recordEntity.setEmvTSI(tmp);
        }

        tmp = field55Data.get("5F34");
        if (tmp != null) {
            recordEntity.setEmvPanSN(tmp);
        }

        // FIXME: 2018/11/28 Hassan remark: fix tag 50 and 9f12 transfer
        tmp = field55Data.get("50");
        if (tmp != null) {
            tmp = new String(ByteUtils.hexString2ByteArray(tmp));
            mLog.debug("field55Data 50-->" + tmp);
            recordEntity.setEmvAppLabel(tmp);
        }

        tmp = field55Data.get("9F12");
        if (tmp != null) {
            tmp = new String(ByteUtils.hexString2ByteArray(tmp));
            recordEntity.setEmvAppPreferName(tmp);
        }

        tmp = field55Data.get("91");
        if (tmp != null) {
            recordEntity.setEmvIssAuthData(tmp);
        }

        tmp = field55Data.get("DF31");
        if (tmp != null) {
            recordEntity.setEmvScriptResult(tmp);
        }

        return true;
    }

    private static String getField55(Emv55FieldDOLType emv55FieldDOLType, TransRecordEntity recordEntity) {
        Map<String, String> field55Data;

        switch (emv55FieldDOLType) {
            case DOL_PAYPASS:
                field55Data = getEmvPaypass55Data(recordEntity);
                break;
            case DOL_PAYWAVE:
                field55Data = getEmvPaywave55Data(recordEntity);
                break;
            case DOL_SCRIPT:
                field55Data = getEmvScript55Data(recordEntity);
                break;
            case DOL_REVERSAL:
                field55Data = getEmvReversal55Data(recordEntity);
                break;
            default:
                field55Data = getEmvStandard55Data(recordEntity);
                break;
        }

        return AppTlvUtils.format(field55Data);
    }

    private static Map<String, String> getEmvStandard55Data(TransRecordEntity recordEntity) {
        Map<String, String> field55Data = new HashMap<>();

        field55Data.put("9F26", recordEntity.getEmvAC());
        field55Data.put("9F27", recordEntity.getEmvCID());
        field55Data.put("9F10", recordEntity.getEmvIAD());
        field55Data.put("9F37", recordEntity.getEmvUN());
        field55Data.put("9F36", recordEntity.getEmvATC());
        field55Data.put("95", recordEntity.getEmvTVR());
        field55Data.put("9A", recordEntity.getEmvTransDate());
        field55Data.put("9C", recordEntity.getEmvTransType());
        field55Data.put("9F02", recordEntity.getEmvTransAmount());
        field55Data.put("5F2A", recordEntity.getEmvCurrencyCode());
        field55Data.put("82", recordEntity.getEmvAIP());
        field55Data.put("9F1A", recordEntity.getEmvCountryCode());
        field55Data.put("9F03", recordEntity.getEmvAmountOther());
        field55Data.put("9F33", recordEntity.getEmvTermCap());
        field55Data.put("9F34", recordEntity.getEmvCVMResult());
        field55Data.put("9F35", recordEntity.getEmvTermType());
        field55Data.put("9F1E", recordEntity.getEmvIFDSN());
        field55Data.put("9F09", recordEntity.getEmvTermAppVer());
        field55Data.put("84", recordEntity.getEmvAID());
        field55Data.put("9F41", recordEntity.getEmvTransSeqCnt());
        field55Data.put("9F63", recordEntity.getEmvCardId());

        mLog.debug("field55Data -->" + field55Data);
        return field55Data;
    }

    private static Map<String, String> getEmvPaywave55Data(TransRecordEntity recordEntity) {
        Map<String, String> field55Data = new HashMap<>();

        field55Data.put("9F26", recordEntity.getEmvAC());
        field55Data.put("9F27", recordEntity.getEmvCID());
        field55Data.put("9F10", recordEntity.getEmvIAD());
        field55Data.put("9F37", recordEntity.getEmvUN());
        field55Data.put("9F36", recordEntity.getEmvATC());
        field55Data.put("95", recordEntity.getEmvTVR());
        field55Data.put("9A", recordEntity.getEmvTransDate());
        field55Data.put("9C", recordEntity.getEmvTransType());
        field55Data.put("9F02", recordEntity.getEmvTransAmount());
        field55Data.put("5F2A", recordEntity.getEmvCurrencyCode());
        field55Data.put("82", recordEntity.getEmvAIP());
        field55Data.put("9F1A", recordEntity.getEmvCountryCode());
        field55Data.put("9F03", recordEntity.getEmvAmountOther());
        field55Data.put("9F33", recordEntity.getEmvTermCap());
        field55Data.put("9F35", recordEntity.getEmvTermType());
        field55Data.put("9F1E", recordEntity.getEmvIFDSN());
        field55Data.put("9F09", recordEntity.getEmvTermAppVer());
        field55Data.put("84", recordEntity.getEmvAID());
        field55Data.put("9F41", recordEntity.getEmvTransSeqCnt());

        mLog.debug("field55Data -->" + field55Data);
        return field55Data;
    }

    private static Map<String, String> getEmvPaypass55Data(TransRecordEntity recordEntity) {
        Map<String, String> field55Data = new HashMap<>();

        field55Data.put("9F26", recordEntity.getEmvAC());
        field55Data.put("9F27", recordEntity.getEmvCID());
        field55Data.put("9F10", recordEntity.getEmvIAD());
        field55Data.put("9F37", recordEntity.getEmvUN());
        field55Data.put("9F36", recordEntity.getEmvATC());
        field55Data.put("95", recordEntity.getEmvTVR());
        field55Data.put("9A", recordEntity.getEmvTransDate());
        field55Data.put("9C", recordEntity.getEmvTransType());
        field55Data.put("9F02", recordEntity.getEmvTransAmount());
        field55Data.put("5F2A", recordEntity.getEmvCurrencyCode());
        field55Data.put("82", recordEntity.getEmvAIP());
        field55Data.put("9F03", recordEntity.getEmvAmountOther());
        field55Data.put("9F33", recordEntity.getEmvTermCap());
        field55Data.put("9F34", recordEntity.getEmvCVMResult());
        field55Data.put("9F35", recordEntity.getEmvTermType());
        field55Data.put("9F1E", recordEntity.getEmvIFDSN());
        field55Data.put("9F09", recordEntity.getEmvTermAppVer());
        field55Data.put("84", recordEntity.getEmvAID());
        field55Data.put("9F41", recordEntity.getEmvTransSeqCnt());

        mLog.debug("field55Data -->" + field55Data);
        return field55Data;
    }

    private static Map<String, String> getEmvReversal55Data(TransRecordEntity recordEntity) {
        Map<String, String> field55Data = new HashMap<>();

        field55Data.put("95", recordEntity.getEmvTVR());
        field55Data.put("9F1E", recordEntity.getEmvIFDSN());
        field55Data.put("9F10", recordEntity.getEmvIAD());
        field55Data.put("9F36", recordEntity.getEmvATC());
        field55Data.put("DF31", recordEntity.getEmvScriptResult());

        mLog.debug("field55Data -->" + field55Data);
        return field55Data;
    }

    private static Map<String, String> getEmvScript55Data(TransRecordEntity recordEntity) {
        Map<String, String> field55Data = new HashMap<>();

        field55Data.put("9F33", recordEntity.getEmvTermCap());
        field55Data.put("95", recordEntity.getEmvTVR());
        field55Data.put("9F37", recordEntity.getEmvUN());
        field55Data.put("9F1E", recordEntity.getEmvIFDSN());
        field55Data.put("9F10", recordEntity.getEmvIAD());
        field55Data.put("9F26", recordEntity.getEmvAC());
        field55Data.put("9F36", recordEntity.getEmvATC());
        field55Data.put("82", recordEntity.getEmvAIP());
        field55Data.put("DF31", recordEntity.getEmvScriptResult());
        field55Data.put("9F1A", recordEntity.getEmvCountryCode());
        field55Data.put("9A", recordEntity.getEmvTransDate());

        mLog.debug("field55Data -->" + field55Data);
        return field55Data;
    }

    public static class BaseTransEntity {
        private TransRecordEntity transRecordEntity = new TransRecordEntity();

        private String msgType = "0000";
        //        private String cardSequenceNumber;
        private String tk2;
        private String tk3;
        private String PIN;
        private String field55Response;
        private String mac = "0000000000000000";

        private Emv55FieldDOLType emv55FieldDOLType;

        protected BaseTransEntity() {
            transRecordEntity.setMsgPinCapCode("12");
        }

        protected Message setCommonDataIntoMsg(String bitmap) {
            if (iso8583MsgFactory == null) {
                mLog.error("pls configCfgFile fist");
                return null;
            }
            Message msg = iso8583MsgFactory.newMessage();
            msg.setHeader(gData.getSetupEntity().getCommuTPDU() + "613100313456");

            byte[] bitmapBytes = ConvertUtils.hexString2Bytes(bitmap);
            if ((bitmapBytes == null) || (bitmapBytes.length != 8)) {
                mLog.error("bitmap error");
                return null;
            }

            if (msg.setFieldValue(0, msgType) == null) {
                mLog.error("msgType->" + msgType);
                return null;
            }

            for (int i = 2; i <= 64; i++) {
                if (!BitUtils.getBitFromBytes(bitmapBytes, i - 1)) {
                    continue;
                }

                switch (i) {
                    case 2:
                        if (transRecordEntity.getCardTypeEnum() != CardType.MAG) {
                            if (msg.setFieldValue(2, transRecordEntity.getCardNoEnc()) == null) {
                                mLog.error("file 2 cardno error->" + transRecordEntity.getCardNoEnc());
                                return null;
                            }
                        }
                        break;
                    case 3:
                        if (msg.setFieldValue(3, transRecordEntity.getMsgProcCode()) == null) {
                            mLog.error("file 3 MsgProcCode error->" + transRecordEntity.getMsgProcCode());
                            return null;
                        }
                        break;
                    case 4:
                        if (msg.setFieldValue(4, transRecordEntity.getMsgAmount()) == null) {
                            mLog.error("file 4 MsgAmount error->" + transRecordEntity.getMsgAmount());
                            return null;
                        }
                        break;
                    case 11:
                        if (msg.setFieldValue(11, transRecordEntity.getMsgTraceNO()) == null) {
                            mLog.error("file 11 MsgTraceNO error->" + transRecordEntity.getMsgTraceNO());
                            return null;
                        }
                        break;
                    case 14:
                        mLog.debug("transRecordEntity.getCardExpDate()" + transRecordEntity.getCardExpDateEnc());
                        if (msg.setFieldValue(14, transRecordEntity.getCardExpDateEnc()) == null) {//modify by hassan
                            mLog.error("file 14 expiredDate error->" + transRecordEntity.getCardExpDateEnc());
                            return null;
                        }
                        break;
                    case 22:
                        String entryMode;
                        if (transRecordEntity.getCardTypeEnum() == CardType.MANUAL) {
                            entryMode = "01";
                        } else if ((transRecordEntity.getCardTypeEnum() == CardType.ICC) ||
                                (transRecordEntity.getCardTypeEnum() == CardType.CTLS)) {
                            if (transRecordEntity.getCardTypeEnum() == CardType.CTLS) {
                                switch (transRecordEntity.getCardCtlsTypeEnum()) {
//                                case FULLEMV: entryMode = "98";break;
                                    case QUICK:
                                        entryMode = "07";
                                        break;
                                    case MSD:
                                        entryMode = "91";
                                        break;
                                    default:
                                        entryMode = "07";//modify by hassan
                                        break;
                                }
                            } else {
                                entryMode = "05";
                            }
                        } else if (transRecordEntity.getCardTypeEnum() == CardType.MAG) {
                            entryMode = "02";
                        } else {
                            entryMode = "00";
                        }

                        if (PIN != null && PIN.length() > 0) {//modify by hassan
                            entryMode += "1";
                        } else {
                            entryMode += "2";
                        }

                        transRecordEntity.setMsgEntryMode(entryMode);
                        if (msg.setFieldValue(22, transRecordEntity.getMsgEntryMode()) == null) {
                            mLog.error("file 22 expiredDate error->" + transRecordEntity.getMsgEntryMode());
                            return null;
                        }
                        break;

                    case 23:
                        if ((transRecordEntity.getCardTypeEnum() != CardType.MANUAL)
                                && (transRecordEntity.getCardTypeEnum() != CardType.MAG)) {
                            if (transRecordEntity.getEmvPanSN() == null) {
                                transRecordEntity.setEmvPanSN("000");
                            }
                            if (msg.setFieldValue(23, transRecordEntity.getEmvPanSN()) == null) {
                                mLog.error("file 23 cardSequenceNumber error->" + transRecordEntity.getEmvPanSN());
                                return null;
                            }
                        }
                        break;
                    case 25:
                        if (msg.setFieldValue(25, transRecordEntity.getMsgConditionCode()) == null) {
                            mLog.error("file 25 MsgConditionCode error->" + transRecordEntity.getMsgConditionCode());
                            return null;
                        }
                        break;

                    case 26:
                        if (PIN != null && PIN.length() > 0) {//modify by hassan
                            if (msg.setFieldValue(26, transRecordEntity.getMsgPinCapCode()) == null) {
                                mLog.error("file 26 MsgPinCapCode error->" + transRecordEntity.getMsgPinCapCode());
                                return null;
                            }
                        }
                        break;

                    case 35:
                        if (msg.setFieldValue(35, tk2) == null) {
                            mLog.error("file 35 tk2 error->" + tk2);
                            return null;
                        }
                        break;

                    case 36:
                        if (msg.setFieldValue(36, tk3) == null) {
                            mLog.error("file 36 tk3 error->" + tk3);
                            return null;
                        }
                        break;
                    case 37:
                        if (msg.setFieldValue(37, transRecordEntity.getMsgRefNO()) == null) {
                            mLog.error("file 37 MsgRefNO error->" + transRecordEntity.getMsgRefNO());
                            return null;
                        }
                        break;
                    case 38:
                        if (msg.setFieldValue(38, transRecordEntity.getMsgAuthCode()) == null) {
                            mLog.error("file 38 MsgAuthCode error->" + transRecordEntity.getMsgAuthCode());
                            return null;
                        }
                        break;
                    case 41:
                        if (msg.setFieldValue(41, transRecordEntity.getMsgTermID()) == null) {
                            mLog.error("file 41 MsgTermID error->" + transRecordEntity.getMsgTermID());
                            return null;
                        }
                        break;

                    case 42:
                        if (msg.setFieldValue(42, transRecordEntity.getMsgMerchID()) == null) {
                            mLog.error("file 42 MsgMerchID error->" + transRecordEntity.getMsgMerchID());
                            return null;
                        }
                        break;

                    case 49:
                        if (msg.setFieldValue(49, transRecordEntity.getMsgCurrencyCode()) == null) {
                            mLog.error("file 49 MsgCurrencyCode error->" + transRecordEntity.getMsgCurrencyCode());
                            return null;
                        }
                        break;

                    case 52:
                        mLog.debug("52 PIN" + PIN);
                        //modify by hassan
                        if (PIN != null && PIN.length() > 0) {
                            if (msg.setFieldValue(52, PIN) == null) {
                                mLog.error("file 52 PIN error->" + PIN);
                                return null;
                            }
                        }
                        break;

                    case 53:
                        if ((PIN != null && PIN.length() > 0) || (tk2 != null) || (tk3 != null)) {
                            char[] tmp = new char[16];
                            Arrays.fill(tmp, '0');
                            if (PIN != null && PIN.length() > 0) {
                                tmp[0] = '2';
                            } else {
                                tmp[0] = '0';
                            }
                            if (gData.getSetupEntity().getSafeTripleDES()) {
                                tmp[1] = '6';
                            }

                            if (msg.setFieldValue(53, new String(tmp)) == null) {
                                mLog.error("file 53 error");
                                return null;
                            }
                        }
                        break;

                    case 55:
                        if ((getTransRecordEntity().getCardTypeEnum() != CardType.MANUAL)
                                && (getTransRecordEntity().getCardTypeEnum() != CardType.MAG)
                                && (getTransRecordEntity().getCardCtlsTypeEnum() != DataConstant.CtlsFlowType.MSD)) {
                            if (emv55FieldDOLType != null) {
                                if (msg.setFieldValue(55, getField55(emv55FieldDOLType, getTransRecordEntity())) == null) {
                                    mLog.error("file 55 ICC data error");
                                    return null;
                                }
                                mLog.debug("55" + getField55(emv55FieldDOLType, getTransRecordEntity()));
                            }
                        }
                        break;

                    case 64:
                        if (msg.setFieldValue(64, mac) == null) {
                            mLog.error("file 64 MAC error->" + mac);
                            return null;
                        }
                        break;

                    default:
                        break;
                }

            }
            return msg;
        }

        Message getCommonDataFromMsg(byte[] msgData, int offset) {
            if (iso8583MsgFactory == null) {
                mLog.error("pls configCfgFile fist");
                return null;
            }
            Message msg = iso8583MsgFactory.parseMsg(msgData, offset);
            if (msg == null) {
                mLog.error("msg format error");
                return null;
            }
            // FIXME: 2018/8/7 Hassan trace detail iso8583 message
            mLog.debug("receive -->>" + msg.toString());

            msgType = msg.getMsgType();
            getTransRecordEntity().setMsgProcCode(msg.getFieldValue(3));
            getTransRecordEntity().setMsgAmount(msg.getFieldValue(4));
            getTransRecordEntity().setMsgTraceNO(msg.getFieldValue(11));
            getTransRecordEntity().setMsgTermID(msg.getFieldValue(41));
            getTransRecordEntity().setMsgMerchID(msg.getFieldValue(42));
            getTransRecordEntity().setMsgTipAmount(msg.getFieldValue(48));
            getTransRecordEntity().setMsgCurrencyCode(msg.getFieldValue(49));
            getTransRecordEntity().setMsgTransTime(msg.getFieldValue(12));
            getTransRecordEntity().setMsgTransDate(msg.getFieldValue(13));
            getTransRecordEntity().setMsgSettlementDate(msg.getFieldValue(15));
            getTransRecordEntity().setMsgAcqID(msg.getFieldValue(32));
            getTransRecordEntity().setMsgRefNO(msg.getFieldValue(37));
            getTransRecordEntity().setMsgAuthCode(msg.getFieldValue(38));
            getTransRecordEntity().setMsgRespCode(msg.getFieldValue(39));
//            getTransRecordEntity().setMsgBalance(msg.getFieldValue(54));

            String field44 = msg.getFieldValue(44);   // field44
            if (field44 != null) {
                if (field44.length() < 12) {
                    mLog.error("field 44 errror->" + field44);
                    return null;
                }

                getTransRecordEntity().setMsgIssuerCode(field44.substring(0, 11).replaceAll(" ", ""));
                getTransRecordEntity().setMsgAcquirerCode(field44.substring(11).replaceAll(" ", ""));
            }

            field55Response = msg.getFieldValue(55);

            String field60 = msg.getFieldValue(60);   // field 60
            if ((field60 != null) && (field60.length() >= 8)) {
                getTransRecordEntity().setMsgFuncCode(field60.substring(0, 2));
                getTransRecordEntity().setMsgBatchNO(field60.substring(2, 8));
            }

            String field63 = msg.getFieldValue(63);   // field 63
            if ((field63 != null) && (field63.length() >= 3)) {
                getTransRecordEntity().setMsgInterOrgCode(field63.substring(0, 3));

                // TODO: 2017/12/22 63.2 field parse
                //noinspection StatementWithEmptyBody
                if (field63.length() >= 6) {

                }
            }

            mac = msg.getFieldValue(64);

            return msg;
        }

        /**
         * parseMsg
         *
         * @param msg msg
         * @return boolean
         */
        public boolean parseMsg(byte[] msg, int offset) {
            return (getCommonDataFromMsg(msg, offset) != null);
        }

        public byte[] packageMsg() {
            return null;
        }

        public void copyResponseData(TransRecordEntity entity) {
            transRecordEntity.setMsgTransTime(entity.getMsgTransTime());
            transRecordEntity.setMsgTransDate(entity.getMsgTransDate());
            transRecordEntity.setMsgSettlementDate(entity.getMsgSettlementDate());
            transRecordEntity.setMsgAcqID(entity.getMsgAcqID());
            transRecordEntity.setMsgRefNO(entity.getMsgRefNO());
            transRecordEntity.setMsgAuthCode(entity.getMsgAuthCode());
            transRecordEntity.setMsgRespCode(entity.getMsgRespCode());
            transRecordEntity.setEmvIssAuthData(entity.getEmvIssAuthDataByte());
            transRecordEntity.setMsgIssuerCode(entity.getMsgIssuerCode());
            transRecordEntity.setMsgAcquirerCode(entity.getMsgAcquirerCode());
            transRecordEntity.setMsgBalance(entity.getMsgBalance());

            transRecordEntity.setMsgFuncCode(entity.getMsgFuncCode());
            transRecordEntity.setMsgBatchNO(entity.getMsgBatchNO());
            transRecordEntity.setMsgInterOrgCode(entity.getMsgInterOrgCode());
            transRecordEntity.setMsgIssuerInfo(entity.getMsgIssuerInfo());
            transRecordEntity.setMsgCUPInfo(entity.getMsgCUPInfo());
            transRecordEntity.setMsgAcqInfo(entity.getMsgAcqInfo());
            transRecordEntity.setMsgTermReserved(entity.getMsgTermReserved());
        }

        public TransRecordEntity getTransRecordEntity() {
            return transRecordEntity;
        }

        public void setTransRecordEntity(TransRecordEntity transRecordEntity) {
            this.transRecordEntity = transRecordEntity;
        }

        public String getMsgType() {
            return msgType;
        }

        public void setMsgType(String msgType) {
            this.msgType = msgType;
        }

        public String getTk2() {
            return tk2;
        }

        public void setTk2(String tk2) {
            this.tk2 = tk2;
        }

        public String getTk3() {
            return tk3;
        }

        public void setTk3(String tk3) {
            this.tk3 = tk3;
        }

        public String getPIN() {
            return PIN;
        }

        public void setPIN(String PIN) {
            this.PIN = PIN;
        }

        public String getMac() {
            return mac;
        }

        public void setMac(String mac) {
            this.mac = mac;
        }

        public String getField55Response() {
            return field55Response;
        }

        public void setField55Response(String field55Response) {
            this.field55Response = field55Response;
        }

        public void setField55(String field55Str) {
            MsgBean.setField55(field55Str, getTransRecordEntity());
        }

        public Emv55FieldDOLType getEmv55FieldDOLType() {
            return emv55FieldDOLType;
        }

        public void setEmv55FieldDOLType(Emv55FieldDOLType emv55FieldDOLType) {
            this.emv55FieldDOLType = emv55FieldDOLType;
        }
    }
}
