package cn.nexgo.inbas.transactions.common.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import cn.nexgo.inbas.R;
import cn.nexgo.inbas.common.GData;
import cn.nexgo.inbas.common.bean.ErrorCode;
import cn.nexgo.inbas.components.commu.ICommu;
import cn.nexgo.inbas.components.commu.bean.CommuObject;
import cn.nexgo.inbas.components.commu.socket.SocketObject;
import cn.nexgo.inbas.components.commu.socket.SocketTrans;
import cn.nexgo.inbas.components.data.DataConstant;
import cn.nexgo.inbas.components.data.DataOpenHelper;
import cn.nexgo.inbas.transactions.common.protocol.bean.MsgBean;
import cn.nexgo.inbas.transactions.common.protocol.model.TransComb;
import cn.nexgo.inbas.transactions.common.protocol.model.TransLoopComb;
import cn.nexgo.utils.AppLogUtils;
import cn.nexgo.utils.BaseUtils;
import cn.nexgo.utils.FormatUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2017/12/18
 * Modify          : create file
 **************************************************************************************************/
public class MsgModel {
    private static boolean LOG_ENABLE = false;
    private static String LOG_TAG = "MsgModel";

    //** Error msg
    public static final ErrorCode Nokey = new ErrorCode(5, BaseUtils.getApp().getString(R.string.trans_error_nomackey));
    public static final ErrorCode MACError = new ErrorCode(6, BaseUtils.getApp().getString(R.string.trans_error_macerror));
    public static final ErrorCode ConnectError = new ErrorCode(7, BaseUtils.getApp().getString(R.string.trans_error_connecterror));
    public static final ErrorCode SendError = new ErrorCode(8, BaseUtils.getApp().getString(R.string.trans_error_senderror));
    public static final ErrorCode RecvError = new ErrorCode(9, BaseUtils.getApp().getString(R.string.trans_error_receiveerror));
    public static final ErrorCode ParamsError = new ErrorCode(10, BaseUtils.getApp().getString(R.string.trans_error_paramserror));

    private static GData gData = GData.getInstance();
    private static ICommu socket;
    private static ICommu sslSocket;
    public static void init(){

        // init 8583 config file
        try {
            InputStream is = BaseUtils.getApp().getAssets().open("iso8583.xml");
            MsgBean.configCfgFile(is);
            is.close();
        } catch (IOException e) {
            e.printStackTrace();
        }

        // init socket
        SocketObject.SocketInitEntity socketInitEntity;
        if(!gData.getSetupEntity().getCommuWithSSL()){
            socket = new SocketTrans();
            socketInitEntity = new SocketObject.SocketInitEntity();
            socket.init(socketInitEntity, 1000, new CommuObject.CommonResultListener() {
                @Override
                public void onSuccess() {
                    AppLogUtils.debug(LOG_ENABLE, LOG_TAG, "commu init onSuccess");
                }

                @Override
                public void onFail(CommuObject.ErrorCode error) {
                    AppLogUtils.error(LOG_ENABLE, LOG_TAG,  "commu init onFail->"+error.getMsg());
                }
            });
        }else{
            //  init ssl socket
            sslSocket = new SocketTrans();
            socketInitEntity = new SocketObject.SocketInitEntity();
            //cer or bks certificate
            socketInitEntity.setCerFilePath(DataConstant.APPDIR + "sslcrt.cer");
            socketInitEntity.setCerFilePwd(null);
            sslSocket.init(socketInitEntity, 1000, new CommuObject.CommonResultListener() {
                @Override
                public void onSuccess() {
                    AppLogUtils.debug(LOG_ENABLE, LOG_TAG,  "commu init onSuccess");
                }

                @Override
                public void onFail(CommuObject.ErrorCode error) {
                    AppLogUtils.error(LOG_ENABLE, LOG_TAG,  "commu init onFail->"+error.getMsg());
                }
            });
        }

    }

    private static ICommu getCommu(){
        if(!gData.getSetupEntity().getCommuWithSSL()){
            return socket;
        }
        return sslSocket;
    }

    public static void setCommonRequestData(MsgBean.BaseTransEntity requestData){
        requestData.getTransRecordEntity().setMsgMerchID(gData.getSetupEntity().getTermMID());
        requestData.getTransRecordEntity().setMsgTermID(gData.getSetupEntity().getTermTID());
        requestData.getTransRecordEntity().setMsgTraceNO(gData.getSetupEntity().getTransTraceNO());
        requestData.getTransRecordEntity().setMsgPinCapCode("12");
        requestData.getTransRecordEntity().setMsgCurrencyCode(gData.getSetupEntity().getTermCurrencyCode());
        requestData.getTransRecordEntity().setMsgBatchNO(gData.getSetupEntity().getTransBatchNO());
        requestData.getTransRecordEntity().setMsgCashierNO(gData.getMixData().getOperaterCode());

        String dateTime = new SimpleDateFormat("MMddHHmmss").format(new Date());
        requestData.getTransRecordEntity().setMsgTransDate(dateTime.substring(0, 4));
        requestData.getTransRecordEntity().setMsgTransTime(dateTime.substring(4));
    }

    public static void trans(MsgBean.BaseTransEntity requestBean, MsgBean.BaseTransEntity responseBean,
                             boolean incTransNo, boolean checkMac, boolean disconnectAfterRecv,
                             ModelListener listener){
        List<SocketObject.SocketConnectEntity> connectEntityList = new ArrayList<>();

        SocketObject.SocketConnectEntity socketConnectEntity = new SocketObject.SocketConnectEntity();
        socketConnectEntity.setPort(gData.getSetupEntity().getCommuHostPort1());
        socketConnectEntity.setAddr(gData.getSetupEntity().getCommuHostAddress1());
        connectEntityList.add(socketConnectEntity);

        socketConnectEntity = new SocketObject.SocketConnectEntity();
        socketConnectEntity.setPort(gData.getSetupEntity().getCommuHostPort2());
        socketConnectEntity.setAddr(gData.getSetupEntity().getCommuHostAddress2());
        connectEntityList.add(socketConnectEntity);

        new TransComb().doTrans(getCommu(), connectEntityList, requestBean,
                responseBean, disconnectAfterRecv,
                gData.getSetupEntity().getSafeTmkIndex(), checkMac, incTransNo, listener);
    }

    public static void loopTrans(boolean disconnectAfterRecv, boolean addSTAN, boolean checkMacEn, int maxRetryTimes, TransLoopComb.TransLoopCB cb){
        List<SocketObject.SocketConnectEntity> connectEntityList = new ArrayList<>();

        SocketObject.SocketConnectEntity socketConnectEntity = new SocketObject.SocketConnectEntity();
        socketConnectEntity.setPort(gData.getSetupEntity().getCommuHostPort1());
        socketConnectEntity.setAddr(gData.getSetupEntity().getCommuHostAddress1());
        connectEntityList.add(socketConnectEntity);

        socketConnectEntity = new SocketObject.SocketConnectEntity();
        socketConnectEntity.setPort(gData.getSetupEntity().getCommuHostPort2());
        socketConnectEntity.setAddr(gData.getSetupEntity().getCommuHostAddress2());
        connectEntityList.add(socketConnectEntity);

        new TransLoopComb().startTrans(getCommu(), connectEntityList, disconnectAfterRecv, addSTAN, gData.getSetupEntity().getSafeTmkIndex(),
                checkMacEn, cb, maxRetryTimes);
    }


    public static void disConnect(final ModelDisconnectListener listener){
        getCommu().disconnect(10, new CommuObject.CommonResultListener(){

            @Override
            public void onSuccess() {
                if(listener != null){
                    listener.onSuccess();
                }
            }

            @Override
            public void onFail(CommuObject.ErrorCode error) {
                if(listener != null){
                    listener.onFail(new ErrorCode(error.getCode(), error.getMsg()));
                }
            }
        });
    }

    public interface ModelListener{
        void onConnectError(ErrorCode errorCode);
        void onConnectSuccess();
        void onSendError(ErrorCode errorCode);
        void onSendSuccess();
        void onReceiveError(ErrorCode errorCode);
        void onReceiveSuccess(MsgBean.BaseTransEntity responseBean);
    }

    public interface ModelDisconnectListener{
        void onSuccess();
        void onFail(ErrorCode errorCode);
    }

    public static void incTransNo(){
        int stan = Integer.parseInt(gData.getSetupEntity().getTransTraceNO());
        stan = (stan+1)%1000000;
        if(stan == 0){
            stan = 1;
        }
        gData.getSetupEntity().setTransTraceNO(FormatUtils.appendArray(String.valueOf(stan), 6, true, '0'));
        DataOpenHelper.getInstance().getSetupRepository().update(gData.getSetupEntity());
    }

}
