package cn.nexgo.inbas.transactions.common.misc;

import cn.nexgo.inbas.R;
import cn.nexgo.inbas.common.base.BaseFragmentActivity;
import cn.nexgo.inbas.common.base.ConfirmAndCancelListener;
import cn.nexgo.inbas.components.data.bean.TransRecordEntity;
import cn.nexgo.inbas.components.others.print.Printer;
import cn.nexgo.utils.BaseUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2018/7/16
 * Modify          : create file
 **************************************************************************************************/
public class CommonPrint {

    private BaseFragmentActivity baseFragmentActivity;
    private String title;
    private String msg;
    private TransRecordEntity printSrc;
    private boolean pushPaper;
    private boolean isRePrint;
    private Printer.CopyType copyType;
    private Listener listener;

    public CommonPrint(BaseFragmentActivity baseFragmentActivity, String title, String msg, TransRecordEntity printSrc,
                       boolean pushPaper, boolean isRePrint, Printer.CopyType copyType, Listener listener) {
        this.baseFragmentActivity = baseFragmentActivity;
        this.title = title;
        this.msg = msg;
        this.printSrc = printSrc;
        this.pushPaper = pushPaper;
        this.isRePrint = isRePrint;
        this.copyType = copyType;
        this.listener = listener;
    }

    public void startPrint() {
        baseFragmentActivity.processDialog(true, title, msg);

//        PrinterQueue.startPrintBitmap(printSrc, pushPaper, printListener);
        Printer.startPrint(printSrc, pushPaper, isRePrint, copyType, printListener);
    }

    private Printer.PrintListener printListener = new Printer.PrintListener() {
        @Override
        public void onSuccess() {
            listener.onSuccess();
        }

        @Override
        public void onFail(Printer.ErrorType error) {
            baseFragmentActivity.processDialog(false, null, null);
            printerError(error);
        }
    };

    private void printerError(Printer.ErrorType errorType) {
        baseFragmentActivity.confirmAndCancelDialog(BaseUtils.getApp().getString(R.string.error),
                Printer.errorType2Str(errorType),
                BaseUtils.getApp().getString(R.string.cancel),
                BaseUtils.getApp().getString(R.string.appcontinue), printFailConfirmDialog);
    }

    private ConfirmAndCancelListener printFailConfirmDialog = new ConfirmAndCancelListener() {
        @Override
        public void onConfirm() {
            listener.onContinue();
        }

        @Override
        public void onCancel() {
            listener.onCancel();
        }
    };

    public interface Listener {
        void onSuccess();

        void onCancel();

        void onContinue();
    }

}
