package cn.nexgo.inbas.transactions.common.commontrans;

import com.google.gson.Gson;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.nexgo.inbas.common.GData;
import cn.nexgo.inbas.common.bean.ErrorCode;
import cn.nexgo.inbas.components.data.DataConstant;
import cn.nexgo.inbas.components.data.DataOpenHelper;
import cn.nexgo.inbas.components.data.bean.TransRecordEntity;
import cn.nexgo.inbas.controller.global.TransType;
import cn.nexgo.inbas.transactions.common.protocol.MsgModel;
import cn.nexgo.inbas.transactions.common.protocol.bean.MsgBean;
import cn.nexgo.inbas.transactions.common.protocol.model.TransLoopComb;
import cn.nexgo.inbas.transactions.reversal.ReversalEntity;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2018/1/5
 * Modify          : create file
 **************************************************************************************************/
public class ExtraTrans {
    private Logger log = LoggerFactory.getLogger(ExtraTrans.class.getSimpleName());

    private void addTestData() {
        DataOpenHelper.getInstance().getTransRecordRepository().deleteAll();
        TransRecordEntity recordEntity = new Gson().fromJson("{\"cardCtlsFlowType\":0,\"cardFallback\":false,\"cardNo\":\"6251690925791718\",\"cardType\":1,\"emvAC\":\"CBCF254BB162A31C\",\"emvAID\":\"A000000333010102\",\"emvAIP\":\"7C00\",\"emvATC\":\"0112\",\"emvAmountOther\":\"000000000000\",\"emvAppLabel\":\"50424F4320435245444954\",\"emvAppPreferName\":\"50424F4320435245444954\",\"emvAppVer\":\"0030\",\"emvCID\":\"40\",\"emvCVMResult\":\"420300\",\"emvCategoryCode\":\"52\",\"emvCountryCode\":\"0156\",\"emvCurrencyCode\":\"0156\",\"emvIAD\":\"07020103602402010A01000000000048B5C6B3\",\"emvIDN\":\"0112\",\"emvIFDSN\":\"3030303131313133\",\"emvIssAuthData\":\"\",\"emvPanSN\":\"01\",\"emvTSI\":\"E800\",\"emvTVR\":\"00A004E000\",\"emvTermAppVer\":\"0020\",\"emvTermCap\":\"E0E9C8\",\"emvTermType\":\"22\",\"emvTransAmount\":\"000000002000\",\"emvTransDate\":\"000000\",\"emvTransSeqCnt\":\"00000031\",\"emvTransType\":\"00\",\"emvUN\":\"13B3A8D3\",\"id\":4,\"msgAIID\":\"00010000\",\"msgAmount\":\"2000\",\"msgAuthCode\":\"125658\",\"msgConditionCode\":\"00\",\"msgCurrencyCode\":\"156\",\"msgEntryMode\":\"071\",\"msgInterOrgCode\":\"CUP\",\"msgMerchID\":\"123456789012345\",\"msgPinCapCode\":\"12\",\"msgProcCode\":\"000000\",\"msgRefNO\":\"123456789012\",\"msgRespCode\":\"00\",\"msgTermID\":\"12345678\",\"msgTraceNO\":\"31\",\"msgTransDate\":\"0110\",\"msgTransTime\":\"175230\",\"statusAdjusted\":false,\"statusAdjustedTimes\":0,\"statusBatchUpload\":1,\"statusIccFailTrans\":false,\"statusNeedPrint\":false,\"statusNeedReversal\":false,\"statusNeedScript\":false,\"statusOffineUpload\":-1,\"statusOffline\":false,\"statusReversalReason\":0,\"statusVoided\":false,\"transID\":4}",
                TransRecordEntity.class);

        recordEntity.setId(null);
        recordEntity.setTransType(TransType.SALE);
        recordEntity.setMsgTraceNO("56");
        recordEntity.setStatusIccFailTrans(false);
        recordEntity.setStatusOffline(true);
        recordEntity.setStatusOffineUpload(DataConstant.OffUploadStatus.OFFLINE_NONE);
        DataOpenHelper.getInstance().getTransRecordRepository().insert(recordEntity);

        recordEntity.setId(null);
        recordEntity.setTransType(TransType.SALE);
        recordEntity.setMsgTraceNO("78");
        recordEntity.setStatusIccFailTrans(false);
        recordEntity.setStatusOffline(true);
        DataOpenHelper.getInstance().getTransRecordRepository().insert(recordEntity);
    }

    private GData gData = GData.getInstance();
    private CommonTransExtransListener extraTransListener;
    private boolean needReversal;
    private boolean needOfflineUpload;
    private boolean needScriptUpload;

    public void start(boolean needReversal, boolean needIccOfflineUpload, boolean needScriptUpload, CommonTransExtransListener listener) {

        log.debug("pre trans->start");
//        addTestData();
        log.debug("pre trans->addTestData");
        extraTransListener = listener;
        this.needReversal = needReversal;
        this.needOfflineUpload = needIccOfflineUpload;
        this.needScriptUpload = needScriptUpload;

//        iccOfflineUpload();
        reversal();
    }

    /**
     * ICC offline upload
     */
//    private void iccOfflineUpload() {
//        if (!needOfflineUpload) {
//            scriptUpload();
//            return;
//        }
//        log.debug("pre trans->iccOfflineUpload");
//
//        dbOffset = 0;
//
//        MsgModel.loopTrans(false, true, true, gData.getSetupEntity().getTransOffTransUpTimes(), iccOfflineUploadListener);
//    }
//
//    private TransLoopComb.TransLoopCB iccOfflineUploadListener = new TransLoopComb.TransLoopCB() {
//        @Override
//        public MsgBean.BaseTransEntity getRequestEntity() {
//            TransRecordEntity record = DataOpenHelper.getInstance().getTransRecordRepository().getOfflineUploadIcc(dbOffset);
//            if (record == null) {
//                dbOffset = 0;
//                return null;
//            }
//
//            dbOffset++;
//            UploadIcOfflineEntity request = new UploadIcOfflineEntity();
//            record.setId(null);
//            request.setTransRecordEntity(record);
//            return request;
//        }
//
//        @Override
//        public MsgBean.BaseTransEntity getResponseEntity() {
//            return new UploadIcOfflineEntity();
//        }
//
//        @Override
//        public void onFail(ErrorCode errorCode) {
//            extraTransListener.onFail(errorCode);
//        }
//
//        @Override
//        public void onUnitFinish(MsgBean.BaseTransEntity requestBean, MsgBean.BaseTransEntity responseBean) {
//            TransRecordEntity record = DataOpenHelper.getInstance().getTransRecordRepository().getOfflineUploadIcc(dbOffset - 1);
//            if ("00".equals(responseBean.getTransRecordEntity().getMsgRespCode()) ||
//                    "94".equals(responseBean.getTransRecordEntity().getMsgRespCode())) {
//                record.setStatusOffineUpload(DataConstant.OffUploadStatus.OFFLINE_SUCCESS);
//            } else {
//                record.setStatusOffineUpload(DataConstant.OffUploadStatus.OFFLINE_DECLINE);
//            }
//            DataOpenHelper.getInstance().getTransRecordRepository().update(record);
//        }
//
//        @Override
//        public void onFinish() {
//            if (DataOpenHelper.getInstance().getTransRecordRepository().getOfflineUploadIcc(dbOffset) != null) {
//                extraTransListener.onFail(new ErrorCode(-1, BaseUtils.getApp().getString(R.string.trans_error_over_max_retry_times)));
//                return;
//            }
//            tipsOfflineUpload();
//        }
//    };
//
//    /**
//     * tips offline upload
//     */
//    private void tipsOfflineUpload() {
//        dbOffset = 0;
//        log.debug("pre trans->tipsOfflineUpload");
//        MsgModel.loopTrans(false, false, true, gData.getSetupEntity().getTransOffTransUpTimes(), tipsOfflineUploadListener);
//    }
//
//    private TransLoopComb.TransLoopCB tipsOfflineUploadListener = new TransLoopComb.TransLoopCB() {
//        @Override
//        public MsgBean.BaseTransEntity getRequestEntity() {
//            TransRecordEntity record = DataOpenHelper.getInstance().getTransRecordRepository().getOfflineUploadTip(dbOffset);
//            if (record == null) {
//                dbOffset = 0;
//                return null;
//            }
//
//            dbOffset++;
//            TipEntity request = new TipEntity();
//            request.setTransRecordEntity(record);
////            MsgModel.setCommonRequestData(request);
//            return request;
//        }
//
//        @Override
//        public MsgBean.BaseTransEntity getResponseEntity() {
//            return new TipEntity();
//        }
//
//        @Override
//        public void onFail(ErrorCode errorCode) {
//            extraTransListener.onFail(errorCode);
//        }
//
//        @Override
//        public void onUnitFinish(MsgBean.BaseTransEntity requestBean, MsgBean.BaseTransEntity responseBean) {
//            log.debug("pre trans->tipsOfflineUpload————onUnitFinish");
//            if ("00".equals(responseBean.getTransRecordEntity().getMsgRespCode()) ||
//                    "94".equals(responseBean.getTransRecordEntity().getMsgRespCode())) {
//                requestBean.getTransRecordEntity().setStatusOffineUpload(DataConstant.OffUploadStatus.OFFLINE_SUCCESS);
//            } else {
//                requestBean.getTransRecordEntity().setStatusOffineUpload(DataConstant.OffUploadStatus.OFFLINE_DECLINE);
//            }
//            DataOpenHelper.getInstance().getTransRecordRepository().update(requestBean.getTransRecordEntity());
//        }
//
//        @Override
//        public void onFinish() {
//            log.debug("pre trans->tipsOfflineUpload————onFinish");
//            if (DataOpenHelper.getInstance().getTransRecordRepository().getOfflineUploadTip(dbOffset) != null) {
//                extraTransListener.onFail(new ErrorCode(-1, BaseUtils.getApp().getString(R.string.trans_error_over_max_retry_times)));
//                return;
//            }
//            scriptUpload();
//        }
//    };
//
//    /**
//     *
//     */
//    private void scriptUpload() {
//        if (!needScriptUpload) {
//            reversal();
//            return;
//        }
//        log.debug("pre trans->scriptUpload");
//        MsgModel.loopTrans(false, true, true, gData.getSetupEntity().getTransOffTransUpTimes(), scriptUploadListener);
//    }
//
//    private TransLoopComb.TransLoopCB scriptUploadListener = new TransLoopComb.TransLoopCB() {
//        @Override
//        public MsgBean.BaseTransEntity getRequestEntity() {
//            TransRecordEntity record = DataOpenHelper.getInstance().getTransRecordRepository().getScriptUpload(dbOffset);
//            if (record == null) {
//                dbOffset = 0;
//                return null;
//            }
//
//            dbOffset++;
//            record.setId(null);
//            record.setMsgOrigTraceNO(record.getMsgTraceNO());
//            record.setMsgOrigBatchNO(record.getMsgBatchNO());
//            record.setMsgOrigDate(record.getMsgTransDate());
//            ScriptEntity request = new ScriptEntity();
//            request.setTransRecordEntity(record);
//            record.setMsgTraceNO(gData.getSetupEntity().getTransTraceNO());
////            MsgModel.setCommonRequestData(request);
//            return request;
//        }
//
//        @Override
//        public MsgBean.BaseTransEntity getResponseEntity() {
//            return new ScriptEntity();
//        }
//
//        @Override
//        public void onFail(ErrorCode errorCode) {
//            extraTransListener.onFail(errorCode);
//        }
//
//        @Override
//        public void onUnitFinish(MsgBean.BaseTransEntity requestBean, MsgBean.BaseTransEntity responseBean) {
//            TransRecordEntity record = DataOpenHelper.getInstance().getTransRecordRepository().getScriptUpload(dbOffset - 1);
//
//            record.setStatusNeedScript(false);
//            DataOpenHelper.getInstance().getTransRecordRepository().update(record);
//        }
//
//        @Override
//        public void onFinish() {
//            while (true) {
//                TransRecordEntity record = DataOpenHelper.getInstance().getTransRecordRepository().getScriptUpload(0);
//                if (record == null) {
//                    break;
//                }
//                record.setStatusNeedScript(false);
//                DataOpenHelper.getInstance().getTransRecordRepository().update(record);
//            }
//            reversal();
//        }
//    };

    /**
     * do reversal
     */
    private int dbOffset = 0;

    private void reversal() {
        if (!needReversal) {
            extraTransListener.onSuccess();
            return;
        }
        log.debug("pre trans->reversal");
        dbOffset = 0;
        MsgModel.loopTrans(false, false, true, gData.getSetupEntity().getTransReversalTimes(), reversalListener);
    }

    private TransLoopComb.TransLoopCB reversalListener = new TransLoopComb.TransLoopCB() {
        @Override
        public MsgBean.BaseTransEntity getRequestEntity() {
            TransRecordEntity record = DataOpenHelper.getInstance().getTransRecordRepository().getNeedReversal(dbOffset);
            if (record == null) {
                dbOffset = 0;
                return null;
            }

            dbOffset++;
            ReversalEntity request = new ReversalEntity();
            request.setTransRecordEntity(record);
            return request;
        }

        @Override
        public MsgBean.BaseTransEntity getResponseEntity() {
            return new ReversalEntity();
        }

        @Override
        public void onFail(ErrorCode errorCode) {
            extraTransListener.onFail(errorCode);
        }

        @Override
        public void onUnitFinish(MsgBean.BaseTransEntity requestBean, MsgBean.BaseTransEntity responseBase) {
            if ("00".equals(responseBase.getTransRecordEntity().getMsgRespCode()) ||
                    "12".equals(responseBase.getTransRecordEntity().getMsgRespCode()) ||
                    "25".equals(responseBase.getTransRecordEntity().getMsgRespCode())) {
                dbOffset--;
                DataOpenHelper.getInstance().getTransRecordRepository().delete(requestBean.getTransRecordEntity());
                return;
            }
        }

        @Override
        public void onFinish() {
            DataOpenHelper.getInstance().getTransRecordRepository().deleteReversal();
            extraTransListener.onSuccess();
        }
    };
}
