package cn.nexgo.inbas.controller.mechantcenter.syssetting.view;


import android.os.Bundle;
import android.view.View;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.TextView;

import butterknife.BindView;
import butterknife.OnClick;
import cn.nexgo.inbas.R;
import cn.nexgo.inbas.common.GData;
import cn.nexgo.inbas.common.base.BaseFragment;
import cn.nexgo.inbas.common.widget.EditSettingsDialog;
import cn.nexgo.inbas.components.data.DataOpenHelper;
import cn.nexgo.inbas.components.data.bean.SetupEntity;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * File Name     : SetupCommuFragment.java
 * Usage         : 
 * Version       : 1
 * Author        : Brad
 * Date          : 2017/12/24 
 * Modification  : Created file

 **************************************************************************************************/
public class SetupCommuFragment extends BaseFragment {

    @BindView(R.id.cbSSL)
    CheckBox cbSSL;
    @BindView(R.id.tv_tpdu)
    TextView tvTpdu;
    @BindView(R.id.rl_tpdu)
    LinearLayout rlTpdu;
    @BindView(R.id.tv_nii)
    TextView tvNii;
    @BindView(R.id.rl_nii)
    LinearLayout rlNii;
    @BindView(R.id.tv_connect_timeout)
    TextView tvConnectTimeout;
    @BindView(R.id.rl_connect_timeout)
    LinearLayout rlConnectTimeout;
    @BindView(R.id.tv_receive_timeout)
    TextView tvReceiveTimeout;
    @BindView(R.id.rl_receive_timeout)
    LinearLayout rlReceiveTimeout;
    @BindView(R.id.tv_host_address1)
    TextView tvHostAddress1;
    @BindView(R.id.rl_host_address1)
    LinearLayout rlHostAddress1;
    @BindView(R.id.tv_host_port1)
    TextView tvHostPort1;
    @BindView(R.id.rl_host_port1)
    LinearLayout rlHostPort1;
    @BindView(R.id.tv_host_address2)
    TextView tvHostAddress2;
    @BindView(R.id.rl_host_address2)
    LinearLayout rlHostAddress2;
    @BindView(R.id.tv_host_port2)
    TextView tvHostPort2;
    @BindView(R.id.rl_host_port2)
    LinearLayout rlHostPort2;

    private SetupEntity entity;

    public SetupCommuFragment() {
        // Required empty public constructor
    }

    @Override
    protected int getLayoutId() {
        return R.layout.syssetting_activity_commu_fragment;
    }

    @Override
    protected void initData(Bundle savedInstanceState) {
        this.entity = GData.getInstance().getSetupEntity();
    }

    @Override
    protected void initPresenter() {
    }

    @Override
    protected void initView(View view) {
        tvTpdu.setText(entity.getCommuTPDU());
        tvNii.setText(entity.getCommuNII());
        tvConnectTimeout.setText(String.valueOf(entity.getCommuConnectTimeout()));
        tvReceiveTimeout.setText(String.valueOf(entity.getCommuRecvTimeout()));
        tvHostAddress1.setText(entity.getCommuHostAddress1());
        tvHostPort1.setText(entity.getCommuHostPort1());
        tvHostAddress2.setText(entity.getCommuHostAddress2());
        tvHostPort2.setText(entity.getCommuHostPort2());

        cbSSL.setChecked(entity.getCommuWithSSL());
    }

    private void saveSettings() {

        entity.setCommuTPDU(tvTpdu.getText().toString());
        entity.setCommuNII(tvNii.getText().toString());
        entity.setCommuConnectTimeout(Integer.parseInt(tvConnectTimeout.getText().toString()));
        entity.setCommuRecvTimeout(Integer.parseInt(tvReceiveTimeout.getText().toString()));
        entity.setCommuHostAddress1(tvHostAddress1.getText().toString());
        entity.setCommuHostPort1(tvHostPort1.getText().toString());
        entity.setCommuHostAddress2(tvHostAddress2.getText().toString());
        entity.setCommuHostPort2(tvHostPort2.getText().toString());
        entity.setCommuWithSSL(cbSSL.isChecked());

        DataOpenHelper.getInstance().getSetupRepository().update(entity);
    }

    @Override
    public void onPause() {
        super.onPause();
        saveSettings();
    }

    @OnClick({R.id.rl_tpdu, R.id.rl_nii, R.id.rl_connect_timeout, R.id.rl_receive_timeout, R.id.rl_host_address1, R.id.rl_host_port1, R.id.rl_host_address2, R.id.rl_host_port2})
    public void onViewClicked(View view) {
        switch (view.getId()) {
            case R.id.rl_tpdu:
                doEdit(tvTpdu, EditSettingsDialog.InputType.NUM, 10, 10, 0, -1, getString(R.string.setting_tpdu));
                break;
            case R.id.rl_nii:
                doEdit(tvNii, EditSettingsDialog.InputType.NUM, 1,2, 0, -1, getString(R.string.setting_NII));
                break;
            case R.id.rl_connect_timeout:
                doEdit(tvConnectTimeout, EditSettingsDialog.InputType.NUM, 1,2, 0, 999, getString(R.string.setting_connect_timeout));
                break;
            case R.id.rl_receive_timeout:
                doEdit(tvReceiveTimeout, EditSettingsDialog.InputType.NUM, 1,2, 0, 999, getString(R.string.setting_recv_timeout));
                break;
            case R.id.rl_host_address1:
                doEdit(tvHostAddress1, EditSettingsDialog.InputType.STR, 8,126, 0, -1, getString(R.string.setting_host_address1));
                break;
            case R.id.rl_host_port1:
                doEdit(tvHostPort1, EditSettingsDialog.InputType.NUM, 1, 6, 1, 65535, getString(R.string.setting_host_port1));
                break;
            case R.id.rl_host_address2:
                doEdit(tvHostAddress2, EditSettingsDialog.InputType.STR, 8,126, 0, -1, getString(R.string.setting_host_address2));
                break;
            case R.id.rl_host_port2:
                doEdit(tvHostPort2, EditSettingsDialog.InputType.NUM, 1, 6, 1, 65535, getString(R.string.setting_host_port2));
                break;
        }
    }


    private void doEdit(final TextView content, EditSettingsDialog.InputType inputType, int minlen, int maxLen, long minValue, long maxValue, String title) {

        final EditSettingsDialog dialog = new EditSettingsDialog(getContext(), inputType, minlen, maxLen);
        dialog.setTitle(title);
        dialog.setMinValue(minValue);
        dialog.setMaxValue(maxValue);
        dialog.setDefaultValue(content.getText().toString());
        dialog.setOnBackClickListener(new EditSettingsDialog.OnBackClickListener() {
            @Override
            public void onBackClick() {
                dialog.dismiss();
            }
        });
        dialog.setOnOkClickListener(new EditSettingsDialog.OnOkClickListener() {
            @Override
            public void onOkClick() {
                content.setText(dialog.getLine2text());
                dialog.dismiss();
            }
        });
        dialog.show();
    }

}
