package cn.nexgo.inbas.controller.mechantcenter.syssetting;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import android.view.WindowManager;
import android.widget.TextView;

import butterknife.BindView;
import cn.nexgo.inbas.R;
import cn.nexgo.inbas.common.base.BaseFragmentActivity;
import cn.nexgo.inbas.common.widget.ToolBar;
import cn.nexgo.inbas.common.widget.verticaltablayout.VerticalTabLayout;
import cn.nexgo.inbas.common.widget.verticaltablayout.adapter.TabAdapter;
import cn.nexgo.inbas.common.widget.verticaltablayout.widget.TabView;
import cn.nexgo.inbas.controller.mechantcenter.syssetting.view.SetupCommuFragment;
import cn.nexgo.inbas.controller.mechantcenter.syssetting.view.SetupTermFragment;
import cn.nexgo.utils.BaseUtils;

public class SysSettingActivity extends BaseFragmentActivity {

    @BindView(R.id.tb)
    ToolBar tb;
    @BindView(R.id.tv_version)
    TextView tvVersion;

    @Override
    protected int getContextViewId() {
        return R.id.flContent;
    }

    @Override
    protected int getLayoutId() {
        return R.layout.syssetting_activity;
    }

    @BindView(R.id.tlMenu)
    VerticalTabLayout tlMenu;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);

        tlMenu.setTabAdapter(tabAdapter);
        tlMenu.addOnTabSelectedListener(tabSelectedListener);

        setupTermFragment = new SetupTermFragment();
        FragmentTransaction ft = getSupportFragmentManager().beginTransaction();
        ft.add(R.id.flContent, setupTermFragment);
        ft.commit();

        tb.setTitle(getString(R.string.setting));
        tb.setBackOnclickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });

        showAppVersion();
    }

    private void showAppVersion() {
        try {
            PackageManager pm = getPackageManager();
            PackageInfo pi = pm.getPackageInfo(getPackageName(),
                    PackageManager.GET_CONFIGURATIONS);
            tvVersion.setText(pi.versionName);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private VerticalTabLayout.OnTabSelectedListener tabSelectedListener = new VerticalTabLayout.OnTabSelectedListener() {
        @Override
        public void onTabSelected(TabView tab, int position) {
            FragmentTransaction ft = getSupportFragmentManager().beginTransaction();
            switch (position) {
                case 0:
                    hideAllFragmentAndKeyboard();
                    if (setupTermFragment == null) {
                        setupTermFragment = new SetupTermFragment();
                        ft.add(R.id.flContent, setupTermFragment);
                    } else {
                        ft.show(setupTermFragment);
                    }
                    ft.commit();
                    break;
                case 1:
                    hideAllFragmentAndKeyboard();
                    if (setupCommuFragment == null) {
                        setupCommuFragment = new SetupCommuFragment();
                        ft.add(R.id.flContent, setupCommuFragment);
                    } else {
                        ft.show(setupCommuFragment);
                    }
                    ft.commit();
                    break;
                default:
                    break;
            }
        }

        @Override
        public void onTabReselected(TabView tab, int position) {

        }
    };

    private void hideAllFragmentAndKeyboard() {
        hideAllFragment();
//        hideSoftInput();
    }

    private String[] title = {
            BaseUtils.getApp().getString(R.string.setting_terminal),
            BaseUtils.getApp().getString(R.string.setting_commu)
    };

    private TabAdapter tabAdapter = new TabAdapter() {
        @Override
        public int getCount() {
            return title.length;
        }

        @Override
        public TabView.TabBadge getBadge(int position) {
            return null;
        }

        @Override
        public TabView.TabIcon getIcon(int position) {
            return null;
        }

        @Override
        public TabView.TabTitle getTitle(int position) {
            return new TabView.TabTitle.Builder()
                    .setContent(title[position])
                    .setTextColor(0xFF000000, 0xFF000000)
                    .setTextSize(14)
                    .build();
        }

        @Override
        public int getBackground(int position) {
            return -1;
        }
    };

    private SetupTermFragment setupTermFragment;
    private SetupCommuFragment setupCommuFragment;

    private void hideAllFragment() {
        FragmentManager fm = getSupportFragmentManager();
        FragmentTransaction ft = fm.beginTransaction();
        if ((setupTermFragment != null) && !setupTermFragment.isHidden()) {
            ft.hide(setupTermFragment);
        }
        if ((setupCommuFragment != null) && !setupCommuFragment.isHidden()) {
            ft.hide(setupCommuFragment);
        }
        ft.commit();
    }

    @Override
    protected void onPause() {
        super.onPause();
        finish();
    }

}
