package cn.nexgo.inbas.controller.global;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * File Name     : TransHelper.java
 * Usage         : Transaction assistant class
 * Version       : 1
 * Author        : lee
 * Date          : 2018/10/11
 * Modification  : Created file

 **************************************************************************************************/
public class TransHelper {

    /**
     * 判断交易响应码是否成功
     * whether the transaction response code is successful
     * @param responseCode 后台39域响应码 response code of field 39
     * @return true 交易成功 successful
     */
    public static boolean isSuccessful(String responseCode) {
        return "00".equalsIgnoreCase(responseCode);
//                || "11".equalsIgnoreCase(responseCode)
//                || "16".equalsIgnoreCase(responseCode)
//                || "A2".equalsIgnoreCase(responseCode)
//                || "A4".equalsIgnoreCase(responseCode)
//                || "A5".equalsIgnoreCase(responseCode)
//                || "A6".equalsIgnoreCase(responseCode);
    }

    /**
     * 根据响应码获取响应描述
     * Response description based on response code
     * @param responseCode 响应码 response code
     * @return 返回响应描述 Response description
     */
    public static String getResponseCodeErrorInfo(String responseCode) {
        try {
            Properties properties = new Properties();
            String path;
//            if (App.isZh()) {
//                path = "/assets/response_code.properties";
//            } else {
                path = "/assets/response_code_en.properties";
//            }
            InputStream inputStream = TransHelper.class.getResourceAsStream(path);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            properties.load(bufferedReader);
            return properties.getProperty(responseCode);
        } catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}
