package cn.nexgo.inbas.components.input.readcard.internal;


import cn.nexgo.inbas.components.input.readcard.ReadCardData;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           :
 * Version         : 1
 * Author          : zhouxie
 * Date            : 2017/12/11
 * Modify          : create file
 **************************************************************************************************/

public interface ReadCardContract {
    interface View {
        /**
         * magcard callback
         *
         * @param magCard
         */
        void onMagCard(MagCard magCard);

        /**
         * ICC callback
         */
        void onICC();

        /**
         * CTLS callback
         */
        void onCTLS();

        /**
         * Manual input callback
         *
         * @param manualCard
         */
        void onManual(ManualCard manualCard);

        /**
         * time out callback
         */
        void onTimeOut();

        /**
         * cancel callback
         */
        void onCancel();

        /**
         * error callback
         */
        void onError();

        /**
         * show ReadCard view
         */
        void showReadCard();

        /**
         * show Manual Card view
         */
        void showManualCard();
    }

    interface Presenter {
        /**
         * start read card
         *
         * @param readCardData
         * @return
         */
        boolean startReadCard(ReadCardData readCardData);

        /**
         * stop read card
         */
        void stopReadCard();

        /**
         * cancel read card
         */
        void cancelReadCard();

        /**
         * commit ManualCard result
         */
        void commitManualCardResult(String pan,String expiredDate);
    }
}
