package cn.nexgo.inbas.components.input.readcard;

import android.animation.ValueAnimator;
import android.app.Activity;
import android.os.Bundle;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import butterknife.BindView;
import butterknife.OnClick;
import cn.nexgo.inbas.R;
import cn.nexgo.inbas.common.base.BaseFragment;
import cn.nexgo.inbas.common.utils.TimeCounter;
import cn.nexgo.inbas.common.widget.ToolBar;
import cn.nexgo.inbas.common.widget.creditcarddesign.CreditCardView;
import cn.nexgo.inbas.common.widget.creditcarddesign.pager.CardFragmentAdapter;
import cn.nexgo.inbas.common.widget.creditcarddesign.views.HeightWrappingViewPager;
import cn.nexgo.inbas.common.widget.keyboard.NumKeyBoard;
import cn.nexgo.inbas.components.input.readcard.internal.MagCard;
import cn.nexgo.inbas.components.input.readcard.internal.ManualCard;
import cn.nexgo.inbas.components.input.readcard.internal.ReadCardCallBack;
import cn.nexgo.inbas.components.input.readcard.internal.ReadCardContract;
import cn.nexgo.inbas.components.input.readcard.internal.ReadCardPresenter;
import cn.nexgo.utils.BaseUtils;
import cn.nexgo.utils.StringUtil;
import cn.nexgo.utils.ToastUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : zhouxie
 * Date            : 2017/12/12
 * Modify          : create file
 **************************************************************************************************/

public class ReadCardFragment extends BaseFragment implements ReadCardContract.View {
    private static final String READ_CARD_DATA = "read_card_data";
    @BindView(R.id.tb)
    ToolBar tb;
    @BindView(R.id.iv_ic_card)
    ImageView mIvIcCard;
    @BindView(R.id.iv_pos)
    ImageView mIvPos;
    @BindView(R.id.iv_mag_card)
    ImageView mIvMagCard;
    @BindView(R.id.iv_picc_card)
    ImageView mIvPiccCard;
    @BindView(R.id.iv_keyboard)
    ImageView ivKeyboard;
    @BindView(R.id.rl_manualcard)
    RelativeLayout rlManualcard;
    @BindView(R.id.rl_readcard)
    RelativeLayout rlReadcard;
    @BindView(R.id.credit_card_view)
    CreditCardView creditCardView;
    @BindView(R.id.card_field_container_pager)
    HeightWrappingViewPager cardFieldContainerPager;
    @BindView(R.id.input_creditcard_keyboard)
    NumKeyBoard inputCreditcardKeyboard;

    @BindView(R.id.tv_readcard_prompt)
    TextView mtvReadCardPrompt;// FIXME: 2018/8/6  add readcard prompt

    private ReadCardCallBack readCardCallBack;
    private ReadCardData readCardData;
    private ReadCardPresenter readCardPresenter;
    private TimeCounter timeCounter;
    private CardFragmentAdapter mCardAdapter;
    int mLastPageSelected = 0;

    private String mCardNumber = "";
    private String mExpiry = "";
    private String title;

    @Override
    protected int getLayoutId() {
        return R.layout.input_read_card_fragment;
    }

    @OnClick({R.id.iv_keyboard})
    public void onViewClicked(View view) {
        readCardPresenter.stopReadCard();
        showManualCard();
    }

    @Override
    protected void initData(Bundle savedInstanceState) {
        OnReadCardCallBack onInputAmountCallBack = (OnReadCardCallBack) getActivity();
        readCardCallBack = onInputAmountCallBack.getReadCardCallBack();

        Bundle bundle = getArguments();
        if (bundle != null) {
            readCardData = bundle.getParcelable(READ_CARD_DATA);
            title = bundle.getString("title");
        }

        readCardAnimation();
    }

    private void showReadCardPrompt(){
        String prompt = "";

        if(readCardData.getReadCardPrompt() != null
                && readCardData.getReadCardPrompt().length() > 0){
            mtvReadCardPrompt.setText(readCardData.getReadCardPrompt());
            return ;
        }

        if(readCardData.isSupportManual()
                && readCardData.isSupportMag()
                && readCardData.isSupportICC()
                && readCardData.isSupportCTLS()){
            mtvReadCardPrompt.setText(getString(R.string.input_readcard_manual_swipe_insert_tap));
            return ;
        }

        if(readCardData.isSupportManual()){
            prompt += getString(R.string.input_readcard_manual);
        }
        if(readCardData.isSupportMag()){
            if(prompt.length() > 0){
                prompt += "/";
            }
            prompt += getString(R.string.input_readcard_swipe);
        }
        if(readCardData.isSupportICC()){
            if(prompt.length() > 0){
                prompt += "/";
            }
            prompt += getString(R.string.input_readcard_insert);
        }
        if(readCardData.isSupportCTLS()){
            if(prompt.length() > 0){
                prompt += "/";
            }
            prompt += getString(R.string.input_readcard_tap);
        }

        mtvReadCardPrompt.setText(prompt);
    }

    @Override
    protected void initView(View view) {
        loadPager(getArguments());
        inputCreditcardKeyboard.setCallback(callback);

        ivKeyboard.setVisibility(readCardData.isSupportManual() ? View.VISIBLE : View.GONE);

        showReadCardPrompt();// FIXME: 2018/8/6

        startSearchCard(readCardData);

//        tb.setTitle(getString(R.string.input_fragment_readcard));
        tb.setTitle(title == null ? getString(R.string.input_fragment_readcard) : title);
        tb.setBackOnclickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getActivity().onBackPressed();
            }
        });
    }


    @Override
    public void showReadCard() {
        rlReadcard.setVisibility(View.VISIBLE);
        rlManualcard.setVisibility(View.GONE);
    }

    @Override
    public void showManualCard() {
        rlReadcard.setVisibility(View.GONE);
        rlManualcard.setVisibility(View.VISIBLE);
    }


    private NumKeyBoard.Callback callback = new NumKeyBoard.Callback() {
        @Override
        public void onKey(NumKeyBoard.KEY_TYPE keyType) {
            switch (keyType) {
                case KEY_0:
                case KEY_1:
                case KEY_2:
                case KEY_3:
                case KEY_4:
                case KEY_5:
                case KEY_6:
                case KEY_7:
                case KEY_8:
                case KEY_9:
                case KEY_00:
                    if (cardFieldContainerPager.getCurrentItem() == 0) {
                        mCardNumber += keyType.getKeyValue();
                        mCardAdapter.getItem(cardFieldContainerPager.getCurrentItem()).edit(mCardNumber);
                    } else if (cardFieldContainerPager.getCurrentItem() == 1) {
                        mExpiry += keyType.getKeyValue();
                        mCardAdapter.getItem(cardFieldContainerPager.getCurrentItem()).edit(mExpiry);
                    }
                    break;
                case KEY_CLEAR:
                    if (cardFieldContainerPager.getCurrentItem() == 0) {
                        mCardNumber = "";
                        mCardAdapter.getItem(cardFieldContainerPager.getCurrentItem()).edit(mCardNumber);
                    } else if (cardFieldContainerPager.getCurrentItem() == 1) {
                        mExpiry = "";
                        mCardAdapter.getItem(cardFieldContainerPager.getCurrentItem()).edit(mExpiry);
                    }
                    break;
                case KEY_BACKSPACE:
                    if (cardFieldContainerPager.getCurrentItem() == 0) {
                        mCardNumber = StringUtil.backspace(mCardNumber);
                        mCardAdapter.getItem(cardFieldContainerPager.getCurrentItem()).edit(mCardNumber);
                    } else if (cardFieldContainerPager.getCurrentItem() == 1) {
                        mExpiry = StringUtil.backspace(mExpiry);
                        mCardAdapter.getItem(cardFieldContainerPager.getCurrentItem()).edit(mExpiry);
                    }
                    break;
                case KEY_CANCEL:
                    if (cardFieldContainerPager.getCurrentItem() == 0) {
                        // if first card.
                        getActivity().onBackPressed();
                    } else {
                        showPreOrNext(false);
                    }
                    break;
                case KEY_CONFIRM:
                    int max = cardFieldContainerPager.getAdapter().getCount();

                    if (cardFieldContainerPager.getCurrentItem() == max - 1) {
                        // if last card.
                        readCardPresenter.commitManualCardResult(mCardNumber, mExpiry);
                    } else {
                        showPreOrNext(true);
                    }
                    break;
            }
        }
    };

    /**
     * show Pre or Next
     *
     * @param isNext
     */
    public void showPreOrNext(boolean isNext) {
        CardFragmentAdapter adapter = (CardFragmentAdapter) cardFieldContainerPager.getAdapter();

        int max = adapter.getCount();
        int currentIndex = cardFieldContainerPager.getCurrentItem();

        if (currentIndex == 0 && mCardNumber.length() < 13) {
            ToastUtils.showShort(BaseUtils.getApp().getString(R.string.emv_read_card_length_error));
            return;
        }

        if (isNext) {
            if (currentIndex + 1 < max) {

                cardFieldContainerPager.setCurrentItem(currentIndex + 1);
            } else {
                // completed the card entry.
                readCardPresenter.commitManualCardResult(mCardNumber, mExpiry);
                // FIXME: 2018/12/17 Hassan remark: should return , do not refresh timer again
                return ;
            }
        } else {
            //noinspection StatementWithEmptyBody
            if (currentIndex > 0) {
                cardFieldContainerPager.setCurrentItem(currentIndex - 1);
            } else {

            }
        }
        refreshCountDown();
    }

    private void refreshCountDown() {
        if (timeCounter != null) {
            timeCounter.restart();
        }
    }

    public void loadPager(Bundle bundle) {
        cardFieldContainerPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            @Override
            public void onPageSelected(int position) {

                mCardAdapter.focus(position);

                if ((position == 2)) {
                    creditCardView.showBack();
                } else if ((position == 1) && (mLastPageSelected == 2)) {
                    creditCardView.showFront();
                }

                mLastPageSelected = position;

            }

            @Override
            public void onPageScrollStateChanged(int state) {
            }
        });
        cardFieldContainerPager.setOffscreenPageLimit(4);

        mCardAdapter = new CardFragmentAdapter(getChildFragmentManager(), bundle);
        mCardAdapter.setOnCardEntryCompleteListener(new CardFragmentAdapter.ICardEntryCompleteListener() {
            @Override
            public void onCardEntryComplete(int currentIndex) {
                showPreOrNext(true);
            }

            @Override
            public void onCardEntryEdit(int currentIndex, String entryValue) {
                switch (currentIndex) {
                    case 0:
                        mCardNumber = entryValue.replace(" ", "");
                        creditCardView.setCardNumber(mCardNumber);
                        break;
                    case 1:
                        mExpiry = entryValue;
                        creditCardView.setCardExpiry(entryValue);
                        break;
                }
            }
        });

        cardFieldContainerPager.setAdapter(mCardAdapter);
    }


    /**
     * read card animation
     */
    private void readCardAnimation() {

        if (readCardData.isSupportCTLS()) {
            tapCardAnimation(mIvPiccCard);
        } else {
            mIvPiccCard.setVisibility(View.INVISIBLE);
        }

        if (readCardData.isSupportICC()) {
            insertCardAnimation(mIvIcCard);
        } else {
            mIvIcCard.setVisibility(View.INVISIBLE);
        }

        if (readCardData.isSupportMag()) {

            swipeCardAnimation(mIvMagCard);
        } else {
            mIvMagCard.setVisibility(View.INVISIBLE);
        }



    }

    /**
     * swipe card Animation
     */
    public void swipeCardAnimation(ImageView imageView) {

        AnimationSet animationSet = new AnimationSet(true);
        TranslateAnimation translateAnimation = new TranslateAnimation(
                Animation.RELATIVE_TO_SELF, 0.0f,
                Animation.RELATIVE_TO_SELF, 0.0f,
                Animation.RELATIVE_TO_SELF, 0.0f,
                Animation.RELATIVE_TO_SELF, 1.0f);

        translateAnimation.setDuration(1000);
        translateAnimation.setRepeatCount(ValueAnimator.INFINITE);
        translateAnimation.setRepeatMode(ValueAnimator.INFINITE);
        animationSet.setFillAfter(false);
        animationSet.addAnimation(translateAnimation);
        //start animation
        imageView.startAnimation(animationSet);
    }

    /**
     * insert card Animation
     */
    public void insertCardAnimation(ImageView imageView) {
        AnimationSet animationSet = new AnimationSet(true);

        TranslateAnimation translateAnimation = new TranslateAnimation(

                Animation.RELATIVE_TO_SELF, 0.0f,
                Animation.RELATIVE_TO_SELF, -0.2f,
                Animation.RELATIVE_TO_SELF, 0.0f,
                Animation.RELATIVE_TO_SELF, 0.0f
        );
        translateAnimation.setDuration(1000);
        translateAnimation.setRepeatCount(ValueAnimator.INFINITE);
        translateAnimation.setRepeatMode(ValueAnimator.INFINITE);
        animationSet.setFillAfter(true);
        animationSet.addAnimation(translateAnimation);
        //start animation
        imageView.startAnimation(animationSet);

    }

    /**
     * tap card Animation
     */
    public void tapCardAnimation(ImageView imageView) {
        AnimationSet animationSet = new AnimationSet(true);

        TranslateAnimation translateAnimation = new TranslateAnimation(

                Animation.RELATIVE_TO_SELF, 0.0f,
                Animation.RELATIVE_TO_SELF, 0.2f,
                Animation.RELATIVE_TO_SELF, 0.0f,
                Animation.RELATIVE_TO_SELF, 0.2f);

        translateAnimation.setDuration(1000);
        translateAnimation.setRepeatCount(ValueAnimator.INFINITE);
        translateAnimation.setRepeatMode(ValueAnimator.INFINITE);
        animationSet.setFillAfter(true);
        animationSet.addAnimation(translateAnimation);
        //start animation
        imageView.startAnimation(animationSet);

    }

    @Override
    protected void initPresenter() {
        readCardPresenter = new ReadCardPresenter(this);
    }

    public static <T extends Activity & OnReadCardCallBack> ReadCardFragment newInstance(String title,ReadCardData readCardData, T callback) {
        ReadCardFragment readCardFragment = new ReadCardFragment();
        Bundle b = new Bundle();
        b.putParcelable(READ_CARD_DATA, readCardData);
        b.putString("title", title);
        readCardFragment.setArguments(b);
        return readCardFragment;
    }

    @Override
    public void onMagCard(MagCard magCard) {
        timeCounter.cancel();
        readCardCallBack.onMagCard(magCard);
    }

    @Override
    public void onICC() {
        timeCounter.cancel();
        readCardCallBack.onICC();
    }

    @Override
    public void onCTLS() {
        timeCounter.cancel();
        readCardCallBack.onCTLS();
    }

    @Override
    public void onManual(ManualCard manualCard) {
        timeCounter.cancel();
        readCardCallBack.onManual(manualCard);
    }

    @Override
    public void onTimeOut() {
        timeCounter.cancel();
        readCardCallBack.onTimeOut();
    }

    @Override
    public void onCancel() {
        timeCounter.cancel();
        readCardCallBack.onCancel();
    }

    @Override
    public void onError() {
        ToastUtils.showShort(BaseUtils.getApp().getString(R.string.emv_read_card_error));
        startSearchCard(readCardData);
    }

    public interface OnReadCardCallBack {
        ReadCardCallBack getReadCardCallBack();
    }

    /**
     * Start Search Card
     *
     * @param readCardData
     */
    public boolean startSearchCard(ReadCardData readCardData) {
        if (timeCounter != null) {
            timeCounter.cancel();
        }
        timeCounter = new TimeCounter();
        timeCounter.startTimer(readCardData.getTimeout(), timerListener);
        return readCardPresenter.startReadCard(readCardData);
    }

    /**
     * Stop Search Card
     */
    public void cancelSearchCard() {
        readCardPresenter.cancelReadCard();
    }

    private TimeCounter.Listener timerListener = new TimeCounter.Listener() {
        @Override
        public void onTimerProcess(long time) {
            tb.setRightlab(String.valueOf(time));
        }

        @Override
        public void onFinish() {
            cancelSearchCard();
            readCardCallBack.onTimeOut();
        }
    };

    @Override
    public void onDestroyView() {
        timeCounter.cancel();
        cancelSearchCard();
        super.onDestroyView();
    }
}

