package cn.nexgo.inbas.components.input.pin.internal;


import com.nexgo.oaf.apiv3.device.pinpad.PinpadLayoutEntity;

import cn.nexgo.inbas.components.input.pin.InputPinData;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           :
 * Version         : 1
 * Author          : zhouxie
 * Date            : 2017/12/11
 * Modify          : create file
 **************************************************************************************************/

public interface InputPinContract {
    interface View {
        /**
         * start a time out countdown(second)
         *
         * @param timeOut
         */
        void startTimeOutCountDown(int timeOut);

        /**
         * showPinError callback
         */
        void showPinError();

        /**
         * showPinTimeOut callback
         */
        void showPinTimeOut();

        /**
         * showPinConfirm,return pinblock
         *
         * @param pin
         */
        void showPinConfirm(byte[] pin);

        /**
         * without pin
         */
        void pinPass();

        /**
         * showPinClear callback
         */
        void showPinClear();

        /**
         * showPinCancel callback
         */
        void showPinCancel();

        /**
         * showPinMask callback
         */
        void showPinMask();

        /**
         * return whether the inputPinFragment is active
         *
         * @return
         */
        boolean isActive();

        /**
         * set Pinpad layout
         * @return
         */
        PinpadLayoutEntity getPinPadLayoutEntity();

        /**
         * set pin pad num
         * @param bytes
         */
        void setPinNum(byte[] bytes);

        /**
         * set pin length
         * @param pinLen
         */
        void setPinLen(int[] pinLen);
    }

    interface Presenter {
        /**
         *  start a pinpad
         */
        void startInputPin(InputPinData inputPinData);

        /**
         * cancelInputPin callback
         */
        void cancelInputPin();

        /**
         * cancel input pin
         */
        void onInputPinTimeOut();

    }
}
