package cn.nexgo.inbas.components.input.pin;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.Arrays;

import cn.nexgo.inbas.common.bean.AmountBean;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : zhouxie
 * Date            : 2017/12/12
 * Modify          : create file
 **************************************************************************************************/

public class InputPinData implements Parcelable {
    private int[] pinlen = new int[]{0, 4, 6};
    private int remainTimes;
    private boolean offlinePin = false;
    private int keyIndex;
    private PINFormat pinFormat = PINFormat.FORMAT1;
    private PEDType pedType = PEDType.INTERNAL;
    private String pan;
    private int timeout = 60;
    private AmountBean amountBean;

    protected InputPinData(Parcel in) {
        pinlen = in.createIntArray();
        remainTimes = in.readInt();
        offlinePin = in.readByte() != 0;
        keyIndex = in.readInt();
        pan = in.readString();
        timeout = in.readInt();
        amountBean = in.readParcelable(AmountBean.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeIntArray(pinlen);
        dest.writeInt(remainTimes);
        dest.writeByte((byte) (offlinePin ? 1 : 0));
        dest.writeInt(keyIndex);
        dest.writeString(pan);
        dest.writeInt(timeout);
        dest.writeParcelable(amountBean, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<InputPinData> CREATOR = new Creator<InputPinData>() {
        @Override
        public InputPinData createFromParcel(Parcel in) {
            return new InputPinData(in);
        }

        @Override
        public InputPinData[] newArray(int size) {
            return new InputPinData[size];
        }
    };

    public int[] getPinlen() {
        return pinlen;
    }

    public void setPinlen(int[] pinlen) {
        this.pinlen = pinlen;
    }

    public int getRemainTimes() {
        return remainTimes;
    }

    public void setRemainTimes(int remainTimes) {
        this.remainTimes = remainTimes;
    }

    public boolean isOfflinePin() {
        return offlinePin;
    }

    public void setOfflinePin(boolean offlinePin) {
        this.offlinePin = offlinePin;
    }

    public int getKeyIndex() {
        return keyIndex;
    }

    public void setKeyIndex(int keyIndex) {
        this.keyIndex = keyIndex;
    }

    public PINFormat getPinFormat() {
        return pinFormat;
    }

    public void setPinFormat(PINFormat pinFormat) {
        this.pinFormat = pinFormat;
    }

    public PEDType getPedType() {
        return pedType;
    }

    public void setPedType(PEDType pedType) {
        this.pedType = pedType;
    }

    public String getPan() {
        return pan;
    }

    public void setPan(String pan) {
        this.pan = pan;
    }

    public int getTimeout() {
        return timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public enum PINFormat {
        FORMAT1,
//        FORMAT0,FORMAT2,FORMAT3
    }

    public enum PEDType {
        INTERNAL, EXTERNAL
    }

    public InputPinData() {
    }

    public AmountBean getAmountBean() {
        return amountBean;
    }

    public void setAmountBean(AmountBean amountBean) {
        this.amountBean = amountBean;
    }

    @Override
    public String toString() {
        return "InputPinData{" +
                "pinlen=" + Arrays.toString(pinlen) +
                ", remainTimes=" + remainTimes +
                ", offlinePin=" + offlinePin +
                ", keyIndex=" + keyIndex +
                ", pinFormat=" + pinFormat +
                ", pedType=" + pedType +
                ", pan='" + pan + '\'' +
                ", timeout=" + timeout +
                '}';
    }
}
