package cn.nexgo.inbas.components.input.numstr.internal;

import android.os.Parcel;
import android.os.Parcelable;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : zhouxie
 * Date            : 2017/12/13
 * Modify          : create file
 **************************************************************************************************/
public class InputNumStrData implements Parcelable {
    public boolean isPwd = false;
    public int maxLen = Integer.MAX_VALUE;
    public int minLen = 1;
    public String defaultValue;
    public String title = "";
    public String msg = "";
    public int timeout = 60;

    public InputNumStrData() {
    }

    public InputNumStrData(String title, String msg, boolean isPwd, int maxLen, int minLen, String defaultValue, int timeout) {
        this.title = title;
        this.msg = msg;
        this.isPwd = isPwd;
        this.maxLen = maxLen;
        this.minLen = minLen;
        this.defaultValue = defaultValue;
        this.timeout = timeout;
    }


    protected InputNumStrData(Parcel in) {
        isPwd = in.readByte() != 0;
        maxLen = in.readInt();
        minLen = in.readInt();
        defaultValue = in.readString();
        title = in.readString();
        msg = in.readString();
        timeout = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte) (isPwd ? 1 : 0));
        dest.writeInt(maxLen);
        dest.writeInt(minLen);
        dest.writeString(defaultValue);
        dest.writeString(title);
        dest.writeString(msg);
        dest.writeInt(timeout);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<InputNumStrData> CREATOR = new Creator<InputNumStrData>() {
        @Override
        public InputNumStrData createFromParcel(Parcel in) {
            return new InputNumStrData(in);
        }

        @Override
        public InputNumStrData[] newArray(int size) {
            return new InputNumStrData[size];
        }
    };
}
