package cn.nexgo.inbas.components.input.numstr;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import java.util.Arrays;

import butterknife.BindView;
import cn.nexgo.hwdriver.AppBeeper;
import cn.nexgo.inbas.R;
import cn.nexgo.inbas.common.base.BaseFragment;
import cn.nexgo.inbas.common.utils.TimeCounter;
import cn.nexgo.inbas.common.widget.ToolBar;
import cn.nexgo.inbas.common.widget.autofittext.AutoFitTextView;
import cn.nexgo.inbas.common.widget.keyboard.NumKeyBoard;
import cn.nexgo.inbas.common.widget.keyboard.NumStrKeyBoard;
import cn.nexgo.inbas.components.input.amount.internal.InputAmountContract;
import cn.nexgo.inbas.components.input.numstr.internal.InputNumStrCallBack;
import cn.nexgo.inbas.components.input.numstr.internal.InputNumStrData;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : zhouxie
 * Date            : 2017/12/12
 * Modify          : create file
 **************************************************************************************************/

public class InputNumStrFragment extends BaseFragment implements InputAmountContract.View {

    private static final String INPUT_NUMSTR_DATA = "input_numstr_data";
    @BindView(R.id.tb)
    ToolBar tb;
    @BindView(R.id.tv_input)
    AutoFitTextView tvInput;
    @BindView(R.id.kb)
    NumStrKeyBoard kb;
    @BindView(R.id.tv_msg)
    TextView tvMsg;
    @BindView(R.id.tv_errormsg)
    TextView tvErrorMsg;

    private InputNumStrCallBack inputNumStrCallBack;
    private InputNumStrData inputNumStrData;

    private AppBeeper beeperManager;
    private TimeCounter timeCounter;
    private String title;

    @Override
    protected int getLayoutId() {
        return R.layout.input_numstr_fragment;
    }

    @Override
    protected void initData(Bundle savedInstanceState) {
        OnInputNumStrCallBack onInputAmountCallBack = (OnInputNumStrCallBack) getActivity();
        inputNumStrCallBack = onInputAmountCallBack.getInputNumStrCallBack();
        Bundle bundle = getArguments();
        if (bundle != null) {
            inputNumStrData = bundle.getParcelable(INPUT_NUMSTR_DATA);
            title = bundle.getString("title");
        } else {
            inputNumStrData = savedInstanceState.getParcelable(INPUT_NUMSTR_DATA);
        }
        kb.setCallback(callback);

        if (timeCounter != null) {
            timeCounter.cancel();
        }
        timeCounter = new TimeCounter();
        timeCounter.startTimer(inputNumStrData.timeout, timerListener);

        beeperManager = new AppBeeper();
    }

    @Override
    protected void initPresenter() {
    }

    @Override
    protected void initView(View view) {
        kb.setMaxLen(inputNumStrData.maxLen);
        kb.setMinLen(inputNumStrData.minLen);
//        tb.setTitle(inputNumStrData.title);
        tb.setTitle(title == null ? inputNumStrData.title : title);
        tvMsg.setText(inputNumStrData.msg);
        refreshUI();

        tb.setBackOnclickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getActivity().onBackPressed();
            }
        });
    }

    private NumKeyBoard.Callback callback = new NumKeyBoard.Callback() {
        @Override
        public void onKey(NumKeyBoard.KEY_TYPE keyType) {
            beeperManager.startBeeper(100);
            switch (keyType) {
                case KEY_0:
                case KEY_1:
                case KEY_2:
                case KEY_3:
                case KEY_4:
                case KEY_5:
                case KEY_6:
                case KEY_7:
                case KEY_8:
                case KEY_9:
                case KEY_00:
                case KEY_CLEAR:
                case KEY_BACKSPACE:
                    refreshUI();
                    break;
                case KEY_CANCEL:
                    if (inputNumStrCallBack != null)
                        inputNumStrCallBack.onCancel();
                    break;
                case KEY_CONFIRM:
                    if (inputNumStrCallBack != null) {
                        inputNumStrCallBack.onNumStr(kb.getRet());
                    }
                    break;
            }
        }
    };


    private void refreshUI() {
        if (inputNumStrData.isPwd) {
            tvInput.setText(plain2Pwd(kb.getRet()));
            return;
        }
        tvInput.setText(kb.getRet());
    }

    private TimeCounter.Listener timerListener = new TimeCounter.Listener() {
        @Override
        public void onTimerProcess(long time) {
            tb.setRightlab(String.valueOf(time));
        }

        @Override
        public void onFinish() {
            if (inputNumStrCallBack != null) {
                inputNumStrCallBack.onTimeOut();
            }
        }
    };

    public static <T extends Activity & OnInputNumStrCallBack> InputNumStrFragment newInstance(String title, InputNumStrData inputNumStrData, T callback) {
        InputNumStrFragment inputAmountFragment = new InputNumStrFragment();
        Bundle b = new Bundle();
        b.putParcelable(INPUT_NUMSTR_DATA, inputNumStrData);
        b.putString("title", title);
        inputAmountFragment.setArguments(b);
        return inputAmountFragment;
    }

    public interface OnInputNumStrCallBack {
        InputNumStrCallBack getInputNumStrCallBack();
    }

    @Override
    public void onDestroyView() {
        timeCounter.cancel();
        super.onDestroyView();
    }

    private String plain2Pwd(String plain) {
        if ((plain == null) || (plain.length() == 0)) {
            return "";
        }
        char[] ret = new char[plain.length()];
        Arrays.fill(ret, '*');
        return new String(ret);
    }


    public void clearInput() {
        kb.setDefaultValue("");
        tvInput.setText("");
    }

    public void showErrorMsg(boolean enable, String msg) {
        if (!enable) {
            tvErrorMsg.setVisibility(View.GONE);
            return;
        }
        tvErrorMsg.setVisibility(View.VISIBLE);
        tvErrorMsg.setText(msg);
    }
}
