package cn.nexgo.inbas.components.input.amount;

import android.app.Activity;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import butterknife.BindView;
import butterknife.OnClick;
import cn.nexgo.hwdriver.AppBeeper;
import cn.nexgo.inbas.R;
import cn.nexgo.inbas.common.base.BaseFragment;
import cn.nexgo.inbas.common.bean.AmountBean;
import cn.nexgo.inbas.common.widget.autofittext.AutoFitTextView;
import cn.nexgo.inbas.common.widget.keyboard.AmountNumKeyBoard;
import cn.nexgo.inbas.common.widget.keyboard.NumKeyBoard;
import cn.nexgo.inbas.components.input.amount.internal.InputAmountCallBack;
import cn.nexgo.inbas.components.input.amount.internal.InputAmountContract;
import cn.nexgo.inbas.controller.mechantcenter.syssetting.SysSettingActivity;
import cn.nexgo.utils.FormatUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : zhouxie
 * Date            : 2017/12/12
 * Modify          : create file
 **************************************************************************************************/

public class InputAmountFragment extends BaseFragment implements InputAmountContract.View {
    private Logger log = LoggerFactory.getLogger(InputAmountFragment.class.getSimpleName());

    private static final String INPUT_AMOUNT_DATA = "input_amount_data";
    private static final String INPUT_AMOUNT_TITLE_KEY = "INPUT_AMOUNT_TITLE_KEY";

    @BindView(R.id.tv_title)
    TextView tvTitle;
    @BindView(R.id.tv_amount)
    AutoFitTextView tvAmount;
    @BindView(R.id.kb_input_amount)
    AmountNumKeyBoard kbInputAmount;
    @BindView(R.id.tv_amount_mark)
    TextView tvAmountMark;

    private InputAmountCallBack inputAmountCallBack;
    private InputAmountData inputAmountData;

    private AppBeeper beeperManager;
    private String title;

    @Override
    protected int getLayoutId() {
        return R.layout.input_amount_fragment;
    }

    @Override
    protected void initData(Bundle savedInstanceState) {
        OnInputAmountCallBack onInputAmountCallBack = (OnInputAmountCallBack) getActivity();
        inputAmountCallBack = onInputAmountCallBack.getInputAmountCallBack();

        Bundle bundle = getArguments();
        if (bundle != null) {
            inputAmountData = bundle.getParcelable(INPUT_AMOUNT_DATA);
            title = bundle.getString(INPUT_AMOUNT_TITLE_KEY);
        }
        kbInputAmount.setCallback(callback);
        kbInputAmount.setMaxValue(inputAmountData.getMaxAmount());
        kbInputAmount.setMinValue(inputAmountData.getMinAmount());
        kbInputAmount.setValue(inputAmountData.getDefaulAmount());

        currentAmount = inputAmountData.getDefaulAmount();
        currentDecimal = inputAmountData.getDecimals();
        currencySymbol = inputAmountData.getCurrencySymbol();

        beeperManager = new AppBeeper();

        log.debug("inputAmountData = " + inputAmountData.toString());
    }

    @Override
    protected void initPresenter() {
    }

    @OnClick(R.id.iv_merchant_center)
    public void onViewClicked(View v) {
        super.intent2Activity(SysSettingActivity.class);
    }

    @Override
    protected void initView(View view) {
        //keep screen on
        Window win = getActivity().getWindow();
        win.setFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON, WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
//        //close menu
        win.addFlags(5);
//        //close home
        win.addFlags(3);
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {//当系统版本是5.1.1时，可以使用Settings
            //close pull down window
            Settings.System.putInt(getContext().getContentResolver(), "status_bar_disabled", 1);
        }

        tvTitle.setText(title == null ? getString(R.string.amount) : title);

        refreshUI();
    }

    private long currentAmount;
    private int currentDecimal;
    private String currencySymbol;

    private AmountNumKeyBoard.AmountKeyBoardCallback callback = new AmountNumKeyBoard.AmountKeyBoardCallback() {
        @Override
        public void onKey(NumKeyBoard.KEY_TYPE keyType) {
            beeperManager.startBeeper(100);
            switch (keyType) {
                case KEY_0:
                case KEY_1:
                case KEY_2:
                case KEY_3:
                case KEY_4:
                case KEY_5:
                case KEY_6:
                case KEY_7:
                case KEY_8:
                case KEY_9:
                case KEY_00:
                case KEY_CLEAR:
                case KEY_BACKSPACE:
                    refreshUI();
                    break;
                case KEY_CANCEL:
                    if (inputAmountCallBack != null)
                        inputAmountCallBack.onCancel();
                    break;
                case KEY_CONFIRM:
                    if (inputAmountCallBack != null) {
                        inputAmountCallBack.onAmount(new AmountBean(currentAmount, currentDecimal, 3, currencySymbol));
                    }
                    break;
            }
        }

        @Override
        public void onEnable(boolean enable) {
            tvAmount.setAlpha(enable ? 1 : 0.5f);
        }
    };

    private void refreshUI() {
        currentAmount = kbInputAmount.getRet();
        String amountString = "" + currentAmount;
        String formatAmount = FormatUtils.formatAmount(amountString, 3, ",", currentDecimal);

        String amount_string = String.format(getResources().getString(R.string.amount_string), currencySymbol, formatAmount);
//        tvAmount.getPaint().setFlags(Paint.UNDERLINE_TEXT_FLAG);
        tvAmount.setText(amount_string);

        String enter_amount = String.format(getResources().getString(R.string.input_enter_amount_num),
                FormatUtils.formatAmount(String.valueOf(inputAmountData.getMinAmount()), 3, ",", currentDecimal),
                FormatUtils.formatAmount(String.valueOf(inputAmountData.getMaxAmount()), 3, ",", currentDecimal));
        tvAmountMark.setText(enter_amount);
    }

    public static <T extends Activity & OnInputAmountCallBack> InputAmountFragment newInstance(String title, InputAmountData inputAmountData, T callback) {
        InputAmountFragment inputAmountFragment = new InputAmountFragment();
        Bundle b = new Bundle();
        b.putParcelable(INPUT_AMOUNT_DATA, inputAmountData);
        b.putString(INPUT_AMOUNT_TITLE_KEY, title);
        inputAmountFragment.setArguments(b);
        return inputAmountFragment;
    }

    public interface OnInputAmountCallBack {
        InputAmountCallBack getInputAmountCallBack();
    }

    @Override
    public void onDestroyView() {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {//当系统版本是5.1.1时，可以使用Settings
            //close pull down window
            Settings.System.putInt(getContext().getContentResolver(), "status_bar_disabled", 0);
        }
        getActivity().getWindow().clearFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        super.onDestroyView();
    }

}
