package cn.nexgo.inbas.components.emv.presenter;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;

import com.nexgo.common.ByteUtils;
import com.nexgo.oaf.apiv3.APIProxy;
import com.nexgo.oaf.apiv3.SdkResult;
import com.nexgo.oaf.apiv3.card.cpu.CPUCardHandler;
import com.nexgo.oaf.apiv3.device.reader.CardInfoEntity;
import com.nexgo.oaf.apiv3.device.reader.CardSlotTypeEnum;
import com.nexgo.oaf.apiv3.emv.AmexTransDataEntity;
import com.nexgo.oaf.apiv3.emv.CandidateAppInfoEntity;
import com.nexgo.oaf.apiv3.emv.DPASTransDataEntity;
import com.nexgo.oaf.apiv3.emv.DPASVersionEnum;
import com.nexgo.oaf.apiv3.emv.EmvChannelTypeEnum;
import com.nexgo.oaf.apiv3.emv.EmvDataSourceEnum;
import com.nexgo.oaf.apiv3.emv.EmvEntryModeEnum;
import com.nexgo.oaf.apiv3.emv.EmvHandler;
import com.nexgo.oaf.apiv3.emv.EmvHandler2;
import com.nexgo.oaf.apiv3.emv.EmvModeEnum;
import com.nexgo.oaf.apiv3.emv.EmvOnlineResultEntity;
import com.nexgo.oaf.apiv3.emv.EmvProcessFlowEnum;
import com.nexgo.oaf.apiv3.emv.EmvProcessResultEntity;
import com.nexgo.oaf.apiv3.emv.EmvTransConfigurationEntity;
import com.nexgo.oaf.apiv3.emv.EmvTransDataEntity;
import com.nexgo.oaf.apiv3.emv.EmvTransFlowEnum;
import com.nexgo.oaf.apiv3.emv.OnEmvProcessListener;
import com.nexgo.oaf.apiv3.emv.OnEmvProcessListener2;
import com.nexgo.oaf.apiv3.emv.PromptEnum;
import com.nexgo.oaf.apiv3.emv.UnionPayTransDataEntity;
import com.xinguodu.ddiinterface.GeneralDdi;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

import cn.nexgo.hwdriver.AppBeeper;
import cn.nexgo.inbas.R;
import cn.nexgo.inbas.common.Constans.CardType;
import cn.nexgo.inbas.common.GData;
import cn.nexgo.inbas.common.bean.AmountBean;
import cn.nexgo.inbas.common.widget.CardNoConfirmDialog;
import cn.nexgo.inbas.common.widget.SeePhoneDialog;
import cn.nexgo.inbas.components.data.helper.LedDriverHelper;
import cn.nexgo.inbas.components.emv.EmvBaseActivity;
import cn.nexgo.inbas.components.emv.EmvUtils;
import cn.nexgo.inbas.components.emv.IEmvCore;
import cn.nexgo.inbas.components.emv.bean.AppEmvOnlineResultEntity;
import cn.nexgo.inbas.components.emv.bean.CardInfo;
import cn.nexgo.inbas.components.emv.bean.EmvCardControlEntity;
import cn.nexgo.inbas.components.emv.bean.EmvContactlessType;
import cn.nexgo.inbas.components.emv.bean.EmvOnlineResultState;
import cn.nexgo.inbas.components.emv.bean.EmvTransData;
import cn.nexgo.inbas.components.emv.bean.EmvTransState;
import cn.nexgo.inbas.components.emv.bean.OfflineState;
import cn.nexgo.inbas.components.emv.contract.EmvBaseContract;
import cn.nexgo.inbas.components.emv.fragment.selectapp.SelectAppCallBack;
import cn.nexgo.inbas.components.input.pin.InputPinData;
import cn.nexgo.inbas.components.input.pin.internal.InputPinCallBack;
import cn.nexgo.inbas.components.input.readcard.ReadCardData;
import cn.nexgo.inbas.components.input.readcard.internal.MagCard;
import cn.nexgo.inbas.components.input.readcard.internal.ManualCard;
import cn.nexgo.inbas.components.input.readcard.internal.ReadCardCallBack;
import cn.nexgo.inbas.transactions.common.protocol.bean.Emv55FieldDOLType;
import cn.nexgo.utils.BaseUtils;
import cn.nexgo.utils.ConvertUtils;
import cn.nexgo.utils.FormatUtils;
import cn.nexgo.utils.ToastUtils;

import static cn.nexgo.inbas.components.data.helper.LedDriverHelper.LED_CLOSE;
import static cn.nexgo.inbas.components.data.helper.LedDriverHelper.LED_HIDE;
import static cn.nexgo.inbas.components.data.helper.LedDriverHelper.LED_INIT;
import static cn.nexgo.inbas.components.data.helper.LedDriverHelper.LED_READCARD;
import static cn.nexgo.inbas.components.data.helper.LedDriverHelper.LED_READCARD_FAILED;
import static cn.nexgo.inbas.components.data.helper.LedDriverHelper.LED_READCARD_SUCCESS;
import static cn.nexgo.inbas.components.data.helper.LedDriverHelper.LED_WAITING_CARD;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Hassan(huacong@nexgo.cn)
 * Date            : 2017/12/27
 * Modify          : create file
 **************************************************************************************************/
public class EmvBasePresenter<T extends EmvBaseContract.View> implements EmvBaseContract.Presenter {
    private Logger log = LoggerFactory.getLogger(EmvBasePresenter.class.getSimpleName());

    protected EmvHandler2 emvHandler;
    protected T view;
    private final Handler handler;
    private EmvCardControlEntity emvCardControlEntity;
//    private EmvTransDataEntity emvTransDataEntity;
// FIXME: 2020/5/11 change to new API
private EmvTransConfigurationEntity emvTransDataEntity;

    private EmvTransData emvTransData;
    private AppEmvOnlineResultEntity emvOnlineResultEntity = null;
//    private EmvOnlineResultEntity emvOnlineResultEntity;
    private CardInfo cardInfo;
    private EmvBaseActivity.EmvBaseCallback emvBaseCallback;
    private GData gData = GData.getInstance();
    private LedDriverHelper ledDriverHelper;
    private AppBeeper appBeeper;

    public EmvBasePresenter(final T view) {
        this.view = view;
        handler = new Handler(Looper.getMainLooper());
        emvHandler = APIProxy.getDeviceEngine(BaseUtils.getApp().getApplicationContext()).getEmvHandler2(gData.getMixData().getPackageName());
        emvTransData = new EmvTransData();
//        ctlsCfg = EmvUtils.getCtlsCfg();
        cardInfo = new CardInfo();
        emvHandler.emvProcessCancel();

        ledDriverHelper = LedDriverHelper.getInstance(BaseUtils.getApp());
        appBeeper = new AppBeeper();
    }


    @Override
    public void startCardProcess(EmvCardControlEntity emvCardControlEntity, EmvBaseActivity.EmvBaseCallback callback) {
        log.debug("startCardProcess");
        //init
        this.emvCardControlEntity = emvCardControlEntity;
        this.emvBaseCallback = callback;

        emvTransData.setReadClsAgain(false);

        if(this.emvCardControlEntity.isSupportCTLS()){
            ledDriverHelper.controlContactlessLed(LED_INIT);
            ledDriverHelper.controlContactlessLed(LED_WAITING_CARD);
        }

        showReadCard();
    }

    /**
     * step 1 :read card
     */
    private void showReadCard() {
        log.debug("startCardProcess showReadCard");
        view.showDialog(false, null, null);
        log.debug("getTransName " + BaseUtils.getApp().getString(emvCardControlEntity.getTransType().getName()));
        this.view.onReadCard(BaseUtils.getApp().getString(emvCardControlEntity.getTransType().getName()), getReadCardData(emvCardControlEntity, emvTransData), readCardCallBack);

    }

    private ReadCardCallBack readCardCallBack = new ReadCardCallBack() {
        @Override
        public void onMagCard(MagCard magCard) {
            log.debug("ReadCardCallBack onMagCard");
            emvTransData.setCardType(CardType.MAG);

            processMagCard(magCard);
        }

        @Override
        public void onICC() {
            log.debug("ReadCardCallBack onICC");
            emvTransData.setCardType(CardType.ICC);

            processEmvFlow(CardType.ICC);
        }

        @Override
        public void onCTLS() {
            log.debug("ReadCardCallBack onCTLS");
            emvTransData.setCardType(CardType.CTLS);
            processEmvFlow(CardType.CTLS);
        }

        @Override
        public void onManual(ManualCard manualCard) {
            log.debug("ReadCardCallBack onManual");
            emvTransData.setCardType(CardType.MANUAL);
            cardInfo.setCardType(CardType.MANUAL);
            processManualCard(manualCard);
        }

        @Override
        public void onCancel() {
            log.debug("ReadCardCallBack onCancel");

            view.finishActivity(BaseUtils.getApp().getString(R.string.emv_trans_cancel));// FIXME: 2018/8/3 add disp trans cancelled
        }

        @Override
        public void onTimeOut() {
            log.debug("ReadCardCallBack onTimeOut");

            view.finishActivity(null);
        }
    };


    private ReadCardData getReadCardData(EmvCardControlEntity emvCardControlEntity, EmvTransData emvTransData) {
        Long transAmount = Long.parseLong(emvCardControlEntity.getTransAmount());

        log.debug("transAmount total" + transAmount);

        ReadCardData readCardData = new ReadCardData();
        readCardData.setAmount(transAmount);
        readCardData.setCurrencySymbol(gData.getSetupEntity().getTermCurrencyName());
        readCardData.setDecimal(gData.getSetupEntity().getTermAmountDecimalLen());//mike_zj
        readCardData.setSupportMag(emvCardControlEntity.isSupportMag());
        readCardData.setSupportICC(emvCardControlEntity.isSupportICC());
        readCardData.setSupportCTLS(emvCardControlEntity.isSupportCTLS());
        readCardData.setSupportManual(emvCardControlEntity.isSupportManual());

        // FIXME: 2018/8/6 add prompt for readcard
        if (emvTransData.isFallback()) {
            readCardData.setReadCardPrompt(BaseUtils.getApp().getString(R.string.emv_read_card_swipe));
        } else if (emvTransData.isReadClsAgain()) {
            readCardData.setReadCardPrompt(BaseUtils.getApp().getString(R.string.emv_read_card_contactless_again));
        } else if (emvTransData.isClsSeePhone()) {
            readCardData.setReadCardPrompt(BaseUtils.getApp().getString(R.string.emv_read_card_phone_again));
        }

        return readCardData;
    }

    public void processMagCard(MagCard magCard) {
        boolean isUseIccCard = false;

        //if support ICC & CTLS, and Mag card has ICC,and is not Fallback
        // then need re-search card icc and rf
        if (magCard.isICC()
                && (emvCardControlEntity.isSupportICC()
                || emvCardControlEntity.isSupportCTLS())
                && !emvTransData.isFallback()) {
            isUseIccCard = true;
        }
        if (isUseIccCard) {
            emvCardControlEntity.setSupportMag(false);
            emvCardControlEntity.setSupportManual(false);
            log.debug("ReadCardCallBack ICC ,need use icc");
            ToastUtils.showLong(BaseUtils.getApp().getString(R.string.emv_read_card_insert_rf));
            showReadCard();
        } else {
            emvTransData.setTransAmount(emvCardControlEntity.getTransAmount());
            emvTransData.setCashbackAmount(emvCardControlEntity.getCashbackAmount());
            emvTransData.setCardType(CardType.MAG);
            emvTransData.setPan(magCard.getCardNo());
            emvTransData.setTk1(magCard.getTk1());
            emvTransData.setTk2(magCard.getTk2());
            emvTransData.setTk3(magCard.getTk3());
            emvTransData.setExpDate(magCard.getExpiredDate());
            emvTransData.setServiceCode(magCard.getServiceCode());

            cardInfo.setCardType(CardType.MAG);
            cardInfo.setPan(magCard.getCardNo());
            cardInfo.setTk1(magCard.getTk1());
            cardInfo.setTk2(magCard.getTk2());
            cardInfo.setTk3(magCard.getTk3());
            cardInfo.setExpiredDate(magCard.getExpiredDate());
            cardInfo.setServiceCode(magCard.getServiceCode());

            ledDriverHelper.controlContactlessLed(LED_HIDE);

            if (emvCardControlEntity.isConfirmPan()) {
                this.view.onEmvRequestConfirmCardNumber(emvTransData.getPan(), emvTransData.getTransAmount(), mconfirmPanCallBack);
            } else {
                if (isTransNeedPin()) {
                    showInputPin(emvCardControlEntity.getPinKeyIndex(), true, 0, emvTransData.getPan(), mInputPinCallBack);
                } else {
                    emvBaseCallback.onProcessMagCard(cardInfo);
                }
            }
        }
    }


    public void processManualCard(ManualCard manualCard) {
        log.debug("processManualCard");
        emvTransData.setCardType(CardType.MANUAL);
        emvTransData.setPan(manualCard.getPan());
        emvTransData.setExpDate(manualCard.getExpiredDate());
        emvTransData.setTransAmount(emvCardControlEntity.getTransAmount());
        emvTransData.setCashbackAmount(emvCardControlEntity.getCashbackAmount());

        cardInfo.setCardType(CardType.MANUAL);
        cardInfo.setPan(manualCard.getPan());
        cardInfo.setExpiredDate(manualCard.getExpiredDate());

        ledDriverHelper.controlContactlessLed(LED_HIDE);

        if (isTransNeedPin()) {
            showInputPin(emvCardControlEntity.getPinKeyIndex(), true, 0, emvTransData.getPan(), mInputPinCallBack);

        } else {
            emvBaseCallback.onProcessManualCard(cardInfo);// FIXME: 2018/1/26 UI还没有做好，计划下一版本处理
        }
    }

    private CardNoConfirmDialog.OnClickListener mconfirmPanCallBack = new CardNoConfirmDialog.OnClickListener() {
        @Override
        public void onConfirm() {
            log.debug("ConfirmPanCallBack confirm");
            processConfirmCardNumber();
        }

        @Override
        public void onCancel() {
            log.debug("ConfirmPanCallBack cancel");
            if (isEmvFullFlow() || isEmvQpassFlow()) {
                emvHandler.onSetConfirmCardNoResponse(false);
                return ;
            }
            view.finishActivity(null);
        }
    };

    /**
     * processEmvFlow
     *
     * @param cardType
     */
    public void processEmvFlow(CardType cardType) {
        log.debug("processEmvFlow: misReadContactlessAgain " + emvTransData.isReadClsAgain());

        if(cardType == CardType.CTLS){
            ledDriverHelper.controlContactlessLed(LED_READCARD);
        }else{
            ledDriverHelper.controlContactlessLed(LED_HIDE);
        }

        if (emvTransData.isReadClsAgain()) {
            emvHandler.onSetContactlessTapCardResponse(true);
        } else {
            view.showDialog(true, BaseUtils.getApp().getString(R.string.wait), BaseUtils.getApp().getString(R.string.emv_read_hold_card));
            emvTransData.setCardType(cardType);
            emvTransData.setTransAmount(emvCardControlEntity.getTransAmount());
            emvTransData.setCashbackAmount(emvCardControlEntity.getCashbackAmount());
            emvCardControlEntity.setCardType(cardType);
            emvTransDataEntity = getEmvTransDataEntity(emvCardControlEntity);
            emvCardControlEntity.setProcType(emvTransDataEntity.getEmvProcessFlowEnum());

            setEmvContactlessType(EmvContactlessType.CTLS_TYPE_STANARD);
            setEmv55FieldDOLType(EmvContactlessType.CTLS_TYPE_STANARD);

            initEmvTermConfig();
            setEmvDebugLog(true);


            emvHandler.emvProcess(emvTransDataEntity, onEmvProcessListener);
        }

    }

    /**
     * getEmvTransDataEntity
     *
     * @return EmvTransDataEntity
     */
//    private EmvTransDataEntity getEmvTransDataEntity(EmvCardControlEntity controlEntity) {
//        EmvTransDataEntity emvTransDataEntity = new EmvTransDataEntity();
//
//        emvTransDataEntity.setAlgType(controlEntity.getAlgType());
//        if (controlEntity.getCardType() == CardType.CTLS) {
//            emvTransDataEntity.setChannelType(EmvChannelTypeEnum.FROM_PICC);
//        } else {
//            emvTransDataEntity.setChannelType(EmvChannelTypeEnum.FROM_ICC);
//        }
//        emvTransDataEntity.setProcType(emvBaseCallback.getEmvTransFlowEnum(controlEntity.getCardType()));
//        emvTransDataEntity.setB9C(mEmvCore.getEmvTransType());//mike_zj
////        emvTransDataEntity.setTransAmt(controlEntity.getTransAmount());
////        emvTransDataEntity.setCashbackAmt(controlEntity.getCashbackAmount());
//        emvTransDataEntity.setTransAmt(FormatUtils.appendArray(controlEntity.getTransAmount(), 12, true, '0'));
//        emvTransDataEntity.setCashbackAmt(FormatUtils.appendArray(controlEntity.getCashbackAmount(), 12, true, '0'));
//        emvTransDataEntity.setTermId(controlEntity.getTermId());
//        emvTransDataEntity.setMerId(controlEntity.getMerchantId());
////        emvTransDataEntity.setMerName(controlEntity.getMerchantName());
//        emvTransDataEntity.setTransDate(new SimpleDateFormat("yyMMdd", Locale.getDefault()).format(new Date()));
//        emvTransDataEntity.setTransTime(new SimpleDateFormat("hhmmss", Locale.getDefault()).format(new Date()));
//        emvTransDataEntity.setTraceNo(FormatUtils.appendArray(controlEntity.getTraceNo(), 6, true, '0'));//(controlEntity.getTraceNo());//mike_zj FIXME: 2018/1/26
//        emvTransDataEntity.setIsForceOnline(controlEntity.isForceOnline());
//        emvTransDataEntity.setIsDefaultEC(false);
//        emvTransDataEntity.setIsSupportEC(false);
//        log.debug("getEmvTransDataEntity" + FormatUtils.appendArray(controlEntity.getTransAmount(), 12, true, '0'));
//        log.debug("getEmvTransDataEntity" + FormatUtils.appendArray(controlEntity.getCashbackAmount(), 12, true, '0'));
//        return emvTransDataEntity;
//    }
    // FIXME: 2020/5/11
    private EmvTransConfigurationEntity getEmvTransDataEntity(EmvCardControlEntity controlEntity){
        EmvTransConfigurationEntity emvTransDataEntity = new EmvTransConfigurationEntity();

        if (controlEntity.getCardType() == CardType.CTLS) {
            emvTransDataEntity.setEmvEntryModeEnum(EmvEntryModeEnum.EMV_ENTRY_MODE_CONTACTLESS);
            DPASTransDataEntity dpasTransDataEntity = new DPASTransDataEntity();
            dpasTransDataEntity.setDpasVersion(DPASVersionEnum.DPAS_VERSION_2);
            emvTransDataEntity.setDpasTransDataEntity(dpasTransDataEntity);
        } else {
            emvTransDataEntity.setEmvEntryModeEnum(EmvEntryModeEnum.EMV_ENTRY_MODE_CONTACT);
        }
        emvTransDataEntity.setEmvProcessFlowEnum(emvBaseCallback.getEmvTransFlowEnum(controlEntity.getCardType()));
        emvTransDataEntity.setEmvTransType(mEmvCore.getEmvTransType());
        emvTransDataEntity.setTransAmount(FormatUtils.appendArray(controlEntity.getTransAmount(), 12, true, '0'));
        emvTransDataEntity.setCashbackAmount(FormatUtils.appendArray(controlEntity.getCashbackAmount(), 12, true, '0'));
        emvTransDataEntity.setTermId(controlEntity.getTermId());
        emvTransDataEntity.setMerId(controlEntity.getMerchantId());
        emvTransDataEntity.setTransDate(new SimpleDateFormat("yyMMdd", Locale.getDefault()).format(new Date()));
        emvTransDataEntity.setTransTime(new SimpleDateFormat("hhmmss", Locale.getDefault()).format(new Date()));
        emvTransDataEntity.setTraceNo(FormatUtils.appendArray(controlEntity.getTraceNo(), 6, true, '0'));//(controlEntity.getTraceNo());//mike_zj FIXME: 2018/1/26
        emvTransDataEntity.setContactForceOnline(controlEntity.isForceOnline());

        emvTransDataEntity.setCurrencyCode(gData.getSetupEntity().getTermCurrencyCode());
        emvTransDataEntity.setCountryCode(gData.getSetupEntity().getTermCountryCode());



        log.debug("getEmvTransDataEntity" + FormatUtils.appendArray(controlEntity.getTransAmount(), 12, true, '0'));
        log.debug("getEmvTransDataEntity" + FormatUtils.appendArray(controlEntity.getCashbackAmount(), 12, true, '0'));
        return emvTransDataEntity;
    }
    private void processConfirmCardNumber() {
        log.debug("processConfirmCardNumber");
        view.showDialog(false, null, null);

        switch (emvTransData.getCardType()) {
            case MAG:
                if (isTransNeedPin()) {
                    showInputPin(emvCardControlEntity.getPinKeyIndex(), true, 0, emvTransData.getPan(), mInputPinCallBack);
                } else {
                    emvBaseCallback.onProcessMagCard(cardInfo);
                }
                break;

            case MANUAL:
                if (isTransNeedPin()) {
                    showInputPin(emvCardControlEntity.getPinKeyIndex(), true, 0, emvTransData.getPan(), mInputPinCallBack);
                } else {
                    emvBaseCallback.onProcessManualCard(cardInfo);
                }
                break;

            default:
                view.showDialog(true, BaseUtils.getApp().getString(R.string.wait), BaseUtils.getApp().getString(R.string.emv_read_hold_card));
                emvHandler.onSetConfirmCardNoResponse(true);
                break;
        }
    }

    private InputPinCallBack mInputPinCallBack = new InputPinCallBack() {
        @Override
        public void onPin(byte[] pinlock) {
            log.debug("InputPinCallBack onPin");
            processInputPin(pinlock);
        }

        @Override
        public void onPass() {
            log.debug("InputPinCallBack onPin");
            processInputPin(null);
        }

        @Override
        public void onError(ErrorType error) {
            log.debug("InputPinCallBack onError");
            view.finishActivity(BaseUtils.getApp().getString(R.string.emv_trans_failed));
        }

        @Override
        public void onCancel() {
            log.debug("InputPinCallBack onCancel");
            if (isEmvFullFlow() || isEmvQpassFlow()) {
                log.debug("InputPinCallBack onCancel onSetPinInputResponse");
                emvHandler.onSetPinInputResponse(false, false);
                return ;
            }
            view.finishActivity(null);
        }

        @Override
        public void onTimeOut() {
            log.debug("InputPinCallBack onTimeOut");
            if (isEmvFullFlow() || isEmvQpassFlow()) {
                emvHandler.onSetPinInputResponse(false, false);
                return ;
            }
            view.finishActivity(null);
        }
    };

    private void processInputPin(byte[] pinBlock) {
        log.debug("processInputPin");

        if (emvTransData.isOnlinePin()) {
            emvTransData.setPinBlock(pinBlock);
            cardInfo.setPinBlock(pinBlock);
        }
        if (isICCTrans()) {
            view.showDialog(true, BaseUtils.getApp().getString(R.string.wait), BaseUtils.getApp().getString(R.string.emv_read_hold_card));
            if (isEmvMsdFlow()) {
                log.debug("processInputPin isEmvMsdFlow");
                emvBaseCallback.onEmvMsdFlow(cardInfo);
            } else if (!isEmvSimpleFlow()) {
                //icc trans , FULL or QPASS need callback to emv kernel
                log.debug("processInputPin isICCTrans");
                emvHandler.onSetPinInputResponse(true, pinBlock == null);
            } else {
                emvBaseCallback.onEmvSimpleFlow(cardInfo);
            }
        } else {
            view.showDialog(false, null, null);
            if (emvTransData.getCardType() == CardType.MAG) {
                emvBaseCallback.onProcessMagCard(cardInfo);
            } else {
                emvBaseCallback.onProcessManualCard(cardInfo);
            }
        }
    }

    /**
     * config paypass parameters
     * @param aid
     */
    private void configPayPassParameters(byte[] aid){
        String transAmount = FormatUtils.appendArray(emvTransData.getTransAmount(),12,true,'0');
        byte[] contactlessCvmLimit = emvHandler.getTlv(new byte[]{(byte) 0xdf, (byte) 0x81, (byte) 0x26}, EmvDataSourceEnum.FROM_KERNEL);

        // FIXME: 2018/8/7 Hassan Maestro need config
        if(ConvertUtils.bytes2HexString(aid, "").toUpperCase().contains("A0000000043060")){
            //Maestro contactless
            if(transAmount.compareToIgnoreCase(ByteUtils.byteArray2HexString(contactlessCvmLimit)) <= 0){
                emvHandler.setTlv(ConvertUtils.hexString2Bytes("9F33"), ConvertUtils.hexString2Bytes("E00808"));  //Terminal Capabilities, online PIN & signature & SDA & DDA & CDA

                //emv
                emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF8119"), ConvertUtils.hexString2Bytes("08"));
            }else{
                emvHandler.setTlv(ConvertUtils.hexString2Bytes("9F33"), ConvertUtils.hexString2Bytes("E04008"));  //Terminal Capabilities, online PIN & signature & SDA & DDA & CDA

                //emv
                emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF8118"), ConvertUtils.hexString2Bytes("40"));
            }
        }else{
            if(transAmount.compareToIgnoreCase(ByteUtils.byteArray2HexString(contactlessCvmLimit)) <= 0){
                emvHandler.setTlv(ConvertUtils.hexString2Bytes("9F33"), ConvertUtils.hexString2Bytes("E00808"));  //Terminal Capabilities, online PIN & signature & SDA & DDA & CDA
                //emv
                emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF8119"), ConvertUtils.hexString2Bytes("08"));      //(EMV mode)CVM Capability -No CVM Required, 0x20-signature

            }else{
                emvHandler.setTlv(ConvertUtils.hexString2Bytes("9F33"), ConvertUtils.hexString2Bytes("E06008"));  //Terminal Capabilities, online PIN & signature & SDA & DDA & CDA

                //emv
                emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF8118"), ConvertUtils.hexString2Bytes("60"));      //(EMV mode)CVM Capability -CVM Required,  0x60 - online PIN & signature  , 0x20-signature
            }
        }

        //tac set for paywave, if contact and contactless TAC is different

        //TacDefault
        //emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF8120"), ConvertUtils.hexString2Bytes("fc50b8a000"));

        //TacDecline
        //emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF8121"), ConvertUtils.hexString2Bytes("0000000000"));

        //TacOnline
        //emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF8122"), ConvertUtils.hexString2Bytes("fc50808800"));

    }


    /**
     * set default TTQ value for paywave
     * note:If there is no special requirements, does not change TTQ byte 2
     * if online force required , can set byte2 bit 8 = 1
     */
    private void configPaywaveParameters(){
        byte[] TTQ ;
        byte[] kernelTTQ = emvHandler.getTlv(ConvertUtils.hexString2Bytes("9F66"), EmvDataSourceEnum.FROM_KERNEL);

        //default TTQ value
        TTQ = ByteUtils.hexString2ByteArray("36004000");
        kernelTTQ[0] = TTQ[0];
        kernelTTQ[2] = TTQ[2];
        kernelTTQ[3] = TTQ[3];

        // FIXME: 2019/3/20 
        //If there is no special requirements, do not change TTQ byte1
        //if online force required , can set byte2 bit 8 = 1
//        kernelTTQ[1] = setBitValue(kernelTTQ[1], 7, (byte) 1);

        emvHandler.setTlv(ConvertUtils.hexString2Bytes("9F66"), kernelTTQ);


        //tac set for paywave, if contact and contactless TAC is different

        //TacDefault
        //emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF8120"), ConvertUtils.hexString2Bytes("fc50b8a000"));

        //TacDecline
        //emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF8121"), ConvertUtils.hexString2Bytes("0000000000"));

        //TacOnline
        //emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF8122"), ConvertUtils.hexString2Bytes("fc50808800"));
    }

    /**
     * initEmvTermConfig ,include Terminal Capabilities, country code, currency code...
     */
    @Override
    public void initEmvTermConfig() {
        //contact terminal Capability, can set custom value here. It is only valid for contact
        emvHandler.setTlv(ConvertUtils.hexString2Bytes("9F33"), ConvertUtils.hexString2Bytes("E0F8C8")); //Terminal Capabilities

        //9f1a-country code currency code 9f1a 5f2a 9f3c
        emvHandler.initTermConfig(ByteUtils.hexString2ByteArray("9f1a0208405f2a0208409f3c020840"));

        //for paywave check limit, should set before emv process
        HashMap<String, String> ctlsCfg = EmvUtils.getCtlsCfgPaywave();
        emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF03"), ConvertUtils.hexString2Bytes(ctlsCfg.get("DF03")));    //CASH & CASHBACK-OFF, GOODS & SERVICES-ON

    }

    /**
     * initEmvContactlessTermConfig, include paypass, paywave Emv TAGS,should be called in onAfterFinalSelectedApp
     * <p>
     * if pass certificate , user can modify contactless config file "emvcontactlesscfg.xml" in path -->
     * --> Environment.getExternalStorageDirectory().getPath()+"/"+BaseUtils.getApp().getPackageName() + /emvcontactlesscfg.xml";
     */
    @Override
    public void initEmvContactlessTermConfig() {
        log.debug("initEmvContactlessTermConfig ");
        byte[] aid = emvHandler.getTlv(new byte[]{0x4F}, EmvDataSourceEnum.FROM_KERNEL);
        if (aid != null) {
            if (ConvertUtils.bytes2HexString(aid, "").toUpperCase().contains("A000000004")
                    || ConvertUtils.bytes2HexString(aid, "").toUpperCase().contains("A0000000101030")) {
                //master
                log.debug("initEmvContactlessTermConfig paypass");
                HashMap<String, String> ctlsCfg = EmvUtils.getCtlsCfgPaypass();
                log.debug("initEmvContactlessTermConfig paypass ctlsCfg-->" + ctlsCfg);
                emvHandler.setTlv(ConvertUtils.hexString2Bytes("9F33"), ConvertUtils.hexString2Bytes(ctlsCfg.get("9F33")));  //Terminal Capabilities, online PIN & signature & SDA & DDA & CDA
                emvHandler.setTlv(ConvertUtils.hexString2Bytes("9F40"), ConvertUtils.hexString2Bytes(ctlsCfg.get("9F40")));    ////Additional Terminal Capabilities, Goods & Services
                emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF8118"), ConvertUtils.hexString2Bytes(ctlsCfg.get("DF8118")));      //(EMV mode)CVM Capability -CVM Required,  0x60 - online PIN & signature  , 0x20-signature
                emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF8119"), ConvertUtils.hexString2Bytes(ctlsCfg.get("DF8119")));      //(EMV mode)CVM Capability -No CVM Required, 0x20-signature
                emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF811B"), ConvertUtils.hexString2Bytes(ctlsCfg.get("DF811B")));      //Kernel Configuration, b8-only EMV mode, b7-only mag-stripe mode, b6-On device cardholder verification supported(for mobile)
                emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF8125"), ConvertUtils.hexString2Bytes(ctlsCfg.get("DF8125")));  //Reader Contactless Transaction Limit (On-device CVM), for mobile only!!!
                // FIXME: 2018/8/7 Hassan below config need confirm when certificate
//                emvHandler.setTlv(ConvertUtils.hexString2Bytes("9F6D"), ConvertUtils.hexString2Bytes(ctlsCfg.get("9F6D")));    //Mag-stripe Application Version Number
//                emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF8125"), ConvertUtils.hexString2Bytes(ctlsCfg.get("DF8125")));  //Reader Contactless Transaction Limit (On-device CVM), for mobile only!!!
//                emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF811E"), ConvertUtils.hexString2Bytes(ctlsCfg.get("DF811E")));    //(MSD mode)Mag-stripe CVM Capability -CVM Required,  0x20-online PIN, 0x10-signature
//                emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF812C"), ConvertUtils.hexString2Bytes(ctlsCfg.get("DF812C")));    //(MSD mode)Mag-stripe CVM Capability -No CVM Required,  0x00-no CVM, 0x20-online PIN, 0x10-signature
//                emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF811F"), ConvertUtils.hexString2Bytes(ctlsCfg.get("DF811F")));      //Security Capability, BIT8:SDA, BIT7:DDA, BIT4:CDA
//                emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF8117"), ConvertUtils.hexString2Bytes(ctlsCfg.get("DF8117")));      //Card Data Input Capability    //b8-Manual key entry, b7-Magnetic stripe, b6-IC with contacts,b5-1RFU
                // FIXME: 2018/8/7 Hassan Maestro need config
                if (ConvertUtils.bytes2HexString(aid, "").toUpperCase().contains("A0000000043060")) {
                    //Maestro contactless
                    log.debug("initEmvContactlessTermConfig contactless Maestro");
                    emvHandler.setTlv(ConvertUtils.hexString2Bytes("9F33"), ConvertUtils.hexString2Bytes("E040C8"));
                    emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF8118"), ConvertUtils.hexString2Bytes("40"));
                    emvHandler.setTlv(ConvertUtils.hexString2Bytes("DF8119"), ConvertUtils.hexString2Bytes("40"));
                }
                // FIXME: 2019/3/20 if have special requirement for 9F33, please open this line
//                configPayPassParameters(aid);

                setEmvContactlessType(EmvContactlessType.CTLS_TYPE_PAYPASS);

            } else if (ConvertUtils.bytes2HexString(aid, "").toUpperCase().contains("A000000003")) {
                //visa
                log.debug("initEmvContactlessTermConfig paywave");
                HashMap<String, String> ctlsCfg = EmvUtils.getCtlsCfgPaywave();
                log.debug("initEmvContactlessTermConfig paywave ctlsCfg-->" + ctlsCfg);

                emvHandler.setTlv(ConvertUtils.hexString2Bytes("9F33"), ConvertUtils.hexString2Bytes(ctlsCfg.get("9F33")));    //Terminal Capabilities     //online PIN & signature & SDA & DDA & CDA
                emvHandler.setTlv(ConvertUtils.hexString2Bytes("9F40"), ConvertUtils.hexString2Bytes(ctlsCfg.get("9F40")));    //CASH & CASHBACK-OFF, GOODS & SERVICES-ON

                // FIXME: 2018/8/7 Hassan if 9F66 have special default value ,open this line
//                configPaywaveParameters();
                setEmvContactlessType(EmvContactlessType.CTLS_TYPE_PAYWAVE);

            } else if (ConvertUtils.bytes2HexString(aid, "").toUpperCase().contains("A000000025")) {
                //amex
                log.debug("initEmvContactlessTermConfig amex contactless");

                setEmvContactlessType(EmvContactlessType.CTLS_TYPE_AMEX);

            } else if (ConvertUtils.bytes2HexString(aid, "").toUpperCase().contains("A000000065")) {
                //jcb
                log.debug("initEmvContactlessTermConfig jcb contactless");

            }
            else if(ConvertUtils.bytes2HexString(aid, "").toUpperCase().contains("A000000152")){
                //discover
                log.debug("initEmvContactlessTermConfig discover contactless");

            }
        }
    }


    private void doContactlessLedProcess(int retCode){
        if(!isContactlessICCTrans()){
            return ;
        }

        switch (retCode){
            case SdkResult.Emv_Qpboc_Offline:// EMV Contactless: Offline Approval
            case SdkResult.Emv_Offline_Accept://EMV Contact: Offline Approval
            case SdkResult.Emv_Qpboc_Online://EMV Contactless: Online Process
                if(!emvTransData.isContactlessLedFlag()){
                    appBeeper.startBeeper(100);//add by hassan
                    ledDriverHelper.controlContactlessLed(LED_READCARD_SUCCESS);
                }
                break;

            case SdkResult.Emv_App_Block:
            case SdkResult.Emv_App_Expired:
            case SdkResult.Emv_App_Ineffect:
            case SdkResult.Emv_Offline_Declined:
            case SdkResult.Emv_Command_Fail:
            case SdkResult.Emv_Other_Interface:
                appBeeper.startBeeper(100);//add by hassan
                ledDriverHelper.controlContactlessLed(LED_READCARD_FAILED);
                break;

            default:
                ledDriverHelper.controlContactlessLed(LED_CLOSE);
                ledDriverHelper.controlContactlessLed(LED_HIDE);
                break;
        }
    }

    /**
     * EmvProcessListener
     */
    private final OnEmvProcessListener2 onEmvProcessListener = new OnEmvProcessListener2() {

        // FIXME: 2020/5/11
//        @Override
//        public void onRequestAmount() {
//            onEmvRequestAmount();
//        }

        @Override
        public void onSelApp(List<String> appNameList, List<CandidateAppInfoEntity> appInfoList, boolean isFirstSelect) {
            onEmvSelApp(appNameList, appInfoList, isFirstSelect);
        }

        // FIXME: 2020/4/21 Hassan add
        @Override
        public void onTransInitBeforeGPO() {
            log.debug("call onTransInitBeforeGPO()");
            initEmvContactlessTermConfig();
            emvHandler.onSetTransInitBeforeGPOResponse(true);
        }

        // FIXME: 2020/4/21 Hassan add
        @Override
        public void onContactlessTapCardAgain() {
            onEmvReadCardAgain();
        }


        @Override
        public void onConfirmCardNo(CardInfoEntity cardInfo) {
            onTransConfirmPan(cardInfo);
        }

        @Override
        public void onCardHolderInputPin(boolean isOnlinePin, int leftTimes) {
            onTransInputPin(isOnlinePin, leftTimes);
        }


        @Override
        public void onOnlineProc() {
            onTransOnlineProcess();
        }


        @Override
        public void onRemoveCard() {
            log.debug("onRemoveCard()");
            appBeeper.startBeeper(100);//add by hassan
            ledDriverHelper.controlContactlessLed(LED_READCARD_SUCCESS);
            emvHandler.onSetRemoveCardResponse();
        }


        @Override
        public void onFinish(int retCode, EmvProcessResultEntity entity) {
            view.showDialog(false, null, null);

            doContactlessLedProcess(retCode);

            onEmvFinish(retCode, entity);
        }

        @Override
        public void onPrompt(PromptEnum promptEnum) {
            emvHandler.onSetPromptResponse(true);
        }
    };

    /**
     * SelApp
     *
     * @param appNameList
     * @param appInfoList
     * @param isFirstSelect
     */
    protected void onEmvSelApp(final List<String> appNameList, List<CandidateAppInfoEntity> appInfoList, boolean isFirstSelect) {
        log.debug("onEmvSelApp ");
        log.debug("onEmvSelApp " + appNameList.size());

        this.view.onEmvRequestSelectApp(appNameList, mselectAppCallBack);

        // FIXME: 2018/8/6 some project can select the first application by default, open this line
        //        emvHandler.onSetSelAppResponse(0 + 1);
    }

    /**
     * EMVRequestAmount
     */
    protected void onEmvRequestAmount() {// FIXME: 2018/1/26 蒋苏勇说还没有做
        log.debug("onEmvRequestAmount not support");
    }

    /**
     * paypass,paywave
     * ReadCardAgain
     */
    protected void onEmvReadCardAgain() {
        log.debug("onEmvReadCardAgain ");
        emvCardControlEntity.setSupportMag(false);
        emvCardControlEntity.setSupportMag(false);
        emvCardControlEntity.setSupportICC(false);

        emvTransData.setReadClsAgain(true);
        ToastUtils.showShort(BaseUtils.getApp().getString(R.string.emv_read_card_contactless_again));

        showReadCard();
    }

    /**
     * CerVerify
     *
     * @param certName
     * @param certInfo
     */
    protected void onEmvCerVerify(String certName, String certInfo) {
        log.debug("onEmvCerVerify do not support ");
    }

    /**
     * OnlineProc
     */
    protected void onTransOnlineProcess() {
        log.debug("onTransOnlineProcess");
        if (isICCTrans()) {
            if(isContactlessICCTrans()){
                if(!emvTransData.isContactlessLedFlag()){
                    appBeeper.startBeeper(100);//add by hassan
                    emvTransData.setContactlessLedFlag(true);
                    ledDriverHelper.controlContactlessLed(LED_READCARD_SUCCESS);
                }
            }


            //SdkResult.Emv_MSD_Online  never be return by onEmvFinish
            //MSD flow need process in method onOnlineProcess.
            if (emvHandler.getEmvContactlessMode() == EmvModeEnum.MSD) {
                onMsdTransFlow();
                return;
            }

            if (!isEmvSimpleFlow()) {
                if (isContactlessICCTrans()) {
                    setEmvCardInfo();
                }

                setEmvTransCount();
                setEmv55FieldDOLType(getEmvContactlessType());
                emvTransData.setField55Tlv(mEmvCore.getEmvRecordTLV());
            }
        }
        emvBaseCallback.onEmvRequestOnlineProcess();
    }

    /**
     * 9f41
     */
    private void setEmvTransCount() {
        String emvTransCount = "00" + emvCardControlEntity.getTraceNo();

        emvHandler.setTlv(ByteUtils.hexString2ByteArray("9F41"), ByteUtils.hexString2ByteArray(emvTransCount));

    }

    /**
     * ConfirmPan
     *
     * @param cardInfo
     */
    protected void onTransConfirmPan(CardInfoEntity cardInfo) {
        log.debug("onTransConfirmPan");
        emvTransData.setPan(cardInfo.getCardNo());
        emvTransData.setTk1(cardInfo.getTk1());
        emvTransData.setTk2(cardInfo.getTk2());
        emvTransData.setTk3(cardInfo.getTk3());
        emvTransData.setExpDate(cardInfo.getExpiredDate());
        emvTransData.setServiceCode(cardInfo.getServiceCode());
        emvTransData.setCsn(cardInfo.getCsn());
        //contactless do not confirm cardnumber
        if (emvTransData.getCardType() == CardType.CTLS) {
            emvTransData.setContactlessLedFlag(true);
            appBeeper.startBeeper(100);//add by hassan
            ledDriverHelper.controlContactlessLed(LED_READCARD_SUCCESS);
            emvHandler.onSetConfirmCardNoResponse(true);
        } else if (emvTransData.getCardType() == CardType.ICC) {
            if (!emvCardControlEntity.isConfirmPan()) {
                emvHandler.onSetConfirmCardNoResponse(true);
            } else {
                this.view.onEmvRequestConfirmCardNumber(emvTransData.getPan(), emvTransData.getTransAmount(), mconfirmPanCallBack);
            }
        } else {
            this.view.onEmvRequestConfirmCardNumber(emvTransData.getPan(), emvTransData.getTransAmount(), mconfirmPanCallBack);
        }

    }

    /**
     * InputPin
     *
     * @param isOnlinePin
     * @param leftTimes
     */
    protected void onTransInputPin(boolean isOnlinePin, final int leftTimes) {
        log.debug("onTransInputPin" + "isOnlinePin " + isOnlinePin + "leftTimes" + leftTimes);
        view.showDialog(false, null, null);

/*        if(isContactlessICCTrans()){
            if(!emvTransData.isContactlessLedFlag()){
                emvTransData.setContactlessLedFlag(true);
                appBeeper.startBeeper(100);//add by hassan
                ledDriverHelper.controlContactlessLed(LED_READCARD_SUCCESS);
            }
        }*/

        if (!isICCTrans()) {
            showInputPin(emvCardControlEntity.getPinKeyIndex(), true, 0, emvTransData.getPan(), mInputPinCallBack);
        } else {
            if (isOnlinePin) {
                switch (emvCardControlEntity.getProcType()) {
                    // FIXME: 2020/5/11
                    case EMV_PROCESS_FLOW_STANDARD:
                        if(emvTransData.getPan() == null){
                            setEmvCardInfo();
                        }
                        showInputPin(emvCardControlEntity.getPinKeyIndex(), true, 0, emvTransData.getPan(), mInputPinCallBack);
                        break;

//                    case QPASS:
//                        log.debug("onTransInputPin" + "QPASS ");
//                        showInputPin(emvCardControlEntity.getPinKeyIndex(), true, 0, emvTransData.getPan(), mInputPinCallBack);
//                        break;

                    case EMV_PROCESS_FLOW_READ_APPDATA:
                    default:
                        showInputPin(emvCardControlEntity.getPinKeyIndex(), true, 0, emvTransData.getPan(), mInputPinCallBack);
                        break;
                }
            } else {
                emvTransData.setOnlinePin(false);
                showInputPin(emvCardControlEntity.getPinKeyIndex(), false, leftTimes, null, mInputPinCallBack);
            }
        }
    }

    /**
     * Emv flow Finish
     *
     * @param retCode
     * @param entity
     */
    protected void onEmvFinish(final int retCode, final EmvProcessResultEntity entity) {
        log.debug("onEmvFinish " + "retCode" + retCode);

        Context context = BaseUtils.getApp();

        switch (retCode) {
            case SdkResult.Emv_Success_Arpc_Fail:
                emvTransData.setArpcErr(true);
            case SdkResult.Success://
                if (isEmvSimpleFlow()) {
                    onSimpleTransFlowSuccess();
                } else {
                    EmvTransFinish(EmvTransState.EMV_ONLINE_APPROVE, context.getString(R.string.emv_online_approve));
                }
                break;

            case SdkResult.Emv_Qpboc_Offline:// EMV Contactless: Offline Approval
            case SdkResult.Emv_Offline_Accept://EMV Contact: Offline Approval
                emvTransData.setOfflineState(OfflineState.APPROVE);
                setEmvCardInfo();
                EmvTransFinish(EmvTransState.EMV_OFFLINE_APPROVE, context.getString(R.string.emv_offline_approve));
                break;

            case SdkResult.Emv_Qpboc_Online://EMV Contactless: Online Process for union pay
                onEmvQpbocOnlineFlow();
                break;

            //confirm with zhouxiaoxin, this return code will never be called.
            //MSD flow need process in method onOnlineProc.
//            case SdkResult.Emv_MSD_Online://mike_zj20180126 remove FIXME: 2018/1/26
//                onMsdTransFlow();
//                break;

            case SdkResult.Emv_Candidatelist_Empty:// No Application List
            case SdkResult.Emv_FallBack://  FallBack
                if (emvCardControlEntity.isSupportFallback()) {
                    onEmvFallbackFlow();
                    return;
                }
                EmvTransFinish(EmvTransState.EMV_ERR_OTHER, context.getString(R.string.emv_other_error));
                break;

            case SdkResult.Emv_Arpc_Fail: //
            case SdkResult.Emv_Script_Fail:
            case SdkResult.Emv_Declined:
                if (emvOnlineResultEntity == null) {
                    EmvTransFinish(EmvTransState.EMV_ERR_OTHER, context.getString(R.string.emv_other_error));
                } else {
                    if (!isCheckresponseCode(emvOnlineResultEntity.getRejCode())) {
                        EmvTransFinish(EmvTransState.EMV_ERR_ONLINE_DECLINED_RESPONSE, context.getString(R.string.emv_online_decline_response));
                    } else {
                        EmvTransFinish(EmvTransState.EMV_ERR_ONLINE_DECLINED_REVERSAL, context.getString(R.string.emv_online_decline_reversal));
                    }
                }
                break;

            case SdkResult.Emv_Cancel:// Transaction Cancel
//                EmvTransFinish(EmvTransState.EMV_ERR_CANCEL, null);
                view.finishActivity(null);
                break;

            case SdkResult.Emv_Offline_Declined: //
                emvTransData.setOfflineState(OfflineState.DECLINED);
                setEmvCardInfo();
                EmvTransFinish(EmvTransState.EMV_ERR_OFFLINE_DECLINED, context.getString(R.string.emv_offline_decline));
                break;

            case SdkResult.Emv_Card_Block: //Card Block
                EmvTransFinish(EmvTransState.EMV_ERR_CARD_BLOCK, context.getString(R.string.emv_card_block));
                break;

            case SdkResult.Emv_App_Block: // Application Block
                EmvTransFinish(EmvTransState.EMV_ERR_APP_BLOCK, context.getString(R.string.emv_app_block));
                break;

            case SdkResult.Emv_App_Ineffect:
                EmvTransFinish(EmvTransState.EMV_ERR_APP_INEFFECT, context.getString(R.string.emv_app_uneffect));
                break;

            case SdkResult.Emv_App_Expired:
                EmvTransFinish(EmvTransState.EMV_ERR_APP_EXPIRED, context.getString(R.string.emv_app_expired));
                break;

            case SdkResult.Emv_Other_Interface:
                EmvTransFinish(EmvTransState.EMV_ERR_OTHER_INTERFACE, context.getString(R.string.emv_other_interface));
                break;

            // FIXME: 2018/8/6 add see phone
            case SdkResult.Emv_Plz_See_Phone:
                onEmvSeePhoneFlow();
                break;

            default:
                EmvTransFinish(EmvTransState.EMV_ERR_OTHER, context.getString(R.string.emv_other_error));
                break;
        }
    }


    /**
     * EmvTransFinish
     *
     * @param emvTransState
     */
    private void EmvTransFinish(final EmvTransState emvTransState, String description) {
        log.debug("EmvTransFinish");
        if (isEmvFullFlow() || isEmvQpassFlow()) {
            emvTransData.setScriptTlv(mEmvCore.getEmvScriptTLV());

//            if(EmvTransState.EMV_ONLINE_APPROVE.equals(emvTransState)
//                    || EmvTransState.EMV_OFFLINE_APPROVE.equals(emvTransState)){
//                if(EmvTransState.EMV_ONLINE_APPROVE.equals(emvTransState)){
//                    emvTransData.setField55Tlv(mEmvCore.getEmvARQCTLV());
//                }else{
//                    emvTransData.setField55Tlv(mEmvCore.getEmvOfflineTLV());
//                }
//                emvTransData.setResultTlv(mEmvCore.getEmvTransResultTLV());
//            }
            emvTransData.setField55Tlv(mEmvCore.getEmvRecordTLV());
        }
        emvBaseCallback.onFinish(emvTransState, description);
    }

    /**
     * SimpleTransFlow
     */
    protected void onSimpleTransFlowSuccess() {
        log.debug("onSimpleTransFlowSuccess");
        view.showDialog(false, null, null);

        //need get cardinfo before
        setEmvCardInfo();

        if (isTransNeedPin()) {
            showInputPin(emvCardControlEntity.getPinKeyIndex(), true, 0, emvTransData.getPan(), mInputPinCallBack);
        } else {
            emvBaseCallback.onEmvSimpleFlow(cardInfo);
        }
    }

    /**
     * FallbackFlow
     */
    protected void onEmvFallbackFlow() {
        log.debug("onEmvFallbackFlow");
        ToastUtils.showShort(BaseUtils.getApp().getString(R.string.emv_read_card_swipe));
        emvTransData.setFallback(true);
        cardInfo.setFallback(true);
        emvCardControlEntity.setSupportCTLS(false);
        emvCardControlEntity.setSupportICC(false);
        emvCardControlEntity.setSupportManual(false);
        emvCardControlEntity.setSupportMag(true);

        showReadCard();
    }

    /**
     * onMsdTransFlowSuccess
     */
    protected void onMsdTransFlow() {
        log.debug("onMsdTransFlow");
        emvTransData.setMsdFlow(true);
        //need get cardinfo before
        setEmvCardInfo();

        if (isMsdPwdRequired()) {
            showInputPin(emvCardControlEntity.getPinKeyIndex(), true, 0, emvTransData.getPan(), mInputPinCallBack);
        } else {
            emvBaseCallback.onEmvMsdFlow(cardInfo);
        }
    }

    /**
     * SeePhone
     */
    protected void onEmvSeePhoneFlow() {
        log.debug("onEmvSeePhoneFlow");

        view.showDialog(false, null, null);
        ToastUtils.showShort(BaseUtils.getApp().getString(R.string.emv_read_card_see_phone));
        this.view.onEmvRequestSeePhone(seePhoneListener);
    }

    SeePhoneDialog.OnClickListener seePhoneListener = new SeePhoneDialog.OnClickListener() {
        @Override
        public void onCardRemoved() {
            log.debug("onEmvSeePhoneFlow onCardRemoved");
            emvTransData.setClsSeePhone(true);
            emvCardControlEntity.setSupportCTLS(true);
            emvCardControlEntity.setSupportICC(false);
            emvCardControlEntity.setSupportManual(false);
            emvCardControlEntity.setSupportMag(false);

            showReadCard();
        }

        @Override
        public void onCancel() {
            log.debug("onEmvSeePhoneFlow onCancel");
            view.finishActivity(BaseUtils.getApp().getString(R.string.emv_trans_cancel));
        }
    };

    private void showInputPin(int pinKeyIndex, boolean bisOnline, int leftTimes, String pan, InputPinCallBack inputPinCallBack) {
        log.debug("showInputPin");
        view.showDialog(false, null, null);

        // FIXME: 2019/1/18 Hassan remark:
        emvTransData.setOnlinePin(bisOnline);

        InputPinData inputPinData = new InputPinData();
        inputPinData.setOfflinePin(!bisOnline);
        inputPinData.setPan(pan);
        inputPinData.setRemainTimes(leftTimes);
        inputPinData.setKeyIndex(pinKeyIndex);

        inputPinData.setAmountBean(new AmountBean(Long.parseLong(emvCardControlEntity.getTransAmount()), 2, 3, gData.getSetupEntity().getTermCurrencyName()));//mike_zj

        this.view.onEmvRequestInputPin(BaseUtils.getApp().getString(emvCardControlEntity.getTransType().getName()), inputPinData, inputPinCallBack);
    }


    /**
     * onEmvQpbocOnlineFlow
     */
    protected void onEmvQpbocOnlineFlow() {
        log.debug("onEmvQpbocOnlineFlow");
        view.showDialog(false, null, null);
        setEmvCardInfo();

//        emvTransData.setField55Tlv(mEmvCore.getEmvARQCTLV());
//        emvTransData.setReversalTlv(mEmvCore.getEmvReversalTLV());
//        emvTransData.setResultTlv(mEmvCore.getEmvTransResultTLV());

        emvTransData.setField55Tlv(mEmvCore.getEmvRecordTLV());
        emvBaseCallback.onEmvQpbocOnlineProcess();
    }


    private SelectAppCallBack mselectAppCallBack = new SelectAppCallBack() {
        @Override
        public void select(int i) {
            log.debug("SelectAppCallBack select");
            emvHandler.onSetSelAppResponse(i + 1);
        }

        @Override
        public void cancel() {
            log.debug("SelectAppCallBack cancel");
            view.finishActivity(null);
        }
    };


    @Override
    public IEmvCore getEmvCore() {
        return mEmvCore;
    }

    @Override
    public void finishProcess() {
        if (emvHandler != null) {
            emvHandler.emvProcessCancel();
        }

        ledDriverHelper.controlContactlessLed(LED_CLOSE);

        // FIXME: 2018/8/6 Hassan should power off
        poweroffEmvIcc();
    }

    private void poweroffEmvIcc() {
        CPUCardHandler cpuCardHandler;

        if (emvTransData.getCardType() == CardType.CTLS) {
            cpuCardHandler = APIProxy.getDeviceEngine(BaseUtils.getApp().getApplicationContext()).getCPUCardHandler(CardSlotTypeEnum.RF);
            cpuCardHandler.remove();
        } else if (emvTransData.getCardType() == CardType.ICC) {
            cpuCardHandler = APIProxy.getDeviceEngine(BaseUtils.getApp().getApplicationContext()).getCPUCardHandler(CardSlotTypeEnum.ICC1);
            cpuCardHandler.powerOff();
        }

    }

    private IEmvCore mEmvCore = new IEmvCore() {
        @Override
        public EmvTransData getEmvTransData() {
            return emvTransData;
        }

        /**
         * get all emv tags, will save in record;
         * user can select part tags when package request bags.
         * @return
         */
        @Override
        public String getEmvRecordTLV() {
            final String[] standard_Tags = {
                    "9f26",
                    "9f27",
                    "9f10",
                    "9f37",
                    "9f36",
                    "95",
                    "9a",
                    "9c",
                    "9f02",
                    "5f2a",
                    "9f1a",
                    "82",
                    "9f33",
                    "9f34",
                    "9f03",
                    "84",
                    "9F08",
                    "9f09",
                    "9f35",
                    "9f1e",
                    "9F53",
                    "9f41",
                    "9f63",
                    "9F6E",
                    "9F4C",
                    "9F5D",
                    "9B",
                    "5F34",
                    "50",
                    "9F12",
                    "91",
                    "DF31"
            };

            log.debug("9f66-->" + ByteUtils.byteArray2HexString(emvHandler.getTlv(new byte[]{(byte) 0x9f, (byte) 0x66}, EmvDataSourceEnum.FROM_KERNEL)));

            return emvHandler.getTlvByTags(standard_Tags);
        }

        /**
         * getEmv online tags
         * @return
         */
        @Override
        public String getEmvARQCTLV() {
            final String[] standard_Tags = {"9f26", "9f27", "9f10", "9f37", "9f36", "95", "9a", "9c",
                    "9f02", "5f2a", "82", "9f1a", "9f03", "9f33", "9f34", "9f35", "9f1e", "9f09", "84",
                    "9f41", "9f63"};

            log.debug("getEmvARQCTLV EmvContactlessType" + emvTransData.getEmvContactlessType());

            return emvHandler.getTlvByTags(standard_Tags);

        }

        /**
         * getEmvTransResultTLV
         * @return
         */
        @Override
        public String getEmvTransResultTLV() {
            final String[] TAGS = {"95", "9b", "9f36", "9f26", "91", "9f10", "df31", "9f79", "9f27", "84", "9f06", "50", "9f12", "9f33", "9f37",
                    "9f34", "82", "9f5d", "9a", "9c", "9f02", "5f2a", "9f1a", "9f03", "9f35", "9f1e", "9f09", "9f41", "8a", "5f34", "9f74", "5a", "57", "9f63"};
            return emvHandler.getTlvByTags(TAGS);
        }

        /**
         * getEmvScriptTLV
         * @return
         */
        @Override
        public String getEmvScriptTLV() {
            if (hasScript()) {
                log.debug("getEmvScriptTLV hasScript");
                final String[] TAGS = {"9f33", "95", "9f37", "9f1e", "9f10", "9f26", "9f36", "82", "df31", "9f1a", "9a", "df75"};
                return emvHandler.getTlvByTags(TAGS);
            }

            return null;
        }

        /**
         * getEmvOfflineTLV
         * @return
         */
        @Override
        public String getEmvOfflineTLV() {
            final String[] TAGS = {"9f26", "9f27", "9f10", "9f37", "9f36", "95", "9a", "9c", "9f02", "5f2a", "82", "9f1a", "9f03",
                    "9f33", "9f1e", "84", "9f09", "9f41", "9f34", "9f35", "8a", "9b", "9f06", "50", "9f74", /*"5a", "97"*/};
            return emvHandler.getTlvByTags(TAGS);
        }

        /**
         * EmvReversalTLV
         * @return
         */
        @Override
        public String getEmvReversalTLV() {
            final String[] TAGS = {"95", "9f1e", "9f10", "9f36", "df31"};
            return emvHandler.getTlvByTags(TAGS);
        }

        @Override
        public byte[] getEmvTlv(byte[] tag) {
            if (tag == null) {
                return null;
            }
            return emvHandler.getTlv(tag, EmvDataSourceEnum.FROM_KERNEL);
        }

        @Override
        public String getEmvTlv(String[] tags) {
            if (tags == null) {
                return null;
            }
            return emvHandler.getTlvByTags(tags);
        }


        private EmvOnlineResultEntity transformEmvOnlineResultEntity(AppEmvOnlineResultEntity appEmvOnlineResultEntity){
            EmvOnlineResultEntity emvOnlineResultEntity = new EmvOnlineResultEntity();

            if(appEmvOnlineResultEntity == null){
                return null;
            }

            emvOnlineResultEntity.setRejCode(appEmvOnlineResultEntity.getEmvResponseCode8a());
            emvOnlineResultEntity.setRecvField55(appEmvOnlineResultEntity.getRecvField55());
            emvOnlineResultEntity.setAuthCode(appEmvOnlineResultEntity.getAuthCode());

            return emvOnlineResultEntity;
        }

        @Override
        public void EmvResponseOnlineProcess(EmvOnlineResultState emvOnlineResultState, AppEmvOnlineResultEntity result) {
            log.debug("EmvResponseOnlineProcess + emvOnlineResultState" + emvOnlineResultState);
            if (emvOnlineResultState == EmvOnlineResultState.EMV_CONNECT_ERR_SWITCH_OFFLINE) {
                //sale online connect err, should try offline
                if (mEmvCore.getEmvTransType() == 0x00
                        && isContactICCTrans()
                        && isEmvFullFlow()) {
                    emvHandler.onSetOnlineProcResponse(SdkResult.Fail, null);
                } else {
                    //EmvTransFinish(EmvTransState.EMV_ERR_OTHER, BaseUtils.getApp().getString(R.string.emv_other_error));
                    emvHandler.onSetOnlineProcResponse(SdkResult.Success, null);//mike_zj
                }
            } else if (emvOnlineResultState == EmvOnlineResultState.EMV_SECOND_AUTH) {
                emvOnlineResultEntity = result;
                log.debug("EmvResponseOnlineProcess + isContactICCTrans" + isContactICCTrans());
                log.debug("EmvResponseOnlineProcess + isEmvFullFlow" + isEmvFullFlow());
                log.debug("EmvResponseOnlineProcess + isContactlessICCTrans" + isContactlessICCTrans());
                log.debug("EmvResponseOnlineProcess + isEmvQpassFlow" + isEmvQpassFlow());
                log.debug("EmvResponseOnlineProcess + isEmvMsdFlow" + isEmvMsdFlow());

                if ((isContactICCTrans() && isEmvFullFlow())
                        || (isContactlessICCTrans() && isEmvQpassFlow())
                        || isEmvMsdFlow()
                ) {
                    emvHandler.onSetOnlineProcResponse(SdkResult.Success, transformEmvOnlineResultEntity(result));
                } else {
                    EmvTransFinish(EmvTransState.EMV_ERR_OTHER, BaseUtils.getApp().getString(R.string.emv_other_error));
                }
            } else {
                // FIXME: 2018/1/26 SdkResult.Success meant's connect successfully
//                EmvTransFinish(EmvTransState.EMV_ERR_OTHER, BaseUtils.getApp().getString(R.string.emv_other_error));
                emvHandler.onSetOnlineProcResponse(SdkResult.Success, null);//mike_zj
            }
        }

        @Override
        public byte getEmvTransType() {
            byte type = 0;
            switch (emvCardControlEntity.getTransType()) {
                case SALE:
                    type = 0x00;
                    break;
                case VOID:
                    type = 0x17;
                    break;
                case REFUND:
                    type = 0x20;
                    break;
                case BALANCE:
                    type = 0x31;
                    break;
                default:
                    type = 0x00;
                    break;
            }
            return type;
        }

    };


    /**
     * if foreign card,
     *
     * @return
     */
    private boolean isForeignCard() {
        byte[] tlv = emvHandler.getTlv(new byte[]{(byte) 0x9f, 0x51}, EmvDataSourceEnum.FROM_KERNEL);
        if (tlv != null) {
            if (Arrays.equals(tlv, new byte[]{0x01, 0x56})) return false;
        }
        tlv = emvHandler.getTlv(new byte[]{(byte) 0xdf, 0x71}, EmvDataSourceEnum.FROM_KERNEL);
        if (tlv != null) {
            if (Arrays.equals(tlv, new byte[]{0x01, 0x56})) return false;
        }
        return true;
    }

    /**
     * card require pin
     *
     * @return
     */
    private boolean isNoPwdRequired() {
        byte[] tlv = emvHandler.getTlv(new byte[]{(byte) 0x9f, 0x6c}, EmvDataSourceEnum.FROM_KERNEL);
        return tlv != null && (tlv[0] & 0x80) == 0x80;
    }

    /**
     * MSD need pwd
     *
     * @return
     */
    private boolean isMsdPwdRequired() {
        byte[] tlv = emvHandler.getTlv(new byte[]{(byte) 0xdf, (byte) 0x81, (byte) 0x1e}, EmvDataSourceEnum.FROM_KERNEL);
        log.debug("isMsdPwdRequired df811e" + ConvertUtils.bytes2HexString(tlv, ""));
        return tlv != null && (tlv[0] & 0x20) == 0x20;
    }

    /**
     * if has Script
     *
     * @return
     */
    private boolean hasScript() {
        byte[] tlv = emvHandler.getTlv(new byte[]{(byte) 0xdf, (byte) 0x31}, EmvDataSourceEnum.FROM_KERNEL);
        if (tlv != null) {
            log.debug("getEmvScriptTLV tlv" + ByteUtils.byteArray2HexString(tlv));
        }

        return tlv != null && tlv.length > 0;
    }

    /**
     * contactless maybe not call confirm card number, so we need get card info from EMV kernel
     * 5A-PAN   , 57-TK2,  5F24--EXP,   5F34--CARDSN
     */
    private void setEmvCardInfo() {

        cardInfo.setCardType(emvTransData.getCardType());

        byte[] cardsn = emvHandler.getTlv(new byte[]{(byte) 0x5F, (byte) 0x34}, EmvDataSourceEnum.FROM_KERNEL);
        if (cardsn != null) {
            emvTransData.setCsn(ConvertUtils.bytes2HexString(cardsn, ""));
        }

        byte[] track2 = emvHandler.getTlv(new byte[]{(byte) 0x57}, EmvDataSourceEnum.FROM_KERNEL);
        if (track2 == null) {
            log.debug("getEmvCardInfo strTrack2 0x57 == null");
            track2 = emvHandler.getTlv(new byte[]{(byte) 0x9F, (byte) 0x6B}, EmvDataSourceEnum.FROM_KERNEL);
        }
        if (track2 != null) {
            log.debug("getEmvCardInfo strTrack2 =" + ByteUtils.byteArray2HexString(track2));
            String strTrack2 = ByteUtils.byteArray2HexString(track2);
            if (strTrack2.endsWith("F") || strTrack2.endsWith("f")) {
                strTrack2 = strTrack2.substring(0, strTrack2.length() - 1);
            }
            String formatTrack2 = strTrack2.toUpperCase().replace('=', 'D');
            cardInfo.setTk2(formatTrack2);
            emvTransData.setTk2(formatTrack2);

            int idx = formatTrack2.indexOf('D');
            String expDate = strTrack2.substring(idx + 1, idx + 5);
            cardInfo.setExpiredDate(expDate);
            emvTransData.setExpDate(expDate);

            String pan = strTrack2.substring(0, idx);
            cardInfo.setPan(pan);
            emvTransData.setPan(pan);
            log.debug("getEmvCardInfo strTrack2" + formatTrack2 + "expDate" + expDate + "pan" + pan);
        }

        // FIXME: 2018/11/30 Hassan remark: AMEX MSD need read from df812b00
        if(EmvContactlessType.CTLS_TYPE_AMEX == emvTransData.getEmvContactlessType()
                && emvTransData.isMsdFlow()){
            track2 = emvHandler.getTlv(new byte[]{(byte) 0xdF, (byte) 0x81, (byte) 0x2b, (byte) 0x00},
                    EmvDataSourceEnum.FROM_KERNEL);
            if(track2 != null){
                log.debug("getEmvCardInfo strTrack2 =" + ByteUtils.byteArray2HexString(track2));
                String strTrack2 = ByteUtils.byteArray2HexString(track2);
                if (strTrack2.endsWith("F") || strTrack2.endsWith("f")) {
                    strTrack2 = strTrack2.substring(0, strTrack2.length() - 1);
                }
                String formatTrack2 = strTrack2.toUpperCase().replace('=', 'D');
                cardInfo.setTk2(formatTrack2);
                emvTransData.setTk2(formatTrack2);
            }
        }
    }

    /**
     * if ICC trans
     *
     * @return
     */
    private boolean isICCTrans() {
        return (emvTransData.getCardType() == CardType.ICC)
                || (emvTransData.getCardType() == CardType.CTLS);
    }

    /**
     * contact
     *
     * @return
     */
    private boolean isContactICCTrans() {
        return emvTransData.getCardType() == CardType.ICC;
    }

    /**
     * Contactless
     *
     * @return
     */
    private boolean isContactlessICCTrans() {
        return emvTransData.getCardType() == CardType.CTLS;
    }


    /**
     * simple flow
     *
     * @return
     */
    private boolean isEmvSimpleFlow() {
        // FIXME: 2020/5/11
//        return emvCardControlEntity != null && EmvTransFlowEnum.SIMPLE.equals(emvCardControlEntity.getProcType())
//                && emvTransData.getCardType() == CardType.ICC;

        return emvCardControlEntity != null && EmvProcessFlowEnum.EMV_PROCESS_FLOW_READ_APPDATA.equals(emvCardControlEntity.getProcType());
    }

    /**
     * EmvFullFlow
     *
     * @return
     */
    private boolean isEmvFullFlow() {
        // FIXME: 2020/5/11
//        return emvCardControlEntity != null && EmvTransFlowEnum.FULL.equals(emvCardControlEntity.getProcType())
//                && emvTransData.getCardType() == CardType.ICC;

        return emvCardControlEntity != null && EmvProcessFlowEnum.EMV_PROCESS_FLOW_STANDARD.equals(emvCardControlEntity.getProcType())
                && emvTransData.getCardType() == CardType.ICC;
    }

    /**
     * qpass flow
     *
     * @return
     */
    private boolean isEmvQpassFlow() {
//        return emvCardControlEntity != null && EmvTransFlowEnum.QPASS.equals(emvCardControlEntity.getProcType())
//                && emvTransData.getCardType() == CardType.CTLS;

        return emvCardControlEntity != null && EmvProcessFlowEnum.EMV_PROCESS_FLOW_STANDARD.equals(emvCardControlEntity.getProcType())
                && emvTransData.getCardType() == CardType.CTLS;    }

    /**
     * MSD flow
     *
     * @return
     */
    private boolean isEmvMsdFlow() {
        return emvTransData != null && emvTransData.isMsdFlow() == true;
    }

    /**
     * do not require pin, and CDCUM has performed
     *
     * @return
     */
    private boolean isCdcvm() {
        byte[] tlv = emvHandler.getTlv(new byte[]{(byte) 0x9f, 0x6c}, EmvDataSourceEnum.FROM_KERNEL);
        return tlv != null && ((tlv[0] & 0x80) == 0 && (tlv[1] & 0x80) == 0x80);
    }

    /**
     * if cup credit card
     *
     * @return
     */
    protected boolean isCreditCard() {
        byte[] tlv = emvHandler.getTlv(new byte[]{(byte) 0x9f, 0x06}, EmvDataSourceEnum.FROM_KERNEL);
        return tlv != null && tlv.length >= 8
                && (Arrays.equals(Arrays.copyOf(tlv, 8), ByteUtils.hexString2ByteArray("A000000333010102"))
                || Arrays.equals(Arrays.copyOf(tlv, 8), ByteUtils.hexString2ByteArray("A000000333010103")));
    }

    /**
     * TransNeedPin
     *
     * @return
     */
    protected boolean isTransNeedPin() {
        return emvCardControlEntity.isNeedPin();
    }


    /**
     * getEmvContactlessType
     *
     * @return
     */
    protected EmvContactlessType getEmvContactlessType() {
        if (emvTransData.getEmvContactlessType() == null) {
            return EmvContactlessType.CTLS_TYPE_STANARD;
        }
        return emvTransData.getEmvContactlessType();
    }

    /**
     * setEmvContactlessType
     *
     * @param emvContactlessType
     */
    protected void setEmvContactlessType(EmvContactlessType emvContactlessType) {
        emvTransData.setEmvContactlessType(emvContactlessType);
    }


    protected void setEmv55FieldDOLType(EmvContactlessType emvContactlessType) {
        switch (emvContactlessType) {
            case CTLS_TYPE_PAYPASS:
                emvTransData.setEmv55FieldDOLType(Emv55FieldDOLType.DOL_PAYPASS);
                break;

            case CTLS_TYPE_PAYWAVE:
                emvTransData.setEmv55FieldDOLType(Emv55FieldDOLType.DOL_PAYWAVE);
                break;

            default:
                emvTransData.setEmv55FieldDOLType(Emv55FieldDOLType.DOL_STANDARD);
                break;
        }

    }

    /**
     * postMainThread
     *
     * @param runnable
     */
    protected void postMainThread(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            handler.post(runnable);
        }
    }

    /**
     * CheckresponseCode
     *
     * @param responseCode
     * @return
     */
    private boolean isCheckresponseCode(String responseCode) {
        return "00".equalsIgnoreCase(responseCode);
    }

    private void setEmvDebugLog(boolean bisDebug) {
        emvHandler.emvDebugLog(bisDebug);
    }


}
