package cn.nexgo.inbas.components.emv.fragment.selectapp;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.SimpleAdapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import butterknife.BindView;
import butterknife.ButterKnife;
import cn.nexgo.inbas.R;


/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Sandy(jiangsuyong@nexgo.cn)
 * Date            : 2017/12/27
 * Modify          : create file
 **************************************************************************************************/
public class SelectAppDialogFragment extends DialogFragment {

    public static final String APPLIST ="app_list";
    @BindView(R.id.lv_applist)
    ListView lv_AppList;

    public static <T extends Activity &OnSelectAppCallBack> SelectAppDialogFragment newInstance(List<String> appList ,T activity) {
        SelectAppDialogFragment dialog = new SelectAppDialogFragment();
        Bundle b = new Bundle();
        ArrayList<String> arrayList = new ArrayList<>();
        for(String name :appList){
            arrayList.add(name);
        }
        b.putStringArrayList(APPLIST,arrayList);
        dialog.setArguments(b);
        return dialog;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.emv_base_activity_dialog_app_list, null);
        ButterKnife.bind(this,view);
        //noinspection ConstantConditions
        getDialog().getWindow().requestFeature(Window.FEATURE_NO_TITLE);
        getDialog().getWindow().setBackgroundDrawable(new ColorDrawable(Color.WHITE));
        setCancelable(false);
        initView();
        return view;
    }

    public void initView() {
        initListener();
        Bundle b =getArguments();
        List<String> list = b.getStringArrayList(APPLIST);
        List<Map<String, String>> listItem = new ArrayList<>();
        //noinspection ConstantConditions
        for (int i = 0; i < list.size(); i++) {
            Map<String, String> map = new HashMap<>();
            map.put("appIdx", (i + 1) + "");
            map.put("appName", list.get(i));
            listItem.add(map);
        }
        SimpleAdapter adapter = new SimpleAdapter(getContext(),
                listItem,
                R.layout.emv_base_activity_app_list_item,
                new String[]{"appIdx", "appName"},
                new int[]{R.id.tv_appIndex, R.id.tv_appName});
        lv_AppList.setAdapter(adapter);
        lv_AppList.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                SelectAppDialogFragment.this.dismiss();
                mListener.select((int)id);
            }
        });

    }
    private void initListener(){
        OnSelectAppCallBack onSelectAppCallBack = (OnSelectAppCallBack) getActivity();
        mListener = onSelectAppCallBack.getSelectAppCallBack();
    }


    private SelectAppCallBack mListener;


    public interface OnSelectAppCallBack {
        SelectAppCallBack getSelectAppCallBack();
    }

}
