package cn.nexgo.inbas.components.emv;

import com.nexgo.oaf.apiv3.emv.EmvOnlineResultEntity;

import cn.nexgo.inbas.components.emv.bean.AppEmvOnlineResultEntity;
import cn.nexgo.inbas.components.emv.bean.EmvOnlineResultState;
import cn.nexgo.inbas.components.emv.bean.EmvTransData;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Sandy(jiangsuyong@nexgo.cn)
 * Date            : 2017/12/25
 * Modify          : create file
 **************************************************************************************************/
public interface IEmvCore {

    /**
     *
     * @return {@link EmvTransData}
     */
    EmvTransData getEmvTransData();

    /**
     * get all emv tag
     * @return
     */
    String getEmvRecordTLV();

    /**
     * get trans result EMV tags
     * @return
     */
    String getEmvTransResultTLV();

    /**
     * get Script EMV tags
     * @return
     */
    String getEmvScriptTLV();

    /**
     * get Offline EMV tags
     * @return
     */
    String getEmvOfflineTLV();

    /**
     * get ARQC EMV tags
     * @return
     */
    String getEmvARQCTLV();

    /**
     * get Reversal EMV tags
     * @return
     */
    String getEmvReversalTLV();

    /**
     * get one tag
     * @param tag
     * @return tag value
     */
    byte[] getEmvTlv(byte[] tag);

    /**
     * get EMV tags
     * @param tags
     * @return
     */
    String getEmvTlv(String[] tags);
    /**
     * EmvResponseOnlineProcess
     * @param emvOnlineResultState {@link EmvOnlineResultEntity }
     * @param result
     */
//    void EmvResponseOnlineProcess(EmvOnlineResultState emvOnlineResultState, EmvOnlineResultEntity result);

    void EmvResponseOnlineProcess(EmvOnlineResultState emvOnlineResultState, AppEmvOnlineResultEntity result);

    /**
     * getEmvTransType
     *
     */
    byte getEmvTransType();
}