package cn.nexgo.inbas.components.emv;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;

import com.nexgo.oaf.apiv3.emv.EmvProcessFlowEnum;
import com.nexgo.oaf.apiv3.emv.EmvTransFlowEnum;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

import cn.nexgo.inbas.common.Constans.CardType;
import cn.nexgo.inbas.common.base.BaseFragmentActivity;
import cn.nexgo.inbas.common.widget.CardNoConfirmDialog;
import cn.nexgo.inbas.common.widget.SeePhoneDialog;
import cn.nexgo.inbas.components.emv.bean.CardInfo;
import cn.nexgo.inbas.components.emv.bean.EmvCardControlEntity;
import cn.nexgo.inbas.components.emv.bean.EmvTransState;
import cn.nexgo.inbas.components.emv.contract.EmvBaseContract;
import cn.nexgo.inbas.components.emv.fragment.selectapp.SelectAppCallBack;
import cn.nexgo.inbas.components.emv.fragment.selectapp.SelectAppDialogFragment;
import cn.nexgo.inbas.components.emv.presenter.EmvBasePresenter;
import cn.nexgo.inbas.components.input.amount.InputAmountData;
import cn.nexgo.inbas.components.input.amount.internal.InputAmountCallBack;
import cn.nexgo.inbas.components.input.pin.InputPinData;
import cn.nexgo.inbas.components.input.pin.InputPinFragment;
import cn.nexgo.inbas.components.input.pin.internal.InputPinCallBack;
import cn.nexgo.inbas.components.input.readcard.ReadCardData;
import cn.nexgo.inbas.components.input.readcard.ReadCardFragment;
import cn.nexgo.inbas.components.input.readcard.internal.ReadCardCallBack;
import cn.nexgo.utils.AppLogUtils;
import cn.nexgo.utils.ToastUtils;



/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Sandy(jiangsuyong@nexgo.cn)
 * Date            : 2017/12/12
 * Modify          : Truth: create dialog interface
 **************************************************************************************************/
public abstract   class EmvBaseActivity extends BaseFragmentActivity implements EmvBaseContract.View, ReadCardFragment.OnReadCardCallBack, InputPinFragment.OnInputPinCallBack, SelectAppDialogFragment.OnSelectAppCallBack {
    private static Logger log = LoggerFactory.getLogger(EmvBaseActivity.class.getSimpleName());

    private EmvBaseContract.Presenter presenter;
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        presenter = new EmvBasePresenter<EmvBaseContract.View>(this);
    }
    /**
     * Read Card
     * @param emvCardControlEntity {@link EmvCardControlEntity}
     */
    public final void  startProcess(EmvCardControlEntity emvCardControlEntity, EmvBaseCallback callback) {
        log.debug("startProcess");
        presenter.startCardProcess(emvCardControlEntity,callback);
    }


    @Override
    public final void onReadCard(String title,ReadCardData readCardData, ReadCardCallBack cardCallBack) {
        log.debug("onReadCard");
        readCardCallBack = requireNonNull(cardCallBack);
        ReadCardFragment readCardFragment = ReadCardFragment.newInstance(title,readCardData, this);
        log.debug("onReadCard---ReadCardFragment");
        startFragment(readCardFragment,false);

    }


    private ReadCardCallBack readCardCallBack;
    @Override
    public final ReadCardCallBack getReadCardCallBack() {
        log.debug("getReadCardCallBack");
        return readCardCallBack;
    }



    @Override
    public final void onEmvRequestInputPin(String title,InputPinData inputPinData, InputPinCallBack callBack) {
        log.debug("onEmvRequestInputPin");
        inputPinCallBack =requireNonNull(callBack);
        InputPinFragment inputPinFragment = InputPinFragment.newInstance(title,inputPinData,this);
        startFragment(inputPinFragment,false);
    }
    private InputPinCallBack inputPinCallBack;
    @Override
    public final InputPinCallBack getInputPinCallBack() {
        log.debug("getInputPinCallBack");
        return inputPinCallBack;
    }
    @Override
    public final void onEmvRequestSelectApp(List<String> list, SelectAppCallBack callBack) {
        log.debug("onEmvRequestSelectApp");
        selectAppCallBack = requireNonNull(callBack);
        SelectAppDialogFragment selectAppDialogFragment =SelectAppDialogFragment.newInstance(list,this);

        selectAppDialogFragment.show(getSupportFragmentManager(),"selectAppDialogFragment");
    }
    SelectAppCallBack selectAppCallBack;
    @Override
    public SelectAppCallBack getSelectAppCallBack() {
        log.debug("getSelectAppCallBack");
        return selectAppCallBack;
    }


    private Handler handler = new Handler(Looper.getMainLooper());
    @Override
    public final void onEmvRequestConfirmCardNumber(final String pan, String transAmount, final CardNoConfirmDialog.OnClickListener confirmPanCallBack) {
        log.debug("onEmvRequestConfirmCardNumber");

        handler.post(new Runnable() {
            @Override
            public void run() {
                CardNoConfirmDialog cardNoConfirmDialog = new CardNoConfirmDialog(EmvBaseActivity.this);
                cardNoConfirmDialog.setCardNo(pan);
                cardNoConfirmDialog.show();
                cardNoConfirmDialog.setOnClickListener(confirmPanCallBack);
            }
        });
    }

    @Override
    public void onEmvRequestSeePhone(final SeePhoneDialog.OnClickListener seePhoneCallBack) {
        log.debug("onEmvRequestSeePhone");

        handler.post(new Runnable() {
            @Override
            public void run() {
                SeePhoneDialog seePhoneDialog = new SeePhoneDialog(EmvBaseActivity.this);
                seePhoneDialog.show();
                seePhoneDialog.setOnClickListener(seePhoneCallBack);
            }
        });
    }

    @Override
    public final void onEmvRequestAmount(String title,InputAmountData amountData, InputAmountCallBack callBack) {
        log.debug("onEmvRequestAmount");
    }

    @Override
    public void finishActivity(String msg) {
        log.debug("finish");
        if(msg != null){
            ToastUtils.showLong(msg);
        }

//        finish();
    }
    public static <T> T requireNonNull(T obj) {
        if (obj == null)
            throw new NullPointerException();
        return obj;
    }

    public interface  EmvBaseCallback{
        // FIXME: 2020/5/11 change new API
//        EmvTransFlowEnum getEmvTransFlowEnum(CardType cardType);
        EmvProcessFlowEnum getEmvTransFlowEnum(CardType cardType);
        void onProcessMagCard(CardInfo cardInfo) ;
        void onProcessManualCard(CardInfo cardInfo) ;
        void onEmvSimpleFlow(CardInfo cardInfo);
        void onEmvMsdFlow(CardInfo cardInfo);
        void onEmvQpbocOnlineProcess() ;
        void onEmvRequestOnlineProcess() ;
        void onFinish(EmvTransState transState, String description) ;
    }
    protected final IEmvCore getEmvCore(){
        return presenter.getEmvCore();
    }

    @Override
    public void showDialog(boolean show, String title, String msg) {
        super.processDialog(show, title, msg);
    }

    @Override
    protected void onDestroy() {
        log.debug("onDestroy");
        presenter.finishProcess();
        super.onDestroy();
    }

}
