package cn.nexgo.inbas.components.data.repository;

import org.greenrobot.greendao.DaoException;
import org.greenrobot.greendao.query.QueryBuilder;

import java.util.List;

import cn.nexgo.inbas.components.data.DataOpenHelper;
import cn.nexgo.inbas.components.data.bean.SetupEntity;
import cn.nexgo.inbas.components.data.daoGenerate.DaoSession;
import cn.nexgo.inbas.components.data.daoGenerate.SetupEntityDao;
import cn.nexgo.inbas.components.data.helper.SettingDbHelper;
import cn.nexgo.utils.AppLogUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * File Name     : SetupRepository.java
 * Usage         : 
 * Version       : 1
 * Author        : Brad
 * Date          : 2017/12/13 
 * Modification  : Created file

 **************************************************************************************************/
public class SetupRepository {
    private static String LOG_TAG = "SetupRepository";
    
    private SetupEntityDao recordEntityDao;
    private static volatile SetupRepository INSTANCE;
    private SetupRepository() {
        init();
    }
    public static SetupRepository getInstance(){
        if (INSTANCE == null){
            synchronized (SetupRepository.class){
                if (INSTANCE == null){
                    INSTANCE = new SetupRepository();
                }
            }
        }
        return INSTANCE;
    }


    /**
     *  Initialize Entity Dao
     */
    private void init(){
        DaoSession daoSession = SettingDbHelper.getInstance().getDaoSession();
        recordEntityDao = daoSession.getSetupEntityDao();
    }

    /**
     * Insert an Entity. If id is already existed, then update the existed record.
     * @param entity Entity
     * @return Success & fail
     */
    public boolean insert(SetupEntity entity) {
        if (recordEntityDao == null){
            init();
        }
        if (entity != null){
            recordEntityDao.insert(entity);
            return true;
        }
        return false;
    }

    /**
     * Delete an Entity
     * @param entity Entity
     * @return Success & fail
     */
    public boolean delete(SetupEntity entity) {
        if (recordEntityDao == null){
            init();
        }
        if (entity != null){
            try{
                recordEntityDao.delete(entity);
            }catch (DaoException e){
                AppLogUtils.error(true, LOG_TAG,   "Delete failed throw Dao exception");
                return false;
            }
            return true;
        }
        return false;
    }

    /**
     * Delete Last Entity
     * @return Success & fail
     */
    public boolean deleteLast() {
        if (recordEntityDao == null){
            init();
        }
        recordEntityDao.detachAll();
        QueryBuilder<SetupEntity> qb = recordEntityDao.queryBuilder().orderDesc(SetupEntityDao.Properties.Id).limit(1);    //invert list
        List<SetupEntity> gotRecords = qb.build().list();      //Get Object List
        if (gotRecords == null || gotRecords.isEmpty()) {
            return true;
        }
        delete(gotRecords.get(0));
        return true;
    }

    /**
     * Delete All Entities
     */
    public void deleteAll() {
        if (recordEntityDao == null){
            init();
        }
        recordEntityDao.deleteAll();
    }

    /**
     * Get Last Entity
     * @return Entity
     */
    public SetupEntity getLast() {
        if (recordEntityDao == null) {
            init();
        }
        recordEntityDao.detachAll();
        QueryBuilder<SetupEntity> qb = recordEntityDao.queryBuilder().orderDesc(SetupEntityDao.Properties.Id).limit(1);    //invert list
        return qb.build().unique();
    }

    /**
     * Update an Entity. If id is not existed, insert a new entity.
     * @param entity Entity
     * @return Success & fail
     */
    public boolean update(SetupEntity entity) {
        if (recordEntityDao == null){
            init();
        }
        if (entity != null){
            recordEntityDao.update(entity);
            return true;
        }
        return false;
    }

    /**
     * Get Record Nunbers
     * @return Record Numbers
     */
    public int getRecordNum() {
        if (recordEntityDao == null){
            init();
        }
        AppLogUtils.trace(DataOpenHelper.LOG_ENABLE, LOG_TAG,"getRecordNum = "+ (int) recordEntityDao.count());
        return (int)recordEntityDao.count();
    }

}
