package cn.nexgo.inbas.components.data.repository;

import org.greenrobot.greendao.DaoException;
import org.greenrobot.greendao.query.QueryBuilder;

import java.util.List;

import cn.nexgo.inbas.components.data.DataOpenHelper;
import cn.nexgo.inbas.components.data.bean.SettleInfoEntity;
import cn.nexgo.inbas.components.data.daoGenerate.SettleInfoEntityDao;
import cn.nexgo.inbas.components.data.helper.TransRecordDbHelper;
import cn.nexgo.utils.AppLogUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * File Name     : SettleInfoRepository.java
 * Usage         : 
 * Version       : 1
 * Author        : Brad
 * Date          : 2018/1/8 
 * Modification  : Created file

 **************************************************************************************************/
public class SettleInfoRepository {
    private static String LOG_TAG = "SettleInfoRepository";

    private SettleInfoEntityDao recordEntityDao;
    private SettleInfoRepository(){
        init();
    }
    private static volatile SettleInfoRepository INSTANCE;
    public static SettleInfoRepository getInstance(){
        if (INSTANCE == null){
            synchronized (SettleInfoRepository.class){
                if (INSTANCE == null){
                    INSTANCE = new SettleInfoRepository();
                }
            }
        }
        return INSTANCE;
    }

    /**
     *  Initialize Entity Dao
     */
    private void init(){
        this.recordEntityDao = TransRecordDbHelper.getInstance().getDaoSession().getSettleInfoEntityDao();
    }


    /**
     * Insert an Entity. If id is already existed, then update the existed record.
     * @param entity Entity
     * @return Success & fail
     */
    public boolean insert(SettleInfoEntity entity) {
        if (recordEntityDao == null){
            init();
        }
        if (entity != null){
            recordEntityDao.insert(entity);
            return true;
        }
        return false;
    }

    /**
     * Delete an Entity
     * @param entity Entity
     * @return Success & fail
     */
    public boolean delete(SettleInfoEntity entity) {
        if (recordEntityDao == null){
            init();
        }
        if (entity != null){
            try{
                recordEntityDao.delete(entity);
            }catch (DaoException e){
                AppLogUtils.error(true, LOG_TAG,  "Delete failed throw Dao exception");
                return false;
            }
            return true;
        }
        return false;
    }

    /**
     * Delete Last Entity
     * @return Success & fail
     */
    public boolean deleteLast() {
        if (recordEntityDao == null){
            init();
        }
        recordEntityDao.detachAll();
        QueryBuilder<SettleInfoEntity> qb = recordEntityDao.queryBuilder().orderDesc(SettleInfoEntityDao.Properties.Id).limit(1);    //invert list
        List<SettleInfoEntity> gotRecords = qb.build().list();      //Get Object List
        if (gotRecords == null || gotRecords.isEmpty()) {
            return true;
        }
        delete(gotRecords.get(0));
        return true;
    }

    public boolean deleteFirst(){
        if (recordEntityDao == null){
            init();
        }
        recordEntityDao.detachAll();
        QueryBuilder<SettleInfoEntity> qb = recordEntityDao.queryBuilder().orderAsc(SettleInfoEntityDao.Properties.Id).limit(1);    //invert list
        List<SettleInfoEntity> gotRecords = qb.build().list();      //Get Object List
        if (gotRecords == null || gotRecords.isEmpty()) {
            return true;
        }
        delete(gotRecords.get(0));
        return true;
    }

    /**
     * Delete All Entities
     */
    public void deleteAll() {
        if (recordEntityDao == null){
            init();
        }
        recordEntityDao.deleteAll();
    }

    /**
     * Get Last Entity
     * @return Entity
     */
    public SettleInfoEntity getLast() {
        if (recordEntityDao == null) {
            init();
        }
        recordEntityDao.detachAll();
        QueryBuilder<SettleInfoEntity> qb = recordEntityDao.queryBuilder().orderDesc(SettleInfoEntityDao.Properties.Id).limit(1);    //invert list
        return qb.build().unique();

    }

    /**
     * Get Fast Entity
     * @return
     */
    public SettleInfoEntity getFirst() {
        if (recordEntityDao == null) {
            init();
        }
        recordEntityDao.detachAll();
        QueryBuilder<SettleInfoEntity> qb = recordEntityDao.queryBuilder().orderAsc(SettleInfoEntityDao.Properties.Id).limit(1);    //invert list
        return qb.build().unique();

    }

    /**
     * Update an Entity. If id is not existed, insert a new entity.
     * @param entity Entity
     * @return Success & fail
     */
    public boolean update(SettleInfoEntity entity) {
        if (recordEntityDao == null){
            init();
        }
        if (entity != null){
            recordEntityDao.update(entity);
            return true;
        }
        return false;
    }

    /**
     * Get Record Numbers
     * @return Record Numbers
     */
    public int getRecordNum() {
        if (recordEntityDao == null){
            init();
        }
        recordEntityDao.detachAll();
        AppLogUtils.trace(DataOpenHelper.LOG_ENABLE, LOG_TAG, "getRecordNum = "+ (int) recordEntityDao.count());
        return (int)recordEntityDao.count();
    }
}
