package cn.nexgo.inbas.components.data.helper;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.os.Environment;

import org.greenrobot.greendao.database.Database;

import cn.nexgo.inbas.components.data.DataOpenHelper;
import cn.nexgo.inbas.components.data.daoGenerate.DaoMaster;
import cn.nexgo.inbas.components.data.daoGenerate.DaoSession;
import cn.nexgo.inbas.components.data.daoGenerate.SettleInfoEntityDao;
import cn.nexgo.inbas.components.data.daoGenerate.TransRecordEntityDao;
import cn.nexgo.inbas.components.data.repository.CustomContext;
import cn.nexgo.utils.AppLogUtils;
import cn.nexgo.utils.BaseUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * File Name     : TransRecordDbHelper.java
 * Usage         : 
 * Version       : 1
 * Author        : Brad
 * Date          : 2018/1/30 
 * Modification  : Created file

 **************************************************************************************************/

public class TransRecordDbHelper extends DaoMaster.OpenHelper {
    private static String LOG_TAG = "TransRecordDbHelper";
    private static volatile TransRecordDbHelper INSTANCE;
    private static boolean privateDB = false;     // FIXME: 2018/8/9 Hassan product use private path, for debug can use public path

    /**
     * Singleton
     * @return TransRecordDbHelper instance
     */
    public static TransRecordDbHelper getInstance() {
        if (INSTANCE == null) {
            synchronized (TransRecordDbHelper.class) {
                if (INSTANCE == null){
                    String dirPath = "";
                    String name = "";
                    if(privateDB){
                        dirPath = "/private/config/";
                        name = BaseUtils.getApp().getPackageName() + "_RECORD5.db";
                    }else{
                        dirPath = Environment.getExternalStorageDirectory().getPath() + "/" + BaseUtils.getApp().getPackageName() + "/";
                        name = "_RECORD5.db";
                    }

                    INSTANCE = new TransRecordDbHelper(new CustomContext(BaseUtils.getApp().getApplicationContext(), dirPath), name, null);
                }
            }
        }
        return INSTANCE;
    }

    private TransRecordDbHelper(Context context, String name) {
        super(context, name);
    }

    private TransRecordDbHelper(Context context, String name, SQLiteDatabase.CursorFactory factory) {
        super(context, name, factory);
    }

    private DaoSession daoSession;   //daoSession should be only created once

    /**
     * get DaoSession
     * @return DaoSession
     */
    public synchronized DaoSession getDaoSession() {
        if (this.daoSession == null){
            SQLiteDatabase db = TransRecordDbHelper.getInstance().getWritableDatabase();
            this.daoSession = new DaoMaster(db).newSession();
        }
        return this.daoSession;
    }

    /**
     * Data Base Upgrade
     * @param db
     * @param oldVersion
     * @param newVersion
     */
    @Override
    public void onUpgrade(Database db, int oldVersion, int newVersion) {
        AppLogUtils.debug(DataOpenHelper.LOG_ENABLE, LOG_TAG, "OnUpgrade oldver = {}, new ver = {}", oldVersion, newVersion);

        MigrationHelper.migrate(db, new MigrationHelper.ReCreateAllTableListener() {

                    @Override
                    public void onCreateAllTables(Database db, boolean ifNotExists) {
                        SettleInfoEntityDao.createTable(db, ifNotExists);
                        TransRecordEntityDao.createTable(db, ifNotExists);
                    }

                    @Override
                    public void onDropAllTables(Database db, boolean ifExists) {
                        SettleInfoEntityDao.dropTable(db, ifExists);
                        TransRecordEntityDao.dropTable(db, ifExists);
                    }
                }, TransRecordEntityDao.class,
                SettleInfoEntityDao.class);   //Add "xxxxDao.class" here if add new table
    }

    @Override
    public void onCreate(Database db) {
        SettleInfoEntityDao.createTable(db, false);
        TransRecordEntityDao.createTable(db, false);
    }




}
