package cn.nexgo.inbas.components.data.helper;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;

import org.greenrobot.greendao.database.Database;

import cn.nexgo.inbas.components.data.DataOpenHelper;
import cn.nexgo.inbas.components.data.daoGenerate.CardBinEntityDao;
import cn.nexgo.inbas.components.data.daoGenerate.DaoMaster;
import cn.nexgo.inbas.components.data.daoGenerate.DaoSession;
import cn.nexgo.inbas.components.data.daoGenerate.OperatorEntityDao;
import cn.nexgo.inbas.components.data.daoGenerate.SetupEntityDao;
import cn.nexgo.utils.AppLogUtils;
import cn.nexgo.utils.BaseUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * File Name     : SettingDbHelper.java
 * Usage         : 
 * Version       : 1
 * Author        : Brad
 * Date          : 2018/1/30 
 * Modification  : Created file

 **************************************************************************************************/

public class SettingDbHelper extends DaoMaster.OpenHelper {

    private static String LOG_TAG = "SettingDbHelper";
    private static final String INBAS_SETTING_DB = "INBAS_SETTING_TEST_4.db";
    private static volatile SettingDbHelper INSTANCE;

    /**
     * Singleton
     * @return SettingDbHelper instance
     */
    public static SettingDbHelper getInstance(){
        if (INSTANCE == null){
            synchronized (SettingDbHelper.class){
                if (INSTANCE == null){
                    INSTANCE = new SettingDbHelper(BaseUtils.getApp().getApplicationContext(), INBAS_SETTING_DB, null);
                }
            }
        }
        return INSTANCE;
    }


    private SettingDbHelper(Context context, String name) {
        super(context, name);
    }

    private SettingDbHelper(Context context, String name, SQLiteDatabase.CursorFactory factory) {
        super(context, name, factory);
    }

    private DaoSession daoSession;   //daoSession should be only created once
    /**
     * get DaoSession
     * @return DaoSession
     */

    public synchronized DaoSession getDaoSession() {
        if (this.daoSession == null){
            SQLiteDatabase db = SettingDbHelper.getInstance().getWritableDatabase();
            this.daoSession = new DaoMaster(db).newSession();
        }
        return this.daoSession;
    }

    /**
     * Data Base Upgrade
     * @param db
     * @param oldVersion
     * @param newVersion
     */
    @Override
    public void onUpgrade(Database db, int oldVersion, int newVersion) {
        AppLogUtils.warn(DataOpenHelper.LOG_ENABLE, LOG_TAG, "OnUpgrade oldver = {}, new ver = {}", oldVersion, newVersion);
//        DaoMaster.dropAllTables(db, true);
//        onCreate(db);

        MigrationHelper.migrate(db, new MigrationHelper.ReCreateAllTableListener() {

                    @Override
                    public void onCreateAllTables(Database db, boolean ifNotExists) {
                        OperatorEntityDao.createTable(db, ifNotExists);
                        SetupEntityDao.createTable(db, ifNotExists);
                        CardBinEntityDao.createTable(db, ifNotExists);
                    }

                    @Override
                    public void onDropAllTables(Database db, boolean ifExists) {
                        OperatorEntityDao.dropTable(db, ifExists);
                        SetupEntityDao.dropTable(db, ifExists);
                        CardBinEntityDao.dropTable(db, ifExists);
                    }
                }, SetupEntityDao.class,
                OperatorEntityDao.class,
                CardBinEntityDao.class);   //Add "xxxxDao.class" here if add new table
    }

    @Override
    public void onCreate(Database db) {
        OperatorEntityDao.createTable(db, false);
        SetupEntityDao.createTable(db, false);
        CardBinEntityDao.createTable(db, false);
    }


}
