package cn.nexgo.inbas.components.data.helper;

import android.content.Context;
import android.graphics.PixelFormat;
import android.os.Looper;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;

import cn.nexgo.inbas.R;
import cn.nexgo.inbas.common.GData;
import cn.nexgo.utils.AppLogUtils;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Hassan(huacong@xgd.com)
 * Date            : 2018/11/26
 * Modify          : create file
 **************************************************************************************************/
public class LedDriverHelper {
    private static Context mContext = null;
    private static boolean mPopupWindowShowed = false;
    private static View mView = null;
    private static WindowManager mWindowManager = null;
    private static Button mLed1;
    private static Button mLed2;
    private static Button mLed3;
    private static Button mLed4;
//    private static PopupWindow mPopupWindow;
    private static android.os.Handler handler = new android.os.Handler(Looper.getMainLooper());

    public static final int LED_INIT = 0;
    public static final int LED_IDEL = 1;
    public static final int LED_READCARD = 2;
    public static final int LED_READCARD_SUCCESS = 3;
    public static final int LED_READCARD_FAILED = 4;
    public static final int LED_CLOSE = 5;
    public static final int LED_HIDE = 6;
    public static final int LED_WAITING_CARD = 7;

    private static LedDriverHelper ledDriverHelper;

    private LedDriverHelper(){

    }

    public static LedDriverHelper getInstance(Context context){
        if(ledDriverHelper == null){
            mContext = context;

            ledDriverHelper = new LedDriverHelper();
        }
        return ledDriverHelper;
    }

    private void initLedPopupWindow(){
        if(mContext == null){
            AppLogUtils.debug(true, "LedDriverHelper", "showPopupWindowForLed " );
            return ;
        }

        handler.post(new Runnable() {
            @Override
            public void run() {
                if(mPopupWindowShowed && mView != null){
                    AppLogUtils.debug(true, "LedDriverHelper", "already popup " );
                    return;
                }

                initView();
            }
        });

    }

    public void controlContactlessLed(int actionCode){
        if(!GData.getInstance().getSetupEntity().getEmvContactlessLedEnable()){
            AppLogUtils.debug(true, "LedDriverHelper", "getEmvContactlessLedEnable == false");
            return ;
        }

        if(mContext == null){
            AppLogUtils.debug(true, "LedDriverHelper", "controlContactlessLed == null");
            return ;
        }

        switch (actionCode){
            case LED_INIT:
                initLedPopupWindow();
                break;

            case LED_IDEL:
                ledIdel();
                break;

            case LED_WAITING_CARD:
                ledWaitingCard();
                break;

            case LED_READCARD:
                ledIdentifyContactlessCard();
                break;

            case LED_READCARD_SUCCESS:
                ledReadCardSuccess();
                break;

            case LED_READCARD_FAILED:
                ledReadCardFailed();
                break;

            case LED_CLOSE:
                ledclose();
                break;

            case LED_HIDE:
                ledHide();
                break;
        }
    }

    private void ledIdel(){
        mLed1.setBackgroundResource(R.drawable.green);
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                ledclose();
            }
        }, 200);
    }

    private void ledWaitingCard(){
        handler.post(new Runnable() {
            @Override
            public void run() {
                mLed1.setBackgroundResource(R.drawable.green);
            }
        });

    }

    private void ledIdentifyContactlessCard(){
        handler.post(new Runnable() {
            @Override
            public void run() {
                mLed1.setBackgroundResource(R.drawable.green);
            }
        });
    }

    private void ledReadCardSuccess(){
        Observable.create(new ObservableOnSubscribe<Integer>() {
            @Override
            public void subscribe(ObservableEmitter<Integer> e) throws Exception {
                e.onNext(1);
                try {
                    Thread.sleep(100);
                } catch (InterruptedException i) {
                    i.printStackTrace();
                }
                e.onNext(2);
                try {
                    Thread.sleep(100);
                } catch (InterruptedException i) {
                    i.printStackTrace();
                }
                e.onNext(3);
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException i) {
                    i.printStackTrace();
                }
                e.onComplete();
            }
        })
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Observer<Integer>() {
                    private Disposable mD = null;

                    @Override
                    public void onSubscribe(Disposable d) {
                        mD = d;
                    }

                    @Override
                    public void onNext(Integer value) {
                        switch (value){
                            case 1:
                                mView.setVisibility(View.VISIBLE);
                                mLed1.setBackgroundResource(R.drawable.green);
                                mLed2.setBackgroundResource(R.drawable.green);
                                break;

                            case 2:
                                mLed3.setBackgroundResource(R.drawable.green);
                                break;

                            case 3:
                                mLed4.setBackgroundResource(R.drawable.green);
                                break;
                        }
                    }

                    @Override
                    public void onError(Throwable e) {
                        ledclose();
                        ledHide();
                    }

                    @Override
                    public void onComplete() {
                        ledclose();
                        ledHide();
                    }
                });

    }

//    private int times = 0;
//
//    private void test3(){
//        Observable.interval(100, TimeUnit.MILLISECONDS)
//                .map()
//                .takeUntil(new Func1<Long, Boolean>() {
//                    @Override
//                    public Boolean call(Long aLong) {
//                        return aLong == 1;
//                    }
//                })
//                .subscribeOn(Schedulers.newThread())
//                .observeOn(AndroidSchedulers.mainThread())
//                .subscribe(new Subscriber<Long>() {
//                    @Override
//                    public void onCompleted() {
//                        //TODO finished
//                    }
//                    @Override
//                    public void onError(Throwable e) {
//                    }
//                    @Override
//                    public void onNext(int progress) {
//                        //TODO update progress
//                    }
//                });
//    }


    private void ledReadCardFailed(){
        if(mView != null){
            handler.post(new Runnable() {
                @Override
                public void run() {
                    mView.setVisibility(View.VISIBLE);
                    mLed1.setBackgroundResource(R.drawable.grep);
                    mLed2.setBackgroundResource(R.drawable.grep);
                    mLed3.setBackgroundResource(R.drawable.grep);
                    mLed4.setBackgroundResource(R.drawable.grep);
                }
            });

        }
        ledHide();
    }

    private void ledclose(){
        handler.post(new Runnable() {
            @Override
            public void run() {
                if(mView != null){
                    mView.setVisibility(View.VISIBLE);
                    mLed1.setBackgroundResource(R.drawable.grep);
                    mLed2.setBackgroundResource(R.drawable.grep);
                    mLed3.setBackgroundResource(R.drawable.grep);
                    mLed4.setBackgroundResource(R.drawable.grep);
                }
            }
        });
    }

    private void ledHide(){
        AppLogUtils.debug(true, "LedDriverHelper", "mPopupWindowShowed == " + mPopupWindowShowed);

        handler.post(new Runnable() {
            @Override
            public void run() {
                if (mPopupWindowShowed && null != mView) {
                    mWindowManager.removeView(mView);
                    mPopupWindowShowed = false;
                }
            }
        });

    }


    private static WindowManager.LayoutParams getLayoutParams(){
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        layoutParams.type = WindowManager.LayoutParams.TYPE_SYSTEM_ALERT;
        layoutParams.flags = WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE;
        layoutParams.format = PixelFormat.TRANSLUCENT;
        layoutParams.gravity = Gravity.TOP;
        layoutParams.y = 65;
        layoutParams.width = WindowManager.LayoutParams.WRAP_CONTENT;
        layoutParams.height = WindowManager.LayoutParams.WRAP_CONTENT;
//        layoutParams.token = ((Activity)mContext).getWindow().getDecorView().getWindowToken(); // 必须要
        return layoutParams;
    }

    private static void initView(){
        AppLogUtils.debug(true, "LedDriverHelper", "mContext == " + mContext);

        mWindowManager = (WindowManager)mContext.getSystemService(Context.WINDOW_SERVICE);

        mView = LayoutInflater.from(mContext).inflate(R.layout.contactlessled, null);

        mWindowManager.addView(mView, getLayoutParams());

//        mView.setVisibility(View.VISIBLE);
        mLed1 = mView.findViewById(R.id.bt_led1);
        mLed2 = mView.findViewById(R.id.bt_led2);
        mLed3 = mView.findViewById(R.id.bt_led3);
        mLed4 = mView.findViewById(R.id.bt_led4);

        mPopupWindowShowed = true;
    }


//    private void hideLedPopupWindow(){
//        if (mPopupWindowShowed && null != mView) {
//            mWindowManager.removeView(mView);
//            mPopupWindowShowed = false;
//        }
//    }

//    private void ledIdel(){
//        mLed1
//    }

}
