package cn.nexgo.inbas.components.data.helper;

import android.content.Context;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Hassan(huacong@nexgo.cn)
 * Date            : 2018/4/24
 * Modify          : create file
 **************************************************************************************************/
public class FileUtilsHelper {

    public void assetsFileToDesDir(Context context, String resFilename, String fileName) throws IOException
    {
        File file = new File(fileName);
        if (file.exists()) {
            return;
        }

        InputStream myInput;
        OutputStream myOutput = new FileOutputStream(fileName);
        myInput = context.getAssets().open(resFilename);
        byte[] buffer = new byte[5000];
        int length = myInput.read(buffer);
        while(length > 0)
        {
            myOutput.write(buffer, 0, length);
            length = myInput.read(buffer);
        }

        myOutput.flush();
        myInput.close();
        myOutput.close();
    }


    public void CreateDir(String filepath){
        File file=new File(filepath);
        if(!file.exists()&&!file.isDirectory())
        {
            file.mkdirs();

        }

    }

    public void copyFile(String oldPath, String newPath) {
        try {
            int bytesum = 0;
            int byteread = 0;
            File oldfile = new File(oldPath);

            if (oldfile.exists()) {
                InputStream inStream = new FileInputStream(oldPath);
                FileOutputStream fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                int length;
                while ( (byteread = inStream.read(buffer)) != -1) {
                    bytesum += byteread;
                    //System.out.println(bytesum);
                    fs.write(buffer, 0, byteread);
                }
                inStream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();

        }

    }
}
