package cn.nexgo.inbas.components.data.daoGenerate;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import cn.nexgo.inbas.components.data.bean.TransRecordEntity;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "TRANS_DATA_RECORD".
*/
public class TransRecordEntityDao extends AbstractDao<TransRecordEntity, Long> {

    public static final String TABLENAME = "TRANS_DATA_RECORD";

    /**
     * Properties of entity TransRecordEntity.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property TransID = new Property(1, int.class, "transID", false, "TRANS_ID");
        public final static Property CardType = new Property(2, int.class, "cardType", false, "CARD_Type");
        public final static Property CardCtlsFlowType = new Property(3, int.class, "cardCtlsFlowType", false, "CARD_CTLS_FLOW_TYPE");
        public final static Property CardFallback = new Property(4, boolean.class, "cardFallback", false, "CARD_FALLBACK");
        public final static Property CardNo = new Property(5, String.class, "cardNo", false, "CARD_NO");
        public final static Property CardHolderName = new Property(6, String.class, "cardHolderName", false, "CARD_HOLDER_NAME");
        public final static Property CardExpDate = new Property(7, String.class, "cardExpDate", false, "CARD_EXP_DATE");
        public final static Property EmvAC = new Property(8, String.class, "emvAC", false, "EMV_AC");
        public final static Property EmvCID = new Property(9, String.class, "emvCID", false, "EMV_CID");
        public final static Property EmvIAD = new Property(10, String.class, "emvIAD", false, "EMV_IAD");
        public final static Property EmvUN = new Property(11, String.class, "emvUN", false, "EMV_UN");
        public final static Property EmvATC = new Property(12, String.class, "emvATC", false, "EMV_ATC");
        public final static Property EmvTVR = new Property(13, String.class, "emvTVR", false, "EMV_TVR");
        public final static Property EmvTransDate = new Property(14, String.class, "emvTransDate", false, "EMV_TRANS_DATE");
        public final static Property EmvTransType = new Property(15, String.class, "emvTransType", false, "EMV_TRANS_TYPE");
        public final static Property EmvTransAmount = new Property(16, String.class, "emvTransAmount", false, "EMV_TRANS_AMOUNT");
        public final static Property EmvCurrencyCode = new Property(17, String.class, "emvCurrencyCode", false, "EMV_CURRENCY_CODE");
        public final static Property EmvCountryCode = new Property(18, String.class, "emvCountryCode", false, "EMV_COUNTRY_CODE");
        public final static Property EmvAIP = new Property(19, String.class, "emvAIP", false, "EMV_AIP");
        public final static Property EmvTermCap = new Property(20, String.class, "emvTermCap", false, "EMV_TERM_CAP");
        public final static Property EmvCVMResult = new Property(21, String.class, "emvCVMResult", false, "EMV_CVM_RESULT");
        public final static Property EmvAmountOther = new Property(22, String.class, "emvAmountOther", false, "EMV_AMOUNT_OTHER");
        public final static Property EmvAID = new Property(23, String.class, "emvAID", false, "EMV_AID");
        public final static Property EmvAppVer = new Property(24, String.class, "emvAppVer", false, "EMV_APP_VERSION");
        public final static Property EmvTermAppVer = new Property(25, String.class, "emvTermAppVer", false, "EMV_TERM_APP_VER");
        public final static Property EmvTermType = new Property(26, String.class, "emvTermType", false, "EMV_TERM_TYPE");
        public final static Property EmvIFDSN = new Property(27, String.class, "emvIFDSN", false, "EMV_IFD_SN");
        public final static Property EmvCategoryCode = new Property(28, String.class, "emvCategoryCode", false, "EMV_CATEGORY_CODE");
        public final static Property EmvTransSeqCnt = new Property(29, String.class, "emvTransSeqCnt", false, "EMV_TRANS_SEQ_CNT");
        public final static Property EmvFFI = new Property(30, String.class, "emvFFI", false, "EMV_FFI");
        public final static Property EmvIDN = new Property(31, String.class, "emvIDN", false, "EMV_IDN");
        public final static Property EmvAOSA = new Property(32, String.class, "emvAOSA", false, "EMV_AOSA");
        public final static Property EmvTSI = new Property(33, String.class, "emvTSI", false, "EMV_TSI");
        public final static Property EmvPanSN = new Property(34, String.class, "emvPanSN", false, "EMV_PAN_SN");
        public final static Property EmvAppLabel = new Property(35, String.class, "emvAppLabel", false, "EMV_APP_LABEL");
        public final static Property EmvAppPreferName = new Property(36, String.class, "emvAppPreferName", false, "EMV_APP_PREFER_NAME");
        public final static Property EmvIssAuthData = new Property(37, String.class, "emvIssAuthData", false, "EMV_AUTH_DATA");
        public final static Property EmvScriptResult = new Property(38, String.class, "emvScriptResult", false, "EMV_SCRIPT_DATA");
        public final static Property EmvCardId = new Property(39, String.class, "emvCardId", false, "EMV_CARD_ID");
        public final static Property MsgCashierNO = new Property(40, String.class, "msgCashierNO", false, "MSG_CASHIER_NO");
        public final static Property MsgBitmap = new Property(41, String.class, "msgBitmap", false, "MSG_BITMAP");
        public final static Property MsgProcCode = new Property(42, String.class, "msgProcCode", false, "MSG_PROC_CODE");
        public final static Property MsgAmount = new Property(43, String.class, "msgAmount", false, "MSG_AMOUNT");
        public final static Property MsgDateTime = new Property(44, String.class, "msgDateTime", false, "MSG_DATE_TIME");
        public final static Property MsgTraceNO = new Property(45, String.class, "msgTraceNO", false, "MSG_TRACE_NO");
        public final static Property MsgEntryMode = new Property(46, String.class, "msgEntryMode", false, "ENTRY_MODE");
        public final static Property MsgConditionCode = new Property(47, String.class, "msgConditionCode", false, "MSG_CONDITION_CODE");
        public final static Property MsgPinCapCode = new Property(48, String.class, "msgPinCapCode", false, "MSG_PIN_CAP_CODE");
        public final static Property MsgTermID = new Property(49, String.class, "msgTermID", false, "MSG_TERMINAL_ID");
        public final static Property MsgMerchID = new Property(50, String.class, "msgMerchID", false, "MSG_MERCHANT_ID");
        public final static Property MsgTipAmount = new Property(51, String.class, "msgTipAmount", false, "MSG_TIP_AMOUNT");
        public final static Property MsgCurrencyCode = new Property(52, String.class, "msgCurrencyCode", false, "MSG_CURRENCY_CODE");
        public final static Property MsgFuncCode = new Property(53, String.class, "msgFuncCode", false, "MSG_FUNC_CODE");
        public final static Property MsgBatchNO = new Property(54, String.class, "msgBatchNO", false, "MSG_BATCH_NO");
        public final static Property MsgOrigBatchNO = new Property(55, String.class, "msgOrigBatchNO", false, "MSG_ORG_BATCH_NO");
        public final static Property MsgOrigTraceNO = new Property(56, String.class, "msgOrigTraceNO", false, "MSG_ORG_TRACE_NO");
        public final static Property MsgOrigDate = new Property(57, String.class, "msgOrigDate", false, "MSG_ORG_DATE");
        public final static Property MsgCashbackAmount = new Property(58, String.class, "msgCashbackAmount", false, "MSG_CASHBACK_AMOUNT");
        public final static Property MsgTransTime = new Property(59, String.class, "msgTransTime", false, "MSG_TRANS_TIME");
        public final static Property MsgTransDate = new Property(60, String.class, "msgTransDate", false, "MSG_TRANS_DATE");
        public final static Property MsgSettlementDate = new Property(61, String.class, "msgSettlementDate", false, "MSG_SETTLEMENT_DATE");
        public final static Property MsgAcqID = new Property(62, String.class, "msgAcqID", false, "MSG_ACQ_ID");
        public final static Property MsgRefNO = new Property(63, String.class, "msgRefNO", false, "MSG_REF_NO");
        public final static Property MsgAuthCode = new Property(64, String.class, "msgAuthCode", false, "MSG_AUTH_CODE");
        public final static Property MsgRespCode = new Property(65, String.class, "msgRespCode", false, "MSG_RESP_CODE");
        public final static Property MsgIssuerCode = new Property(66, String.class, "msgIssuerCode", false, "MSG_ISSUER_CODE");
        public final static Property MsgAcquirerCode = new Property(67, String.class, "msgAcquirerCode", false, "MSG_ACQ_CODE");
        public final static Property MsgBalance = new Property(68, String.class, "msgBalance", false, "MSG_BALANCE");
        public final static Property MsgInterOrgCode = new Property(69, String.class, "msgInterOrgCode", false, "MSG_INTER_ORG_CODE");
        public final static Property MsgIssuerInfo = new Property(70, String.class, "msgIssuerInfo", false, "MSG_ISSUER_INFO");
        public final static Property MsgCUPInfo = new Property(71, String.class, "msgCUPInfo", false, "MSG_CUP_INFO");
        public final static Property MsgAcqInfo = new Property(72, String.class, "msgAcqInfo", false, "MSG_ACQ_INFO");
        public final static Property MsgTermReserved = new Property(73, String.class, "msgTermReserved", false, "MSG_TERM_RESERVED");
        public final static Property StatusIccFailTrans = new Property(74, boolean.class, "statusIccFailTrans", false, "STATUS_IS_FAILED_TRANS");
        public final static Property StatusOffline = new Property(75, boolean.class, "statusOffline", false, "STATUS_IS_OFFLINE");
        public final static Property StatusVoided = new Property(76, boolean.class, "statusVoided", false, "STATUS_IS_VOIDED");
        public final static Property StatusAdjusted = new Property(77, boolean.class, "statusAdjusted", false, "STATUS_IS_ADJUSTED");
        public final static Property StatusNeedPrint = new Property(78, boolean.class, "statusNeedPrint", false, "STATUS_IS_NEED_REPRINT");
        public final static Property StatusNeedReversal = new Property(79, boolean.class, "statusNeedReversal", false, "STATUS_IS_NEED_REVERSAL");
        public final static Property StatusNeedScript = new Property(80, boolean.class, "statusNeedScript", false, "STATUS_IS_NEED_SCRIPT");
        public final static Property StatusArpcErr = new Property(81, boolean.class, "statusArpcErr", false, "STATUS_IS_APRC_ERR");
        public final static Property StatusReversalReason = new Property(82, int.class, "statusReversalReason", false, "STATUS_REVERSAL_REASON");
        public final static Property StatusAdjustedTimes = new Property(83, int.class, "statusAdjustedTimes", false, "STATUS_ADJUSTED_TIMES");
        public final static Property StatusOffineUpload = new Property(84, int.class, "statusOffineUpload", false, "STATUS_OFFLINE_UPLOAD");
        public final static Property StatusBatchUpload = new Property(85, int.class, "statusBatchUpload", false, "STATUS_BATCH_UPLOAD");
        public final static Property Rfu1 = new Property(86, String.class, "rfu1", false, "RFU_1");
        public final static Property Rfu2 = new Property(87, String.class, "rfu2", false, "RFU_2");
        public final static Property Rfu3 = new Property(88, String.class, "rfu3", false, "RFU_3");
    }


    public TransRecordEntityDao(DaoConfig config) {
        super(config);
    }
    
    public TransRecordEntityDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"TRANS_DATA_RECORD\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "\"TRANS_ID\" INTEGER NOT NULL ," + // 1: transID
                "\"CARD_Type\" INTEGER NOT NULL ," + // 2: cardType
                "\"CARD_CTLS_FLOW_TYPE\" INTEGER NOT NULL ," + // 3: cardCtlsFlowType
                "\"CARD_FALLBACK\" INTEGER NOT NULL ," + // 4: cardFallback
                "\"CARD_NO\" TEXT," + // 5: cardNo
                "\"CARD_HOLDER_NAME\" TEXT," + // 6: cardHolderName
                "\"CARD_EXP_DATE\" TEXT," + // 7: cardExpDate
                "\"EMV_AC\" TEXT," + // 8: emvAC
                "\"EMV_CID\" TEXT," + // 9: emvCID
                "\"EMV_IAD\" TEXT," + // 10: emvIAD
                "\"EMV_UN\" TEXT," + // 11: emvUN
                "\"EMV_ATC\" TEXT," + // 12: emvATC
                "\"EMV_TVR\" TEXT," + // 13: emvTVR
                "\"EMV_TRANS_DATE\" TEXT," + // 14: emvTransDate
                "\"EMV_TRANS_TYPE\" TEXT," + // 15: emvTransType
                "\"EMV_TRANS_AMOUNT\" TEXT," + // 16: emvTransAmount
                "\"EMV_CURRENCY_CODE\" TEXT," + // 17: emvCurrencyCode
                "\"EMV_COUNTRY_CODE\" TEXT," + // 18: emvCountryCode
                "\"EMV_AIP\" TEXT," + // 19: emvAIP
                "\"EMV_TERM_CAP\" TEXT," + // 20: emvTermCap
                "\"EMV_CVM_RESULT\" TEXT," + // 21: emvCVMResult
                "\"EMV_AMOUNT_OTHER\" TEXT," + // 22: emvAmountOther
                "\"EMV_AID\" TEXT," + // 23: emvAID
                "\"EMV_APP_VERSION\" TEXT," + // 24: emvAppVer
                "\"EMV_TERM_APP_VER\" TEXT," + // 25: emvTermAppVer
                "\"EMV_TERM_TYPE\" TEXT," + // 26: emvTermType
                "\"EMV_IFD_SN\" TEXT," + // 27: emvIFDSN
                "\"EMV_CATEGORY_CODE\" TEXT," + // 28: emvCategoryCode
                "\"EMV_TRANS_SEQ_CNT\" TEXT," + // 29: emvTransSeqCnt
                "\"EMV_FFI\" TEXT," + // 30: emvFFI
                "\"EMV_IDN\" TEXT," + // 31: emvIDN
                "\"EMV_AOSA\" TEXT," + // 32: emvAOSA
                "\"EMV_TSI\" TEXT," + // 33: emvTSI
                "\"EMV_PAN_SN\" TEXT," + // 34: emvPanSN
                "\"EMV_APP_LABEL\" TEXT," + // 35: emvAppLabel
                "\"EMV_APP_PREFER_NAME\" TEXT," + // 36: emvAppPreferName
                "\"EMV_AUTH_DATA\" TEXT," + // 37: emvIssAuthData
                "\"EMV_SCRIPT_DATA\" TEXT," + // 38: emvScriptResult
                "\"EMV_CARD_ID\" TEXT," + // 39: emvCardId
                "\"MSG_CASHIER_NO\" TEXT," + // 40: msgCashierNO
                "\"MSG_BITMAP\" TEXT," + // 41: msgBitmap
                "\"MSG_PROC_CODE\" TEXT," + // 42: msgProcCode
                "\"MSG_AMOUNT\" TEXT," + // 43: msgAmount
                "\"MSG_DATE_TIME\" TEXT," + // 44: msgDateTime
                "\"MSG_TRACE_NO\" TEXT," + // 45: msgTraceNO
                "\"ENTRY_MODE\" TEXT," + // 46: msgEntryMode
                "\"MSG_CONDITION_CODE\" TEXT," + // 47: msgConditionCode
                "\"MSG_PIN_CAP_CODE\" TEXT," + // 48: msgPinCapCode
                "\"MSG_TERMINAL_ID\" TEXT," + // 49: msgTermID
                "\"MSG_MERCHANT_ID\" TEXT," + // 50: msgMerchID
                "\"MSG_TIP_AMOUNT\" TEXT," + // 51: msgTipAmount
                "\"MSG_CURRENCY_CODE\" TEXT," + // 52: msgCurrencyCode
                "\"MSG_FUNC_CODE\" TEXT," + // 53: msgFuncCode
                "\"MSG_BATCH_NO\" TEXT," + // 54: msgBatchNO
                "\"MSG_ORG_BATCH_NO\" TEXT," + // 55: msgOrigBatchNO
                "\"MSG_ORG_TRACE_NO\" TEXT," + // 56: msgOrigTraceNO
                "\"MSG_ORG_DATE\" TEXT," + // 57: msgOrigDate
                "\"MSG_CASHBACK_AMOUNT\" TEXT," + // 58: msgCashbackAmount
                "\"MSG_TRANS_TIME\" TEXT," + // 59: msgTransTime
                "\"MSG_TRANS_DATE\" TEXT," + // 60: msgTransDate
                "\"MSG_SETTLEMENT_DATE\" TEXT," + // 61: msgSettlementDate
                "\"MSG_ACQ_ID\" TEXT," + // 62: msgAcqID
                "\"MSG_REF_NO\" TEXT," + // 63: msgRefNO
                "\"MSG_AUTH_CODE\" TEXT," + // 64: msgAuthCode
                "\"MSG_RESP_CODE\" TEXT," + // 65: msgRespCode
                "\"MSG_ISSUER_CODE\" TEXT," + // 66: msgIssuerCode
                "\"MSG_ACQ_CODE\" TEXT," + // 67: msgAcquirerCode
                "\"MSG_BALANCE\" TEXT," + // 68: msgBalance
                "\"MSG_INTER_ORG_CODE\" TEXT," + // 69: msgInterOrgCode
                "\"MSG_ISSUER_INFO\" TEXT," + // 70: msgIssuerInfo
                "\"MSG_CUP_INFO\" TEXT," + // 71: msgCUPInfo
                "\"MSG_ACQ_INFO\" TEXT," + // 72: msgAcqInfo
                "\"MSG_TERM_RESERVED\" TEXT," + // 73: msgTermReserved
                "\"STATUS_IS_FAILED_TRANS\" INTEGER NOT NULL ," + // 74: statusIccFailTrans
                "\"STATUS_IS_OFFLINE\" INTEGER NOT NULL ," + // 75: statusOffline
                "\"STATUS_IS_VOIDED\" INTEGER NOT NULL ," + // 76: statusVoided
                "\"STATUS_IS_ADJUSTED\" INTEGER NOT NULL ," + // 77: statusAdjusted
                "\"STATUS_IS_NEED_REPRINT\" INTEGER NOT NULL ," + // 78: statusNeedPrint
                "\"STATUS_IS_NEED_REVERSAL\" INTEGER NOT NULL ," + // 79: statusNeedReversal
                "\"STATUS_IS_NEED_SCRIPT\" INTEGER NOT NULL ," + // 80: statusNeedScript
                "\"STATUS_IS_APRC_ERR\" INTEGER NOT NULL ," + // 81: statusArpcErr
                "\"STATUS_REVERSAL_REASON\" INTEGER NOT NULL ," + // 82: statusReversalReason
                "\"STATUS_ADJUSTED_TIMES\" INTEGER NOT NULL ," + // 83: statusAdjustedTimes
                "\"STATUS_OFFLINE_UPLOAD\" INTEGER NOT NULL ," + // 84: statusOffineUpload
                "\"STATUS_BATCH_UPLOAD\" INTEGER NOT NULL ," + // 85: statusBatchUpload
                "\"RFU_1\" TEXT," + // 86: rfu1
                "\"RFU_2\" TEXT," + // 87: rfu2
                "\"RFU_3\" TEXT);"); // 88: rfu3
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"TRANS_DATA_RECORD\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, TransRecordEntity entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getTransID());
        stmt.bindLong(3, entity.getCardType());
        stmt.bindLong(4, entity.getCardCtlsFlowType());
        stmt.bindLong(5, entity.getCardFallback() ? 1L: 0L);
 
        String cardNo = entity.getCardNo();
        if (cardNo != null) {
            stmt.bindString(6, cardNo);
        }
 
        String cardHolderName = entity.getCardHolderName();
        if (cardHolderName != null) {
            stmt.bindString(7, cardHolderName);
        }
 
        String cardExpDate = entity.getCardExpDate();
        if (cardExpDate != null) {
            stmt.bindString(8, cardExpDate);
        }
 
        String emvAC = entity.getEmvAC();
        if (emvAC != null) {
            stmt.bindString(9, emvAC);
        }
 
        String emvCID = entity.getEmvCID();
        if (emvCID != null) {
            stmt.bindString(10, emvCID);
        }
 
        String emvIAD = entity.getEmvIAD();
        if (emvIAD != null) {
            stmt.bindString(11, emvIAD);
        }
 
        String emvUN = entity.getEmvUN();
        if (emvUN != null) {
            stmt.bindString(12, emvUN);
        }
 
        String emvATC = entity.getEmvATC();
        if (emvATC != null) {
            stmt.bindString(13, emvATC);
        }
 
        String emvTVR = entity.getEmvTVR();
        if (emvTVR != null) {
            stmt.bindString(14, emvTVR);
        }
 
        String emvTransDate = entity.getEmvTransDate();
        if (emvTransDate != null) {
            stmt.bindString(15, emvTransDate);
        }
 
        String emvTransType = entity.getEmvTransType();
        if (emvTransType != null) {
            stmt.bindString(16, emvTransType);
        }
 
        String emvTransAmount = entity.getEmvTransAmount();
        if (emvTransAmount != null) {
            stmt.bindString(17, emvTransAmount);
        }
 
        String emvCurrencyCode = entity.getEmvCurrencyCode();
        if (emvCurrencyCode != null) {
            stmt.bindString(18, emvCurrencyCode);
        }
 
        String emvCountryCode = entity.getEmvCountryCode();
        if (emvCountryCode != null) {
            stmt.bindString(19, emvCountryCode);
        }
 
        String emvAIP = entity.getEmvAIP();
        if (emvAIP != null) {
            stmt.bindString(20, emvAIP);
        }
 
        String emvTermCap = entity.getEmvTermCap();
        if (emvTermCap != null) {
            stmt.bindString(21, emvTermCap);
        }
 
        String emvCVMResult = entity.getEmvCVMResult();
        if (emvCVMResult != null) {
            stmt.bindString(22, emvCVMResult);
        }
 
        String emvAmountOther = entity.getEmvAmountOther();
        if (emvAmountOther != null) {
            stmt.bindString(23, emvAmountOther);
        }
 
        String emvAID = entity.getEmvAID();
        if (emvAID != null) {
            stmt.bindString(24, emvAID);
        }
 
        String emvAppVer = entity.getEmvAppVer();
        if (emvAppVer != null) {
            stmt.bindString(25, emvAppVer);
        }
 
        String emvTermAppVer = entity.getEmvTermAppVer();
        if (emvTermAppVer != null) {
            stmt.bindString(26, emvTermAppVer);
        }
 
        String emvTermType = entity.getEmvTermType();
        if (emvTermType != null) {
            stmt.bindString(27, emvTermType);
        }
 
        String emvIFDSN = entity.getEmvIFDSN();
        if (emvIFDSN != null) {
            stmt.bindString(28, emvIFDSN);
        }
 
        String emvCategoryCode = entity.getEmvCategoryCode();
        if (emvCategoryCode != null) {
            stmt.bindString(29, emvCategoryCode);
        }
 
        String emvTransSeqCnt = entity.getEmvTransSeqCnt();
        if (emvTransSeqCnt != null) {
            stmt.bindString(30, emvTransSeqCnt);
        }
 
        String emvFFI = entity.getEmvFFI();
        if (emvFFI != null) {
            stmt.bindString(31, emvFFI);
        }
 
        String emvIDN = entity.getEmvIDN();
        if (emvIDN != null) {
            stmt.bindString(32, emvIDN);
        }
 
        String emvAOSA = entity.getEmvAOSA();
        if (emvAOSA != null) {
            stmt.bindString(33, emvAOSA);
        }
 
        String emvTSI = entity.getEmvTSI();
        if (emvTSI != null) {
            stmt.bindString(34, emvTSI);
        }
 
        String emvPanSN = entity.getEmvPanSN();
        if (emvPanSN != null) {
            stmt.bindString(35, emvPanSN);
        }
 
        String emvAppLabel = entity.getEmvAppLabel();
        if (emvAppLabel != null) {
            stmt.bindString(36, emvAppLabel);
        }
 
        String emvAppPreferName = entity.getEmvAppPreferName();
        if (emvAppPreferName != null) {
            stmt.bindString(37, emvAppPreferName);
        }
 
        String emvIssAuthData = entity.getEmvIssAuthData();
        if (emvIssAuthData != null) {
            stmt.bindString(38, emvIssAuthData);
        }
 
        String emvScriptResult = entity.getEmvScriptResult();
        if (emvScriptResult != null) {
            stmt.bindString(39, emvScriptResult);
        }
 
        String emvCardId = entity.getEmvCardId();
        if (emvCardId != null) {
            stmt.bindString(40, emvCardId);
        }
 
        String msgCashierNO = entity.getMsgCashierNO();
        if (msgCashierNO != null) {
            stmt.bindString(41, msgCashierNO);
        }
 
        String msgBitmap = entity.getMsgBitmap();
        if (msgBitmap != null) {
            stmt.bindString(42, msgBitmap);
        }
 
        String msgProcCode = entity.getMsgProcCode();
        if (msgProcCode != null) {
            stmt.bindString(43, msgProcCode);
        }
 
        String msgAmount = entity.getMsgAmount();
        if (msgAmount != null) {
            stmt.bindString(44, msgAmount);
        }
 
        String msgDateTime = entity.getMsgDateTime();
        if (msgDateTime != null) {
            stmt.bindString(45, msgDateTime);
        }
 
        String msgTraceNO = entity.getMsgTraceNO();
        if (msgTraceNO != null) {
            stmt.bindString(46, msgTraceNO);
        }
 
        String msgEntryMode = entity.getMsgEntryMode();
        if (msgEntryMode != null) {
            stmt.bindString(47, msgEntryMode);
        }
 
        String msgConditionCode = entity.getMsgConditionCode();
        if (msgConditionCode != null) {
            stmt.bindString(48, msgConditionCode);
        }
 
        String msgPinCapCode = entity.getMsgPinCapCode();
        if (msgPinCapCode != null) {
            stmt.bindString(49, msgPinCapCode);
        }
 
        String msgTermID = entity.getMsgTermID();
        if (msgTermID != null) {
            stmt.bindString(50, msgTermID);
        }
 
        String msgMerchID = entity.getMsgMerchID();
        if (msgMerchID != null) {
            stmt.bindString(51, msgMerchID);
        }
 
        String msgTipAmount = entity.getMsgTipAmount();
        if (msgTipAmount != null) {
            stmt.bindString(52, msgTipAmount);
        }
 
        String msgCurrencyCode = entity.getMsgCurrencyCode();
        if (msgCurrencyCode != null) {
            stmt.bindString(53, msgCurrencyCode);
        }
 
        String msgFuncCode = entity.getMsgFuncCode();
        if (msgFuncCode != null) {
            stmt.bindString(54, msgFuncCode);
        }
 
        String msgBatchNO = entity.getMsgBatchNO();
        if (msgBatchNO != null) {
            stmt.bindString(55, msgBatchNO);
        }
 
        String msgOrigBatchNO = entity.getMsgOrigBatchNO();
        if (msgOrigBatchNO != null) {
            stmt.bindString(56, msgOrigBatchNO);
        }
 
        String msgOrigTraceNO = entity.getMsgOrigTraceNO();
        if (msgOrigTraceNO != null) {
            stmt.bindString(57, msgOrigTraceNO);
        }
 
        String msgOrigDate = entity.getMsgOrigDate();
        if (msgOrigDate != null) {
            stmt.bindString(58, msgOrigDate);
        }
 
        String msgCashbackAmount = entity.getMsgCashbackAmount();
        if (msgCashbackAmount != null) {
            stmt.bindString(59, msgCashbackAmount);
        }
 
        String msgTransTime = entity.getMsgTransTime();
        if (msgTransTime != null) {
            stmt.bindString(60, msgTransTime);
        }
 
        String msgTransDate = entity.getMsgTransDate();
        if (msgTransDate != null) {
            stmt.bindString(61, msgTransDate);
        }
 
        String msgSettlementDate = entity.getMsgSettlementDate();
        if (msgSettlementDate != null) {
            stmt.bindString(62, msgSettlementDate);
        }
 
        String msgAcqID = entity.getMsgAcqID();
        if (msgAcqID != null) {
            stmt.bindString(63, msgAcqID);
        }
 
        String msgRefNO = entity.getMsgRefNO();
        if (msgRefNO != null) {
            stmt.bindString(64, msgRefNO);
        }
 
        String msgAuthCode = entity.getMsgAuthCode();
        if (msgAuthCode != null) {
            stmt.bindString(65, msgAuthCode);
        }
 
        String msgRespCode = entity.getMsgRespCode();
        if (msgRespCode != null) {
            stmt.bindString(66, msgRespCode);
        }
 
        String msgIssuerCode = entity.getMsgIssuerCode();
        if (msgIssuerCode != null) {
            stmt.bindString(67, msgIssuerCode);
        }
 
        String msgAcquirerCode = entity.getMsgAcquirerCode();
        if (msgAcquirerCode != null) {
            stmt.bindString(68, msgAcquirerCode);
        }
 
        String msgBalance = entity.getMsgBalance();
        if (msgBalance != null) {
            stmt.bindString(69, msgBalance);
        }
 
        String msgInterOrgCode = entity.getMsgInterOrgCode();
        if (msgInterOrgCode != null) {
            stmt.bindString(70, msgInterOrgCode);
        }
 
        String msgIssuerInfo = entity.getMsgIssuerInfo();
        if (msgIssuerInfo != null) {
            stmt.bindString(71, msgIssuerInfo);
        }
 
        String msgCUPInfo = entity.getMsgCUPInfo();
        if (msgCUPInfo != null) {
            stmt.bindString(72, msgCUPInfo);
        }
 
        String msgAcqInfo = entity.getMsgAcqInfo();
        if (msgAcqInfo != null) {
            stmt.bindString(73, msgAcqInfo);
        }
 
        String msgTermReserved = entity.getMsgTermReserved();
        if (msgTermReserved != null) {
            stmt.bindString(74, msgTermReserved);
        }
        stmt.bindLong(75, entity.getStatusIccFailTrans() ? 1L: 0L);
        stmt.bindLong(76, entity.getStatusOffline() ? 1L: 0L);
        stmt.bindLong(77, entity.getStatusVoided() ? 1L: 0L);
        stmt.bindLong(78, entity.getStatusAdjusted() ? 1L: 0L);
        stmt.bindLong(79, entity.getStatusNeedPrint() ? 1L: 0L);
        stmt.bindLong(80, entity.getStatusNeedReversal() ? 1L: 0L);
        stmt.bindLong(81, entity.getStatusNeedScript() ? 1L: 0L);
        stmt.bindLong(82, entity.getStatusArpcErr() ? 1L: 0L);
        stmt.bindLong(83, entity.getStatusReversalReason());
        stmt.bindLong(84, entity.getStatusAdjustedTimes());
        stmt.bindLong(85, entity.getStatusOffineUpload());
        stmt.bindLong(86, entity.getStatusBatchUpload());
 
        String rfu1 = entity.getRfu1();
        if (rfu1 != null) {
            stmt.bindString(87, rfu1);
        }
 
        String rfu2 = entity.getRfu2();
        if (rfu2 != null) {
            stmt.bindString(88, rfu2);
        }
 
        String rfu3 = entity.getRfu3();
        if (rfu3 != null) {
            stmt.bindString(89, rfu3);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, TransRecordEntity entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
        stmt.bindLong(2, entity.getTransID());
        stmt.bindLong(3, entity.getCardType());
        stmt.bindLong(4, entity.getCardCtlsFlowType());
        stmt.bindLong(5, entity.getCardFallback() ? 1L: 0L);
 
        String cardNo = entity.getCardNo();
        if (cardNo != null) {
            stmt.bindString(6, cardNo);
        }
 
        String cardHolderName = entity.getCardHolderName();
        if (cardHolderName != null) {
            stmt.bindString(7, cardHolderName);
        }
 
        String cardExpDate = entity.getCardExpDate();
        if (cardExpDate != null) {
            stmt.bindString(8, cardExpDate);
        }
 
        String emvAC = entity.getEmvAC();
        if (emvAC != null) {
            stmt.bindString(9, emvAC);
        }
 
        String emvCID = entity.getEmvCID();
        if (emvCID != null) {
            stmt.bindString(10, emvCID);
        }
 
        String emvIAD = entity.getEmvIAD();
        if (emvIAD != null) {
            stmt.bindString(11, emvIAD);
        }
 
        String emvUN = entity.getEmvUN();
        if (emvUN != null) {
            stmt.bindString(12, emvUN);
        }
 
        String emvATC = entity.getEmvATC();
        if (emvATC != null) {
            stmt.bindString(13, emvATC);
        }
 
        String emvTVR = entity.getEmvTVR();
        if (emvTVR != null) {
            stmt.bindString(14, emvTVR);
        }
 
        String emvTransDate = entity.getEmvTransDate();
        if (emvTransDate != null) {
            stmt.bindString(15, emvTransDate);
        }
 
        String emvTransType = entity.getEmvTransType();
        if (emvTransType != null) {
            stmt.bindString(16, emvTransType);
        }
 
        String emvTransAmount = entity.getEmvTransAmount();
        if (emvTransAmount != null) {
            stmt.bindString(17, emvTransAmount);
        }
 
        String emvCurrencyCode = entity.getEmvCurrencyCode();
        if (emvCurrencyCode != null) {
            stmt.bindString(18, emvCurrencyCode);
        }
 
        String emvCountryCode = entity.getEmvCountryCode();
        if (emvCountryCode != null) {
            stmt.bindString(19, emvCountryCode);
        }
 
        String emvAIP = entity.getEmvAIP();
        if (emvAIP != null) {
            stmt.bindString(20, emvAIP);
        }
 
        String emvTermCap = entity.getEmvTermCap();
        if (emvTermCap != null) {
            stmt.bindString(21, emvTermCap);
        }
 
        String emvCVMResult = entity.getEmvCVMResult();
        if (emvCVMResult != null) {
            stmt.bindString(22, emvCVMResult);
        }
 
        String emvAmountOther = entity.getEmvAmountOther();
        if (emvAmountOther != null) {
            stmt.bindString(23, emvAmountOther);
        }
 
        String emvAID = entity.getEmvAID();
        if (emvAID != null) {
            stmt.bindString(24, emvAID);
        }
 
        String emvAppVer = entity.getEmvAppVer();
        if (emvAppVer != null) {
            stmt.bindString(25, emvAppVer);
        }
 
        String emvTermAppVer = entity.getEmvTermAppVer();
        if (emvTermAppVer != null) {
            stmt.bindString(26, emvTermAppVer);
        }
 
        String emvTermType = entity.getEmvTermType();
        if (emvTermType != null) {
            stmt.bindString(27, emvTermType);
        }
 
        String emvIFDSN = entity.getEmvIFDSN();
        if (emvIFDSN != null) {
            stmt.bindString(28, emvIFDSN);
        }
 
        String emvCategoryCode = entity.getEmvCategoryCode();
        if (emvCategoryCode != null) {
            stmt.bindString(29, emvCategoryCode);
        }
 
        String emvTransSeqCnt = entity.getEmvTransSeqCnt();
        if (emvTransSeqCnt != null) {
            stmt.bindString(30, emvTransSeqCnt);
        }
 
        String emvFFI = entity.getEmvFFI();
        if (emvFFI != null) {
            stmt.bindString(31, emvFFI);
        }
 
        String emvIDN = entity.getEmvIDN();
        if (emvIDN != null) {
            stmt.bindString(32, emvIDN);
        }
 
        String emvAOSA = entity.getEmvAOSA();
        if (emvAOSA != null) {
            stmt.bindString(33, emvAOSA);
        }
 
        String emvTSI = entity.getEmvTSI();
        if (emvTSI != null) {
            stmt.bindString(34, emvTSI);
        }
 
        String emvPanSN = entity.getEmvPanSN();
        if (emvPanSN != null) {
            stmt.bindString(35, emvPanSN);
        }
 
        String emvAppLabel = entity.getEmvAppLabel();
        if (emvAppLabel != null) {
            stmt.bindString(36, emvAppLabel);
        }
 
        String emvAppPreferName = entity.getEmvAppPreferName();
        if (emvAppPreferName != null) {
            stmt.bindString(37, emvAppPreferName);
        }
 
        String emvIssAuthData = entity.getEmvIssAuthData();
        if (emvIssAuthData != null) {
            stmt.bindString(38, emvIssAuthData);
        }
 
        String emvScriptResult = entity.getEmvScriptResult();
        if (emvScriptResult != null) {
            stmt.bindString(39, emvScriptResult);
        }
 
        String emvCardId = entity.getEmvCardId();
        if (emvCardId != null) {
            stmt.bindString(40, emvCardId);
        }
 
        String msgCashierNO = entity.getMsgCashierNO();
        if (msgCashierNO != null) {
            stmt.bindString(41, msgCashierNO);
        }
 
        String msgBitmap = entity.getMsgBitmap();
        if (msgBitmap != null) {
            stmt.bindString(42, msgBitmap);
        }
 
        String msgProcCode = entity.getMsgProcCode();
        if (msgProcCode != null) {
            stmt.bindString(43, msgProcCode);
        }
 
        String msgAmount = entity.getMsgAmount();
        if (msgAmount != null) {
            stmt.bindString(44, msgAmount);
        }
 
        String msgDateTime = entity.getMsgDateTime();
        if (msgDateTime != null) {
            stmt.bindString(45, msgDateTime);
        }
 
        String msgTraceNO = entity.getMsgTraceNO();
        if (msgTraceNO != null) {
            stmt.bindString(46, msgTraceNO);
        }
 
        String msgEntryMode = entity.getMsgEntryMode();
        if (msgEntryMode != null) {
            stmt.bindString(47, msgEntryMode);
        }
 
        String msgConditionCode = entity.getMsgConditionCode();
        if (msgConditionCode != null) {
            stmt.bindString(48, msgConditionCode);
        }
 
        String msgPinCapCode = entity.getMsgPinCapCode();
        if (msgPinCapCode != null) {
            stmt.bindString(49, msgPinCapCode);
        }
 
        String msgTermID = entity.getMsgTermID();
        if (msgTermID != null) {
            stmt.bindString(50, msgTermID);
        }
 
        String msgMerchID = entity.getMsgMerchID();
        if (msgMerchID != null) {
            stmt.bindString(51, msgMerchID);
        }
 
        String msgTipAmount = entity.getMsgTipAmount();
        if (msgTipAmount != null) {
            stmt.bindString(52, msgTipAmount);
        }
 
        String msgCurrencyCode = entity.getMsgCurrencyCode();
        if (msgCurrencyCode != null) {
            stmt.bindString(53, msgCurrencyCode);
        }
 
        String msgFuncCode = entity.getMsgFuncCode();
        if (msgFuncCode != null) {
            stmt.bindString(54, msgFuncCode);
        }
 
        String msgBatchNO = entity.getMsgBatchNO();
        if (msgBatchNO != null) {
            stmt.bindString(55, msgBatchNO);
        }
 
        String msgOrigBatchNO = entity.getMsgOrigBatchNO();
        if (msgOrigBatchNO != null) {
            stmt.bindString(56, msgOrigBatchNO);
        }
 
        String msgOrigTraceNO = entity.getMsgOrigTraceNO();
        if (msgOrigTraceNO != null) {
            stmt.bindString(57, msgOrigTraceNO);
        }
 
        String msgOrigDate = entity.getMsgOrigDate();
        if (msgOrigDate != null) {
            stmt.bindString(58, msgOrigDate);
        }
 
        String msgCashbackAmount = entity.getMsgCashbackAmount();
        if (msgCashbackAmount != null) {
            stmt.bindString(59, msgCashbackAmount);
        }
 
        String msgTransTime = entity.getMsgTransTime();
        if (msgTransTime != null) {
            stmt.bindString(60, msgTransTime);
        }
 
        String msgTransDate = entity.getMsgTransDate();
        if (msgTransDate != null) {
            stmt.bindString(61, msgTransDate);
        }
 
        String msgSettlementDate = entity.getMsgSettlementDate();
        if (msgSettlementDate != null) {
            stmt.bindString(62, msgSettlementDate);
        }
 
        String msgAcqID = entity.getMsgAcqID();
        if (msgAcqID != null) {
            stmt.bindString(63, msgAcqID);
        }
 
        String msgRefNO = entity.getMsgRefNO();
        if (msgRefNO != null) {
            stmt.bindString(64, msgRefNO);
        }
 
        String msgAuthCode = entity.getMsgAuthCode();
        if (msgAuthCode != null) {
            stmt.bindString(65, msgAuthCode);
        }
 
        String msgRespCode = entity.getMsgRespCode();
        if (msgRespCode != null) {
            stmt.bindString(66, msgRespCode);
        }
 
        String msgIssuerCode = entity.getMsgIssuerCode();
        if (msgIssuerCode != null) {
            stmt.bindString(67, msgIssuerCode);
        }
 
        String msgAcquirerCode = entity.getMsgAcquirerCode();
        if (msgAcquirerCode != null) {
            stmt.bindString(68, msgAcquirerCode);
        }
 
        String msgBalance = entity.getMsgBalance();
        if (msgBalance != null) {
            stmt.bindString(69, msgBalance);
        }
 
        String msgInterOrgCode = entity.getMsgInterOrgCode();
        if (msgInterOrgCode != null) {
            stmt.bindString(70, msgInterOrgCode);
        }
 
        String msgIssuerInfo = entity.getMsgIssuerInfo();
        if (msgIssuerInfo != null) {
            stmt.bindString(71, msgIssuerInfo);
        }
 
        String msgCUPInfo = entity.getMsgCUPInfo();
        if (msgCUPInfo != null) {
            stmt.bindString(72, msgCUPInfo);
        }
 
        String msgAcqInfo = entity.getMsgAcqInfo();
        if (msgAcqInfo != null) {
            stmt.bindString(73, msgAcqInfo);
        }
 
        String msgTermReserved = entity.getMsgTermReserved();
        if (msgTermReserved != null) {
            stmt.bindString(74, msgTermReserved);
        }
        stmt.bindLong(75, entity.getStatusIccFailTrans() ? 1L: 0L);
        stmt.bindLong(76, entity.getStatusOffline() ? 1L: 0L);
        stmt.bindLong(77, entity.getStatusVoided() ? 1L: 0L);
        stmt.bindLong(78, entity.getStatusAdjusted() ? 1L: 0L);
        stmt.bindLong(79, entity.getStatusNeedPrint() ? 1L: 0L);
        stmt.bindLong(80, entity.getStatusNeedReversal() ? 1L: 0L);
        stmt.bindLong(81, entity.getStatusNeedScript() ? 1L: 0L);
        stmt.bindLong(82, entity.getStatusArpcErr() ? 1L: 0L);
        stmt.bindLong(83, entity.getStatusReversalReason());
        stmt.bindLong(84, entity.getStatusAdjustedTimes());
        stmt.bindLong(85, entity.getStatusOffineUpload());
        stmt.bindLong(86, entity.getStatusBatchUpload());
 
        String rfu1 = entity.getRfu1();
        if (rfu1 != null) {
            stmt.bindString(87, rfu1);
        }
 
        String rfu2 = entity.getRfu2();
        if (rfu2 != null) {
            stmt.bindString(88, rfu2);
        }
 
        String rfu3 = entity.getRfu3();
        if (rfu3 != null) {
            stmt.bindString(89, rfu3);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public TransRecordEntity readEntity(Cursor cursor, int offset) {
        TransRecordEntity entity = new TransRecordEntity( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.getInt(offset + 1), // transID
            cursor.getInt(offset + 2), // cardType
            cursor.getInt(offset + 3), // cardCtlsFlowType
            cursor.getShort(offset + 4) != 0, // cardFallback
            cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5), // cardNo
            cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6), // cardHolderName
            cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7), // cardExpDate
            cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8), // emvAC
            cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9), // emvCID
            cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10), // emvIAD
            cursor.isNull(offset + 11) ? null : cursor.getString(offset + 11), // emvUN
            cursor.isNull(offset + 12) ? null : cursor.getString(offset + 12), // emvATC
            cursor.isNull(offset + 13) ? null : cursor.getString(offset + 13), // emvTVR
            cursor.isNull(offset + 14) ? null : cursor.getString(offset + 14), // emvTransDate
            cursor.isNull(offset + 15) ? null : cursor.getString(offset + 15), // emvTransType
            cursor.isNull(offset + 16) ? null : cursor.getString(offset + 16), // emvTransAmount
            cursor.isNull(offset + 17) ? null : cursor.getString(offset + 17), // emvCurrencyCode
            cursor.isNull(offset + 18) ? null : cursor.getString(offset + 18), // emvCountryCode
            cursor.isNull(offset + 19) ? null : cursor.getString(offset + 19), // emvAIP
            cursor.isNull(offset + 20) ? null : cursor.getString(offset + 20), // emvTermCap
            cursor.isNull(offset + 21) ? null : cursor.getString(offset + 21), // emvCVMResult
            cursor.isNull(offset + 22) ? null : cursor.getString(offset + 22), // emvAmountOther
            cursor.isNull(offset + 23) ? null : cursor.getString(offset + 23), // emvAID
            cursor.isNull(offset + 24) ? null : cursor.getString(offset + 24), // emvAppVer
            cursor.isNull(offset + 25) ? null : cursor.getString(offset + 25), // emvTermAppVer
            cursor.isNull(offset + 26) ? null : cursor.getString(offset + 26), // emvTermType
            cursor.isNull(offset + 27) ? null : cursor.getString(offset + 27), // emvIFDSN
            cursor.isNull(offset + 28) ? null : cursor.getString(offset + 28), // emvCategoryCode
            cursor.isNull(offset + 29) ? null : cursor.getString(offset + 29), // emvTransSeqCnt
            cursor.isNull(offset + 30) ? null : cursor.getString(offset + 30), // emvFFI
            cursor.isNull(offset + 31) ? null : cursor.getString(offset + 31), // emvIDN
            cursor.isNull(offset + 32) ? null : cursor.getString(offset + 32), // emvAOSA
            cursor.isNull(offset + 33) ? null : cursor.getString(offset + 33), // emvTSI
            cursor.isNull(offset + 34) ? null : cursor.getString(offset + 34), // emvPanSN
            cursor.isNull(offset + 35) ? null : cursor.getString(offset + 35), // emvAppLabel
            cursor.isNull(offset + 36) ? null : cursor.getString(offset + 36), // emvAppPreferName
            cursor.isNull(offset + 37) ? null : cursor.getString(offset + 37), // emvIssAuthData
            cursor.isNull(offset + 38) ? null : cursor.getString(offset + 38), // emvScriptResult
            cursor.isNull(offset + 39) ? null : cursor.getString(offset + 39), // emvCardId
            cursor.isNull(offset + 40) ? null : cursor.getString(offset + 40), // msgCashierNO
            cursor.isNull(offset + 41) ? null : cursor.getString(offset + 41), // msgBitmap
            cursor.isNull(offset + 42) ? null : cursor.getString(offset + 42), // msgProcCode
            cursor.isNull(offset + 43) ? null : cursor.getString(offset + 43), // msgAmount
            cursor.isNull(offset + 44) ? null : cursor.getString(offset + 44), // msgDateTime
            cursor.isNull(offset + 45) ? null : cursor.getString(offset + 45), // msgTraceNO
            cursor.isNull(offset + 46) ? null : cursor.getString(offset + 46), // msgEntryMode
            cursor.isNull(offset + 47) ? null : cursor.getString(offset + 47), // msgConditionCode
            cursor.isNull(offset + 48) ? null : cursor.getString(offset + 48), // msgPinCapCode
            cursor.isNull(offset + 49) ? null : cursor.getString(offset + 49), // msgTermID
            cursor.isNull(offset + 50) ? null : cursor.getString(offset + 50), // msgMerchID
            cursor.isNull(offset + 51) ? null : cursor.getString(offset + 51), // msgTipAmount
            cursor.isNull(offset + 52) ? null : cursor.getString(offset + 52), // msgCurrencyCode
            cursor.isNull(offset + 53) ? null : cursor.getString(offset + 53), // msgFuncCode
            cursor.isNull(offset + 54) ? null : cursor.getString(offset + 54), // msgBatchNO
            cursor.isNull(offset + 55) ? null : cursor.getString(offset + 55), // msgOrigBatchNO
            cursor.isNull(offset + 56) ? null : cursor.getString(offset + 56), // msgOrigTraceNO
            cursor.isNull(offset + 57) ? null : cursor.getString(offset + 57), // msgOrigDate
            cursor.isNull(offset + 58) ? null : cursor.getString(offset + 58), // msgCashbackAmount
            cursor.isNull(offset + 59) ? null : cursor.getString(offset + 59), // msgTransTime
            cursor.isNull(offset + 60) ? null : cursor.getString(offset + 60), // msgTransDate
            cursor.isNull(offset + 61) ? null : cursor.getString(offset + 61), // msgSettlementDate
            cursor.isNull(offset + 62) ? null : cursor.getString(offset + 62), // msgAcqID
            cursor.isNull(offset + 63) ? null : cursor.getString(offset + 63), // msgRefNO
            cursor.isNull(offset + 64) ? null : cursor.getString(offset + 64), // msgAuthCode
            cursor.isNull(offset + 65) ? null : cursor.getString(offset + 65), // msgRespCode
            cursor.isNull(offset + 66) ? null : cursor.getString(offset + 66), // msgIssuerCode
            cursor.isNull(offset + 67) ? null : cursor.getString(offset + 67), // msgAcquirerCode
            cursor.isNull(offset + 68) ? null : cursor.getString(offset + 68), // msgBalance
            cursor.isNull(offset + 69) ? null : cursor.getString(offset + 69), // msgInterOrgCode
            cursor.isNull(offset + 70) ? null : cursor.getString(offset + 70), // msgIssuerInfo
            cursor.isNull(offset + 71) ? null : cursor.getString(offset + 71), // msgCUPInfo
            cursor.isNull(offset + 72) ? null : cursor.getString(offset + 72), // msgAcqInfo
            cursor.isNull(offset + 73) ? null : cursor.getString(offset + 73), // msgTermReserved
            cursor.getShort(offset + 74) != 0, // statusIccFailTrans
            cursor.getShort(offset + 75) != 0, // statusOffline
            cursor.getShort(offset + 76) != 0, // statusVoided
            cursor.getShort(offset + 77) != 0, // statusAdjusted
            cursor.getShort(offset + 78) != 0, // statusNeedPrint
            cursor.getShort(offset + 79) != 0, // statusNeedReversal
            cursor.getShort(offset + 80) != 0, // statusNeedScript
            cursor.getShort(offset + 81) != 0, // statusArpcErr
            cursor.getInt(offset + 82), // statusReversalReason
            cursor.getInt(offset + 83), // statusAdjustedTimes
            cursor.getInt(offset + 84), // statusOffineUpload
            cursor.getInt(offset + 85), // statusBatchUpload
            cursor.isNull(offset + 86) ? null : cursor.getString(offset + 86), // rfu1
            cursor.isNull(offset + 87) ? null : cursor.getString(offset + 87), // rfu2
            cursor.isNull(offset + 88) ? null : cursor.getString(offset + 88) // rfu3
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, TransRecordEntity entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setTransID(cursor.getInt(offset + 1));
        entity.setCardType(cursor.getInt(offset + 2));
        entity.setCardCtlsFlowType(cursor.getInt(offset + 3));
        entity.setCardFallback(cursor.getShort(offset + 4) != 0);
        entity.setCardNo(cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5));
        entity.setCardHolderName(cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
        entity.setCardExpDate(cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7));
        entity.setEmvAC(cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8));
        entity.setEmvCID(cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9));
        entity.setEmvIAD(cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10));
        entity.setEmvUN(cursor.isNull(offset + 11) ? null : cursor.getString(offset + 11));
        entity.setEmvATC(cursor.isNull(offset + 12) ? null : cursor.getString(offset + 12));
        entity.setEmvTVR(cursor.isNull(offset + 13) ? null : cursor.getString(offset + 13));
        entity.setEmvTransDate(cursor.isNull(offset + 14) ? null : cursor.getString(offset + 14));
        entity.setEmvTransType(cursor.isNull(offset + 15) ? null : cursor.getString(offset + 15));
        entity.setEmvTransAmount(cursor.isNull(offset + 16) ? null : cursor.getString(offset + 16));
        entity.setEmvCurrencyCode(cursor.isNull(offset + 17) ? null : cursor.getString(offset + 17));
        entity.setEmvCountryCode(cursor.isNull(offset + 18) ? null : cursor.getString(offset + 18));
        entity.setEmvAIP(cursor.isNull(offset + 19) ? null : cursor.getString(offset + 19));
        entity.setEmvTermCap(cursor.isNull(offset + 20) ? null : cursor.getString(offset + 20));
        entity.setEmvCVMResult(cursor.isNull(offset + 21) ? null : cursor.getString(offset + 21));
        entity.setEmvAmountOther(cursor.isNull(offset + 22) ? null : cursor.getString(offset + 22));
        entity.setEmvAID(cursor.isNull(offset + 23) ? null : cursor.getString(offset + 23));
        entity.setEmvAppVer(cursor.isNull(offset + 24) ? null : cursor.getString(offset + 24));
        entity.setEmvTermAppVer(cursor.isNull(offset + 25) ? null : cursor.getString(offset + 25));
        entity.setEmvTermType(cursor.isNull(offset + 26) ? null : cursor.getString(offset + 26));
        entity.setEmvIFDSN(cursor.isNull(offset + 27) ? null : cursor.getString(offset + 27));
        entity.setEmvCategoryCode(cursor.isNull(offset + 28) ? null : cursor.getString(offset + 28));
        entity.setEmvTransSeqCnt(cursor.isNull(offset + 29) ? null : cursor.getString(offset + 29));
        entity.setEmvFFI(cursor.isNull(offset + 30) ? null : cursor.getString(offset + 30));
        entity.setEmvIDN(cursor.isNull(offset + 31) ? null : cursor.getString(offset + 31));
        entity.setEmvAOSA(cursor.isNull(offset + 32) ? null : cursor.getString(offset + 32));
        entity.setEmvTSI(cursor.isNull(offset + 33) ? null : cursor.getString(offset + 33));
        entity.setEmvPanSN(cursor.isNull(offset + 34) ? null : cursor.getString(offset + 34));
        entity.setEmvAppLabel(cursor.isNull(offset + 35) ? null : cursor.getString(offset + 35));
        entity.setEmvAppPreferName(cursor.isNull(offset + 36) ? null : cursor.getString(offset + 36));
        entity.setEmvIssAuthData(cursor.isNull(offset + 37) ? null : cursor.getString(offset + 37));
        entity.setEmvScriptResult(cursor.isNull(offset + 38) ? null : cursor.getString(offset + 38));
        entity.setEmvCardId(cursor.isNull(offset + 39) ? null : cursor.getString(offset + 39));
        entity.setMsgCashierNO(cursor.isNull(offset + 40) ? null : cursor.getString(offset + 40));
        entity.setMsgBitmap(cursor.isNull(offset + 41) ? null : cursor.getString(offset + 41));
        entity.setMsgProcCode(cursor.isNull(offset + 42) ? null : cursor.getString(offset + 42));
        entity.setMsgAmount(cursor.isNull(offset + 43) ? null : cursor.getString(offset + 43));
        entity.setMsgDateTime(cursor.isNull(offset + 44) ? null : cursor.getString(offset + 44));
        entity.setMsgTraceNO(cursor.isNull(offset + 45) ? null : cursor.getString(offset + 45));
        entity.setMsgEntryMode(cursor.isNull(offset + 46) ? null : cursor.getString(offset + 46));
        entity.setMsgConditionCode(cursor.isNull(offset + 47) ? null : cursor.getString(offset + 47));
        entity.setMsgPinCapCode(cursor.isNull(offset + 48) ? null : cursor.getString(offset + 48));
        entity.setMsgTermID(cursor.isNull(offset + 49) ? null : cursor.getString(offset + 49));
        entity.setMsgMerchID(cursor.isNull(offset + 50) ? null : cursor.getString(offset + 50));
        entity.setMsgTipAmount(cursor.isNull(offset + 51) ? null : cursor.getString(offset + 51));
        entity.setMsgCurrencyCode(cursor.isNull(offset + 52) ? null : cursor.getString(offset + 52));
        entity.setMsgFuncCode(cursor.isNull(offset + 53) ? null : cursor.getString(offset + 53));
        entity.setMsgBatchNO(cursor.isNull(offset + 54) ? null : cursor.getString(offset + 54));
        entity.setMsgOrigBatchNO(cursor.isNull(offset + 55) ? null : cursor.getString(offset + 55));
        entity.setMsgOrigTraceNO(cursor.isNull(offset + 56) ? null : cursor.getString(offset + 56));
        entity.setMsgOrigDate(cursor.isNull(offset + 57) ? null : cursor.getString(offset + 57));
        entity.setMsgCashbackAmount(cursor.isNull(offset + 58) ? null : cursor.getString(offset + 58));
        entity.setMsgTransTime(cursor.isNull(offset + 59) ? null : cursor.getString(offset + 59));
        entity.setMsgTransDate(cursor.isNull(offset + 60) ? null : cursor.getString(offset + 60));
        entity.setMsgSettlementDate(cursor.isNull(offset + 61) ? null : cursor.getString(offset + 61));
        entity.setMsgAcqID(cursor.isNull(offset + 62) ? null : cursor.getString(offset + 62));
        entity.setMsgRefNO(cursor.isNull(offset + 63) ? null : cursor.getString(offset + 63));
        entity.setMsgAuthCode(cursor.isNull(offset + 64) ? null : cursor.getString(offset + 64));
        entity.setMsgRespCode(cursor.isNull(offset + 65) ? null : cursor.getString(offset + 65));
        entity.setMsgIssuerCode(cursor.isNull(offset + 66) ? null : cursor.getString(offset + 66));
        entity.setMsgAcquirerCode(cursor.isNull(offset + 67) ? null : cursor.getString(offset + 67));
        entity.setMsgBalance(cursor.isNull(offset + 68) ? null : cursor.getString(offset + 68));
        entity.setMsgInterOrgCode(cursor.isNull(offset + 69) ? null : cursor.getString(offset + 69));
        entity.setMsgIssuerInfo(cursor.isNull(offset + 70) ? null : cursor.getString(offset + 70));
        entity.setMsgCUPInfo(cursor.isNull(offset + 71) ? null : cursor.getString(offset + 71));
        entity.setMsgAcqInfo(cursor.isNull(offset + 72) ? null : cursor.getString(offset + 72));
        entity.setMsgTermReserved(cursor.isNull(offset + 73) ? null : cursor.getString(offset + 73));
        entity.setStatusIccFailTrans(cursor.getShort(offset + 74) != 0);
        entity.setStatusOffline(cursor.getShort(offset + 75) != 0);
        entity.setStatusVoided(cursor.getShort(offset + 76) != 0);
        entity.setStatusAdjusted(cursor.getShort(offset + 77) != 0);
        entity.setStatusNeedPrint(cursor.getShort(offset + 78) != 0);
        entity.setStatusNeedReversal(cursor.getShort(offset + 79) != 0);
        entity.setStatusNeedScript(cursor.getShort(offset + 80) != 0);
        entity.setStatusArpcErr(cursor.getShort(offset + 81) != 0);
        entity.setStatusReversalReason(cursor.getInt(offset + 82));
        entity.setStatusAdjustedTimes(cursor.getInt(offset + 83));
        entity.setStatusOffineUpload(cursor.getInt(offset + 84));
        entity.setStatusBatchUpload(cursor.getInt(offset + 85));
        entity.setRfu1(cursor.isNull(offset + 86) ? null : cursor.getString(offset + 86));
        entity.setRfu2(cursor.isNull(offset + 87) ? null : cursor.getString(offset + 87));
        entity.setRfu3(cursor.isNull(offset + 88) ? null : cursor.getString(offset + 88));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(TransRecordEntity entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(TransRecordEntity entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(TransRecordEntity entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
