package cn.nexgo.inbas.components.data.daoGenerate;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import cn.nexgo.inbas.components.data.bean.CardBinEntity;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "CARDBIN_TABLE".
*/
public class CardBinEntityDao extends AbstractDao<CardBinEntity, Long> {

    public static final String TABLENAME = "CARDBIN_TABLE";

    /**
     * Properties of entity CardBinEntity.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", true, "_id");
        public final static Property StartPrefix = new Property(1, String.class, "startPrefix", false, "STARTPREFIX");
        public final static Property EndPrefix = new Property(2, String.class, "endPrefix", false, "ENDPREFIX");
        public final static Property CardAcq = new Property(3, int.class, "cardAcq", false, "CARD_ACQUIRER");
        public final static Property Rfu1 = new Property(4, String.class, "rfu1", false, "RFU_1");
    }


    public CardBinEntityDao(DaoConfig config) {
        super(config);
    }
    
    public CardBinEntityDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"CARDBIN_TABLE\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: id
                "\"STARTPREFIX\" TEXT," + // 1: startPrefix
                "\"ENDPREFIX\" TEXT," + // 2: endPrefix
                "\"CARD_ACQUIRER\" INTEGER NOT NULL ," + // 3: cardAcq
                "\"RFU_1\" TEXT);"); // 4: rfu1
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"CARDBIN_TABLE\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, CardBinEntity entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        String startPrefix = entity.getStartPrefix();
        if (startPrefix != null) {
            stmt.bindString(2, startPrefix);
        }
 
        String endPrefix = entity.getEndPrefix();
        if (endPrefix != null) {
            stmt.bindString(3, endPrefix);
        }
        stmt.bindLong(4, entity.getCardAcq());
 
        String rfu1 = entity.getRfu1();
        if (rfu1 != null) {
            stmt.bindString(5, rfu1);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, CardBinEntity entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        String startPrefix = entity.getStartPrefix();
        if (startPrefix != null) {
            stmt.bindString(2, startPrefix);
        }
 
        String endPrefix = entity.getEndPrefix();
        if (endPrefix != null) {
            stmt.bindString(3, endPrefix);
        }
        stmt.bindLong(4, entity.getCardAcq());
 
        String rfu1 = entity.getRfu1();
        if (rfu1 != null) {
            stmt.bindString(5, rfu1);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public CardBinEntity readEntity(Cursor cursor, int offset) {
        CardBinEntity entity = new CardBinEntity( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1), // startPrefix
            cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), // endPrefix
            cursor.getInt(offset + 3), // cardAcq
            cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4) // rfu1
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, CardBinEntity entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setStartPrefix(cursor.isNull(offset + 1) ? null : cursor.getString(offset + 1));
        entity.setEndPrefix(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setCardAcq(cursor.getInt(offset + 3));
        entity.setRfu1(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(CardBinEntity entity, long rowId) {
        entity.setId(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(CardBinEntity entity) {
        if(entity != null) {
            return entity.getId();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(CardBinEntity entity) {
        return entity.getId() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
