package cn.nexgo.inbas.components.data.bean;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Generated;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.Property;

import cn.nexgo.inbas.components.data.DataConstant.CommuMode;
import cn.nexgo.protocol.iso8583.LenType;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * File Name     : SetupEntity.java
 * Usage         : Entity for a Setup Entity
 * Version       : 1
 * Author        : Brad
 * Date          : 2017/12/12
 * Modification  : Created file

 **************************************************************************************************/
@Entity(
    nameInDb = "SETUP_TABLE",      // Table Name
    createInDb = true,             // if create a tablE
    generateConstructors = true,   // if generate constructors.
    generateGettersSetters = true  // If generate getters and setters' methods
)
public class SetupEntity {
    @Id(autoincrement = true)
    private Long id;                            // Unique id for each record

    // Hardware parameters
    @Property(nameInDb = "HW_IS_EXT_PED")
    private boolean hwExtPED = false;                     // external pinpad: enable/disable
    @Property(nameInDb = "HW_IS_INTERNAL_RF")
    private boolean hwIntRf = true;                       // if with internal RF reader or not

    // Communication parameters
    @Property(nameInDb = "COMMU_TPDU")
    private String commuTPDU = "6000033000";              // TPDU
    @Property(nameInDb = "COMMU_NNI")
    private String commuNII = "00";                       // #24 network international identifier (NII)
    @Property(nameInDb = "COMMU_CONNECT_TIME")
    private int commuConnectTimeout = 30;                 // Connecting Timeout
    @Property(nameInDb = "COMMU_RECV_TIME")
    private int commuRecvTimeout = 30;                    // Receiving Timeout
    @Property(nameInDb = "COMMU_MSG_LEN_TYPE")
    private int commuMsgLenType = 0;                      // type of message's length :0:hex/1:bcd/2:asc

    @Property(nameInDb = "COMMU_IS_USE_BACKUP")
    private boolean commuUseBackupFirst = false;          // use backup parameter firstly
    @Property(nameInDb = "COMMU_MODE")
    private int commuMode = 0;                            // communication mode
    @Property(nameInDb = "COMMU_IS_WITH_SSL")
    private boolean commuWithSSL = false;                 // communication wiht SSL
    @Property(nameInDb = "COMMU_HOST_ADDRESS_1")
    private String commuHostAddress1 = "123.58.32.120";  // host address1
    @Property(nameInDb = "COMMU_HOST_PORT_1")
    private String commuHostPort1 = "8868";               // host port1
    @Property(nameInDb = "COMMU_HOST_ADRESS_2")
    private String commuHostAddress2 = "";                // host address2
    @Property(nameInDb = "COMMU_HOST_PORT_2")
    private String commuHostPort2 = "";                   // host port2

    // Transaction control parameters
    @Property(nameInDb = "TRANS_IS_SUPPORT_SALE")
    private boolean transSupportSale = true;              // Support Sale or not
    @Property(nameInDb = "TRANS_IS_SUPPORT_VOID")
    private boolean transSupportVoid = true;              // Support Void or not
    @Property(nameInDb = "TRANS_IS_SUPPORT_REFUND")
    private boolean transSupportRefund = true;            // Support Refund or not
    @Property(nameInDb = "TRANS_IS_SUPPORT_ADJUST")
    private boolean transSupportAdjust = true;            // Support Adjust or not

    @Property(nameInDb = "TRANS_IS_VOID_NEEDCARD")
    private boolean transVoidNeedCard = false;            // need read card when doing transactions of void
    @Property(nameInDb = "TRANS_IS_VOID_NEEDPIN")
    private boolean transVoidNeedPIN = true;              // need PIN when doing transactions of void
    @Property(nameInDb = "TRANS_IS_AUTO_LOGON")
    private boolean transAutoLogon = true;                // do logon transaction automatically before other transaction
    @Property(nameInDb = "TRANS_IS_TUTO_LOGOUT")
    private boolean transAutoLogout = false;              // do logout transaction automatically after settlement
    @Property(nameInDb = "TRANS_IS_CHECK_ADMIN_PWD")
    private boolean transCheckAdminPwd = true;            // need chenk admin password when doing transactions of void
    @Property(nameInDb = "TRANS_IS_MASK_PAN")
    private boolean transMaskPAN = true;                  // mask the PAN when doing thransacions of sale
    @Property(nameInDb = "TRANS_IS_PRINT_MINUS_SIGN")
    private boolean transPrintMinus = true;               // if void transaction need print minus sign

    @Property(nameInDb = "TRANS_REFUND_MAX_AMOUNT")
    private String transRefundMaxAmt = "100000";    // the max. amount when doing refund transaction
    @Property(nameInDb = "TRANS_OFF_TRANS_UPLOAD_TIMES")
    private int transOffTransUpTimes = 3;                 // offline transaction upload times
    @Property(nameInDb = "TRANS_OFF_SALE_AUTOUP_NUM")
    private int transOffSaleAutoUpNum = 3;                // Automaticly upload offline sale times
    @Property(nameInDb = "TRANS_REVERSAL_TIMES")
    private int transReversalTimes = 3;                   // Reversal times
    @Property(nameInDb = "TRANS_MAX_TRANS_NUM")
    private int trasnMaxTransNum = 999;                  // Maximum numbers of Transactions Records
    @Property(nameInDb = "TRANS_PRINT_TIMES")
    private int transPrintTimes = 2;                      // Print times
    @Property(nameInDb = "TRANS_TIP_RATE")
    private int transTipRate = 15;                        // Tip Rate(%)
    @Property(nameInDb = "TRANS_TIP_TIMES")
    private int transTipTimes = 1;                        // Tip Times
    @Property(nameInDb = "TRANS_REFUND_MODE")
    private int transRefundMode = 0;                      // Refund Mode
    @Property(nameInDb = "TRANS_TRACE_NO")
    private String transTraceNO = "000001";               // Trace NO.
    @Property(nameInDb = "TRANS_BATCH_NO")
    private String transBatchNO = "000001";               // Batch NO.
    @Property(nameInDb = "TRANS_IS_CTLS")
    private boolean transCTLS = true;                     // Support CTLS Transaction or not
    @Property(nameInDb = "TRANS_IS_FALLBACK")
    private boolean transFallback = true;                 // Support Fallback transaction or not
    @Property(nameInDb = "TRANS_IS_FORCE_ONLINE")
    private boolean transForceOnline = false;             // if force online

    // Safe parameters
    @Property(nameInDb = "SAFE_IS_TDES")
    private boolean safeTripleDES = true;                 // T-DES or not
    @Property(nameInDb = "SAFE_IS_DUKPT")
    private boolean safeUseDUKPT = false;                 // Using DUKPT or not
    @Property(nameInDb = "SAFE_TMK_INDEX")
    private int safeTmkIndex = 0;                         // TMK index

    // Password Management
    //ST_CASHIER_PWD stCashier;                           // Saved in another table
    @Property(nameInDb = "PWD_ADMIN")
    private String pwdAdmin = "123456";                   // admin password
    @Property(nameInDb = "PWD_SYSTEM")
    private String pwdSystem = "88888888";                // system password

    // Terminal Information
    @Property(nameInDb = "TERM_TID")
    private String termTID = "12345678";                  // terminal ID
    @Property(nameInDb = "TERM_MID")
    private String termMID = "123456789012345";           // merchant ID
    @Property(nameInDb = "TERM_MERCHANT_NAME")
    private String termMerchName = "NEXGO";               // merchant name
    @Property(nameInDb = "TERM_MERCHANT_ADDR1")
    private String termMerchAddr1;                        // merchant address line 1
    @Property(nameInDb = "TERM_MERCHANT_ADDR2")
    private String termMerchAddr2;                        // merchant address line 2
    @Property(nameInDb = "TERM_MERCHANT_ADDR3")
    private String termMerchAddr3;                        // merchant address line 3
    @Property(nameInDb = "TERM_MERCHANT_TEL")
    private String termMerchTel;                          // merchant telephone
    @Property(nameInDb = "TERM_CURRENCY_CODE")
    private String termCurrencyCode = "156";              // currency code
    @Property(nameInDb = "TERM_COUNTRY_CODE")
    private String termCountryCode = "156";               // country code
    @Property(nameInDb = "TERM_CURRENCY_NAME")
    private String termCurrencyName = "￥";              // currency name
    @Property(nameInDb = "TERM_AMT_DECIMAL_LEN")
    private int termAmountDecimalLen = 2;                 // lenght of decimal for amount(x.xx, x.xxx, ...)

    //Tms parameter version
    @Property(nameInDb = "TMS_PARAMETER_VERSION")
    private String tmsParamVersion = "00000000000000";


    @Property(nameInDb = "EMV_ICC_TERMINAL_TYPE")
    private String emvIccTerminalType = "22";
    @Property(nameInDb = "EMV_ICC_TERMINAL_CAPABILITY")
    private String emvIccTerminalCapability = "E0F8C8";
    @Property(nameInDb = "EMV_ICC_TERMINAL_ADD_CAPABILITY")
    private String emvIccTerminalAddCapability = "6100D0B001";
    @Property(nameInDb = "EMV_CONTACTLESS_LED_ENABLE")
    private boolean emvContactlessLedEnable = false;
    @Property(nameInDb = "EMV_CONTACTLESS_LED_IDEL_ENABLE")
    private boolean emvContactlessLedIdelEnable = false;

    //help
    @Property(nameInDb = "TERM_HELP_URL")
    private String helpUrl = "http://www.nexgo.cn/";

    //xtms ip port
    @Property(nameInDb = "TERM_TMS_IP")
    private String tmsIp = "xtms.nexgo.cn";
    @Property(nameInDb = "TERM_TMS_PORT")
    private String tmsPort = "6643";



    @Property(nameInDb = "RFU_1")
    private String rfu1;
    @Property(nameInDb = "RFU_2")
    private String rfu2;
    @Property(nameInDb = "RFU_3")
    private String rfu3;





    @Generated(hash = 1871497651)
    public SetupEntity(Long id, boolean hwExtPED, boolean hwIntRf, String commuTPDU, String commuNII,
            int commuConnectTimeout, int commuRecvTimeout, int commuMsgLenType, boolean commuUseBackupFirst, int commuMode,
            boolean commuWithSSL, String commuHostAddress1, String commuHostPort1, String commuHostAddress2,
            String commuHostPort2, boolean transSupportSale, boolean transSupportVoid, boolean transSupportRefund,
            boolean transSupportAdjust, boolean transVoidNeedCard, boolean transVoidNeedPIN, boolean transAutoLogon,
            boolean transAutoLogout, boolean transCheckAdminPwd, boolean transMaskPAN, boolean transPrintMinus,
            String transRefundMaxAmt, int transOffTransUpTimes, int transOffSaleAutoUpNum, int transReversalTimes,
            int trasnMaxTransNum, int transPrintTimes, int transTipRate, int transTipTimes, int transRefundMode,
            String transTraceNO, String transBatchNO, boolean transCTLS, boolean transFallback, boolean transForceOnline,
            boolean safeTripleDES, boolean safeUseDUKPT, int safeTmkIndex, String pwdAdmin, String pwdSystem,
            String termTID, String termMID, String termMerchName, String termMerchAddr1, String termMerchAddr2,
            String termMerchAddr3, String termMerchTel, String termCurrencyCode, String termCountryCode,
            String termCurrencyName, int termAmountDecimalLen, String tmsParamVersion, String emvIccTerminalType,
            String emvIccTerminalCapability, String emvIccTerminalAddCapability, boolean emvContactlessLedEnable,
            boolean emvContactlessLedIdelEnable, String helpUrl, String tmsIp, String tmsPort, String rfu1, String rfu2,
            String rfu3) {
        this.id = id;
        this.hwExtPED = hwExtPED;
        this.hwIntRf = hwIntRf;
        this.commuTPDU = commuTPDU;
        this.commuNII = commuNII;
        this.commuConnectTimeout = commuConnectTimeout;
        this.commuRecvTimeout = commuRecvTimeout;
        this.commuMsgLenType = commuMsgLenType;
        this.commuUseBackupFirst = commuUseBackupFirst;
        this.commuMode = commuMode;
        this.commuWithSSL = commuWithSSL;
        this.commuHostAddress1 = commuHostAddress1;
        this.commuHostPort1 = commuHostPort1;
        this.commuHostAddress2 = commuHostAddress2;
        this.commuHostPort2 = commuHostPort2;
        this.transSupportSale = transSupportSale;
        this.transSupportVoid = transSupportVoid;
        this.transSupportRefund = transSupportRefund;
        this.transSupportAdjust = transSupportAdjust;
        this.transVoidNeedCard = transVoidNeedCard;
        this.transVoidNeedPIN = transVoidNeedPIN;
        this.transAutoLogon = transAutoLogon;
        this.transAutoLogout = transAutoLogout;
        this.transCheckAdminPwd = transCheckAdminPwd;
        this.transMaskPAN = transMaskPAN;
        this.transPrintMinus = transPrintMinus;
        this.transRefundMaxAmt = transRefundMaxAmt;
        this.transOffTransUpTimes = transOffTransUpTimes;
        this.transOffSaleAutoUpNum = transOffSaleAutoUpNum;
        this.transReversalTimes = transReversalTimes;
        this.trasnMaxTransNum = trasnMaxTransNum;
        this.transPrintTimes = transPrintTimes;
        this.transTipRate = transTipRate;
        this.transTipTimes = transTipTimes;
        this.transRefundMode = transRefundMode;
        this.transTraceNO = transTraceNO;
        this.transBatchNO = transBatchNO;
        this.transCTLS = transCTLS;
        this.transFallback = transFallback;
        this.transForceOnline = transForceOnline;
        this.safeTripleDES = safeTripleDES;
        this.safeUseDUKPT = safeUseDUKPT;
        this.safeTmkIndex = safeTmkIndex;
        this.pwdAdmin = pwdAdmin;
        this.pwdSystem = pwdSystem;
        this.termTID = termTID;
        this.termMID = termMID;
        this.termMerchName = termMerchName;
        this.termMerchAddr1 = termMerchAddr1;
        this.termMerchAddr2 = termMerchAddr2;
        this.termMerchAddr3 = termMerchAddr3;
        this.termMerchTel = termMerchTel;
        this.termCurrencyCode = termCurrencyCode;
        this.termCountryCode = termCountryCode;
        this.termCurrencyName = termCurrencyName;
        this.termAmountDecimalLen = termAmountDecimalLen;
        this.tmsParamVersion = tmsParamVersion;
        this.emvIccTerminalType = emvIccTerminalType;
        this.emvIccTerminalCapability = emvIccTerminalCapability;
        this.emvIccTerminalAddCapability = emvIccTerminalAddCapability;
        this.emvContactlessLedEnable = emvContactlessLedEnable;
        this.emvContactlessLedIdelEnable = emvContactlessLedIdelEnable;
        this.helpUrl = helpUrl;
        this.tmsIp = tmsIp;
        this.tmsPort = tmsPort;
        this.rfu1 = rfu1;
        this.rfu2 = rfu2;
        this.rfu3 = rfu3;
    }


    @Generated(hash = 1653292675)
    public SetupEntity() {
    }





    /**
     *  Add more Getters and Setters for users
     */
    public LenType getCommuMsgLenTypeEnum() {
        for (LenType lenType : LenType.values()){
            if(lenType.ordinal() == getCommuMsgLenType()){
                return lenType;
            }
        }
        return null;
    }


    public void setCommuMsgLenType(LenType msgLenType) {
        this.commuMsgLenType = msgLenType.ordinal();
    }
    public CommuMode getCommuModeEnum() {
        for (CommuMode commuMode : CommuMode.values()){
            if(commuMode.ordinal() == getCommuMode()){
                return commuMode;
            }
        }
        return null;
    }
    public void setCommuMode(CommuMode commuMode) {
        this.commuMode = commuMode.ordinal();
    }
    /*
        Adding end
     */
    public Long getId() {
        return this.id;
    }
    public void setId(Long id) {
        this.id = id;
    }
    public boolean getHwExtPED() {
        return this.hwExtPED;
    }
    public void setHwExtPED(boolean hwExtPED) {
        this.hwExtPED = hwExtPED;
    }
    public boolean getHwIntRf() {
        return this.hwIntRf;
    }
    public void setHwIntRf(boolean hwIntRf) {
        this.hwIntRf = hwIntRf;
    }
    public String getCommuTPDU() {
        return this.commuTPDU;
    }
    public void setCommuTPDU(String commuTPDU) {
        this.commuTPDU = commuTPDU;
    }
    public String getCommuNII() {
        return this.commuNII;
    }
    public void setCommuNII(String commuNII) {
        this.commuNII = commuNII;
    }
    public int getCommuConnectTimeout() {
        return this.commuConnectTimeout;
    }
    public void setCommuConnectTimeout(int commuConnectTimeout) {
        this.commuConnectTimeout = commuConnectTimeout;
    }
    public int getCommuRecvTimeout() {
        return this.commuRecvTimeout;
    }
    public void setCommuRecvTimeout(int commuRecvTimeout) {
        this.commuRecvTimeout = commuRecvTimeout;
    }
    public int getCommuMsgLenType() {
        return this.commuMsgLenType;
    }
    public void setCommuMsgLenType(int commuMsgLenType) {
        this.commuMsgLenType = commuMsgLenType;
    }
    public boolean getCommuUseBackupFirst() {
        return this.commuUseBackupFirst;
    }
    public void setCommuUseBackupFirst(boolean commuUseBackupFirst) {
        this.commuUseBackupFirst = commuUseBackupFirst;
    }
    public int getCommuMode() {
        return this.commuMode;
    }
    public void setCommuMode(int commuMode) {
        this.commuMode = commuMode;
    }
    public boolean getCommuWithSSL() {
        return this.commuWithSSL;
    }
    public void setCommuWithSSL(boolean commuWithSSL) {
        this.commuWithSSL = commuWithSSL;
    }
    public String getCommuHostAddress1() {
        return this.commuHostAddress1;
    }
    public void setCommuHostAddress1(String commuHostAddress1) {
        this.commuHostAddress1 = commuHostAddress1;
    }
    public String getCommuHostPort1() {
        return this.commuHostPort1;
    }
    public void setCommuHostPort1(String commuHostPort1) {
        this.commuHostPort1 = commuHostPort1;
    }
    public String getCommuHostAddress2() {
        return this.commuHostAddress2;
    }
    public void setCommuHostAddress2(String commuHostAddress2) {
        this.commuHostAddress2 = commuHostAddress2;
    }
    public String getCommuHostPort2() {
        return this.commuHostPort2;
    }
    public void setCommuHostPort2(String commuHostPort2) {
        this.commuHostPort2 = commuHostPort2;
    }
    public boolean getTransSupportSale() {
        return this.transSupportSale;
    }
    public void setTransSupportSale(boolean transSupportSale) {
        this.transSupportSale = transSupportSale;
    }
    public boolean getTransSupportVoid() {
        return this.transSupportVoid;
    }
    public void setTransSupportVoid(boolean transSupportVoid) {
        this.transSupportVoid = transSupportVoid;
    }
    public boolean getTransSupportRefund() {
        return this.transSupportRefund;
    }
    public void setTransSupportRefund(boolean transSupportRefund) {
        this.transSupportRefund = transSupportRefund;
    }
    public boolean getTransSupportAdjust() {
        return this.transSupportAdjust;
    }
    public void setTransSupportAdjust(boolean transSupportAdjust) {
        this.transSupportAdjust = transSupportAdjust;
    }
    public boolean getTransVoidNeedCard() {
        return this.transVoidNeedCard;
    }
    public void setTransVoidNeedCard(boolean transVoidNeedCard) {
        this.transVoidNeedCard = transVoidNeedCard;
    }
    public boolean getTransVoidNeedPIN() {
        return this.transVoidNeedPIN;
    }
    public void setTransVoidNeedPIN(boolean transVoidNeedPIN) {
        this.transVoidNeedPIN = transVoidNeedPIN;
    }
    public boolean getTransAutoLogon() {
        return this.transAutoLogon;
    }
    public void setTransAutoLogon(boolean transAutoLogon) {
        this.transAutoLogon = transAutoLogon;
    }
    public boolean getTransAutoLogout() {
        return this.transAutoLogout;
    }
    public void setTransAutoLogout(boolean transAutoLogout) {
        this.transAutoLogout = transAutoLogout;
    }
    public boolean getTransCheckAdminPwd() {
        return this.transCheckAdminPwd;
    }
    public void setTransCheckAdminPwd(boolean transCheckAdminPwd) {
        this.transCheckAdminPwd = transCheckAdminPwd;
    }
    public boolean getTransMaskPAN() {
        return this.transMaskPAN;
    }
    public void setTransMaskPAN(boolean transMaskPAN) {
        this.transMaskPAN = transMaskPAN;
    }
    public boolean getTransPrintMinus() {
        return this.transPrintMinus;
    }
    public void setTransPrintMinus(boolean transPrintMinus) {
        this.transPrintMinus = transPrintMinus;
    }
    public String getTransRefundMaxAmt() {
        return this.transRefundMaxAmt;
    }
    public void setTransRefundMaxAmt(String transRefundMaxAmt) {
        this.transRefundMaxAmt = transRefundMaxAmt;
    }
    public int getTransOffTransUpTimes() {
        return this.transOffTransUpTimes;
    }
    public void setTransOffTransUpTimes(int transOffTransUpTimes) {
        this.transOffTransUpTimes = transOffTransUpTimes;
    }
    public int getTransOffSaleAutoUpNum() {
        return this.transOffSaleAutoUpNum;
    }
    public void setTransOffSaleAutoUpNum(int transOffSaleAutoUpNum) {
        this.transOffSaleAutoUpNum = transOffSaleAutoUpNum;
    }
    public int getTransReversalTimes() {
        return this.transReversalTimes;
    }
    public void setTransReversalTimes(int transReversalTimes) {
        this.transReversalTimes = transReversalTimes;
    }
    public int getTrasnMaxTransNum() {
        return this.trasnMaxTransNum;
    }
    public void setTrasnMaxTransNum(int trasnMaxTransNum) {
        this.trasnMaxTransNum = trasnMaxTransNum;
    }
    public int getTransPrintTimes() {
        return this.transPrintTimes;
    }
    public void setTransPrintTimes(int transPrintTimes) {
        this.transPrintTimes = transPrintTimes;
    }
    public int getTransTipRate() {
        return this.transTipRate;
    }
    public void setTransTipRate(int transTipRate) {
        this.transTipRate = transTipRate;
    }
    public int getTransTipTimes() {
        return this.transTipTimes;
    }
    public void setTransTipTimes(int transTipTimes) {
        this.transTipTimes = transTipTimes;
    }
    public int getTransRefundMode() {
        return this.transRefundMode;
    }
    public void setTransRefundMode(int transRefundMode) {
        this.transRefundMode = transRefundMode;
    }
    public String getTransTraceNO() {
        return this.transTraceNO;
    }
    public void setTransTraceNO(String transTraceNO) {
        this.transTraceNO = transTraceNO;
    }
    public String getTransBatchNO() {
        return this.transBatchNO;
    }
    public void setTransBatchNO(String transBatchNO) {
        this.transBatchNO = transBatchNO;
    }
    public boolean getTransCTLS() {
        return this.transCTLS;
    }
    public void setTransCTLS(boolean transCTLS) {
        this.transCTLS = transCTLS;
    }
    public boolean getTransFallback() {
        return this.transFallback;
    }
    public void setTransFallback(boolean transFallback) {
        this.transFallback = transFallback;
    }
    public boolean getTransForceOnline() {
        return this.transForceOnline;
    }
    public void setTransForceOnline(boolean transForceOnline) {
        this.transForceOnline = transForceOnline;
    }
    public boolean getSafeTripleDES() {
        return this.safeTripleDES;
    }
    public void setSafeTripleDES(boolean safeTripleDES) {
        this.safeTripleDES = safeTripleDES;
    }
    public boolean getSafeUseDUKPT() {
        return this.safeUseDUKPT;
    }
    public void setSafeUseDUKPT(boolean safeUseDUKPT) {
        this.safeUseDUKPT = safeUseDUKPT;
    }
    public int getSafeTmkIndex() {
        return this.safeTmkIndex;
    }
    public void setSafeTmkIndex(int safeTmkIndex) {
        this.safeTmkIndex = safeTmkIndex;
    }
    public String getPwdAdmin() {
        return this.pwdAdmin;
    }
    public void setPwdAdmin(String pwdAdmin) {
        this.pwdAdmin = pwdAdmin;
    }
    public String getPwdSystem() {
        return this.pwdSystem;
    }
    public void setPwdSystem(String pwdSystem) {
        this.pwdSystem = pwdSystem;
    }
    public String getTermTID() {
        return this.termTID;
    }
    public void setTermTID(String termTID) {
        this.termTID = termTID;
    }
    public String getTermMID() {
        return this.termMID;
    }
    public void setTermMID(String termMID) {
        this.termMID = termMID;
    }
    public String getTermMerchName() {
        return this.termMerchName;
    }
    public void setTermMerchName(String termMerchName) {
        this.termMerchName = termMerchName;
    }
    public String getTermMerchAddr1() {
        return this.termMerchAddr1;
    }
    public void setTermMerchAddr1(String termMerchAddr1) {
        this.termMerchAddr1 = termMerchAddr1;
    }
    public String getTermMerchAddr2() {
        return this.termMerchAddr2;
    }
    public void setTermMerchAddr2(String termMerchAddr2) {
        this.termMerchAddr2 = termMerchAddr2;
    }
    public String getTermMerchAddr3() {
        return this.termMerchAddr3;
    }
    public void setTermMerchAddr3(String termMerchAddr3) {
        this.termMerchAddr3 = termMerchAddr3;
    }
    public String getTermMerchTel() {
        return this.termMerchTel;
    }
    public void setTermMerchTel(String termMerchTel) {
        this.termMerchTel = termMerchTel;
    }
    public String getTermCurrencyCode() {
        return this.termCurrencyCode;
    }
    public void setTermCurrencyCode(String termCurrencyCode) {
        this.termCurrencyCode = termCurrencyCode;
    }
    public String getTermCountryCode() {
        return this.termCountryCode;
    }
    public void setTermCountryCode(String termCountryCode) {
        this.termCountryCode = termCountryCode;
    }
    public String getTermCurrencyName() {
        return this.termCurrencyName;
    }
    public void setTermCurrencyName(String termCurrencyName) {
        this.termCurrencyName = termCurrencyName;
    }
    public int getTermAmountDecimalLen() {
        return this.termAmountDecimalLen;
    }
    public void setTermAmountDecimalLen(int termAmountDecimalLen) {
        this.termAmountDecimalLen = termAmountDecimalLen;
    }
    public String getRfu1() {
        return this.rfu1;
    }
    public void setRfu1(String rfu1) {
        this.rfu1 = rfu1;
    }
    public String getRfu2() {
        return this.rfu2;
    }
    public void setRfu2(String rfu2) {
        this.rfu2 = rfu2;
    }
    public String getRfu3() {
        return this.rfu3;
    }
    public void setRfu3(String rfu3) {
        this.rfu3 = rfu3;
    }


    public String getTmsParamVersion() {
        return this.tmsParamVersion;
    }


    public void setTmsParamVersion(String tmsParamVersion) {
        this.tmsParamVersion = tmsParamVersion;
    }


    public String getEmvIccTerminalCapability() {
        return this.emvIccTerminalCapability;
    }


    public void setEmvIccTerminalCapability(String emvIccTerminalCapability) {
        this.emvIccTerminalCapability = emvIccTerminalCapability;
    }


    public String getEmvIccTerminalAddCapability() {
        return this.emvIccTerminalAddCapability;
    }


    public void setEmvIccTerminalAddCapability(String emvIccTerminalAddCapability) {
        this.emvIccTerminalAddCapability = emvIccTerminalAddCapability;
    }


    public String getEmvIccTerminalType() {
        return this.emvIccTerminalType;
    }


    public void setEmvIccTerminalType(String emvIccTerminalType) {
        this.emvIccTerminalType = emvIccTerminalType;
    }


    public String getHelpUrl() {
        return this.helpUrl;
    }


    public void setHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
    }


    public String getTmsIp() {
        return this.tmsIp;
    }


    public void setTmsIp(String tmsIp) {
        this.tmsIp = tmsIp;
    }


    public String getTmsPort() {
        return this.tmsPort;
    }


    public void setTmsPort(String tmsPort) {
        this.tmsPort = tmsPort;
    }


    public boolean getEmvContactlessLedEnable() {
        return this.emvContactlessLedEnable;
    }


    public void setEmvContactlessLedEnable(boolean emvContactlessLedEnable) {
        this.emvContactlessLedEnable = emvContactlessLedEnable;
    }


    public boolean getEmvContactlessLedIdelEnable() {
        return this.emvContactlessLedIdelEnable;
    }


    public void setEmvContactlessLedIdelEnable(boolean emvContactlessLedIdelEnable) {
        this.emvContactlessLedIdelEnable = emvContactlessLedIdelEnable;
    }
}
