package cn.nexgo.inbas.components.data.bean;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.Property;
import org.greenrobot.greendao.annotation.Generated;

import cn.nexgo.inbas.components.data.DataConstant;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * File Name     : SettleInfoEntity.java
 * Usage         : 
 * Version       : 1
 * Author        : Brad
 * Date          : 2018/1/8 
 * Modification  : Created file

 **************************************************************************************************/
@Entity(
        nameInDb = "SETTLEMENT_INFO_TABLE",   // Table Name
        createInDb = true,                    // if create a tablE
        generateConstructors = true,          // if generate constructors.
        generateGettersSetters = true         // If generate getters and setters' methods
)
public class SettleInfoEntity {

    @Id(autoincrement = true)
    private Long id;                            // Unique id for each record

    @Property(nameInDb = "BATCH_STATUS")
    private int batchStatus = 0;                // Batch status referring to DataConstant.BatchStatus
    @Property(nameInDb = "BATCH_UPLOAD_NUM")
    private int batchUploadTotal = 0;           // Batch uploaded total numbers
    @Property(nameInDb = "SETTLE_STATUS")
    private int settleStatus = 0;               // Settlement status. referring to DataConstant.SettleStatus

    @Property(nameInDb = "SETTLE_MID")
    private String merchantID;
    @Property(nameInDb = "SETTLE_TID")
    private String terminalID;
    @Property(nameInDb = "SETTLE_BATCH_NO")
    private String batchNO;
    @Property(nameInDb = "SETTLE_DATE_TIME")
    private String dateTime;
    @Property(nameInDb = "SETTLE_CAHSIER_NO")
    private String cashierNO;


    /*  ======== currency is not RMB(international card) ===========*/
    @Property(nameInDb = "IS_BALANCED_NO_RMB")
    private boolean isBalanced;                 // if balanced(international card)

    @Property(nameInDb = "TOTAL_DEBIT_NUM_NO_RMB")
    private int totalDebitNum;                  // 总的借计笔数(international card)
    @Property(nameInDb = "TOTAL_DEBIT_AMOUNT_NO_RMB")
    private String totalDebitAmount;            // 总的借计金额(international card)
    @Property(nameInDb = "TOTAL_CREDIT_NUM_NO_RMB")
    private int totalCreditNum;                 // 总的贷计笔数(international card)
    @Property(nameInDb = "TOTAL_CREDIT_AMOUNT_NO_RMB")
    private String totalCreditAmount;           // 总的贷计金额(international card)

    @Property(nameInDb = "TOTAL_SALE_NUM_NO_RMB")
    private int totalSaleNum;                   //消费交易总笔数(不包括已撤销)(international card)
    @Property(nameInDb = "TOTAL_SALE_AMOUNT_NO_RMB")
    private String totalSaleAmount;             //消费交易总金额(不包括已撤销)(international card)

    @Property(nameInDb = "TOTAL_VOID_NUM_NO_RMB")
    private int totalVoidNum;                  //消费撤销交易总笔数(international card)
    @Property(nameInDb = "TOTAL_VOID_AMOUNT_NO_RMB")
    private String totalVoidAmount;            //消费撤销(international card)

    @Property(nameInDb = "TOTAL_REFUND_NUM_NO_RMB")
    private int totalRefundNum;                //退货交易总笔数(international card)
    @Property(nameInDb = "TOTAL_REFUND_AMOUNT_NO_RMB")
    private String totalRefundAmount;          //退货交易总额(international card)

    /*  ======== currency with RMB(domestic card) ===========*/
    @Property(nameInDb = "IS_BALANCED_RMB")
    private boolean isBalancedRMB;             // if balanced(domestic card)

    @Property(nameInDb = "TOTAL_DEBIT_NUM_RMB")
    private int totalDebitNumRMB;              // 总的借计笔数(domestic card)
    @Property(nameInDb = "TOTAL_DEBIT_AMOUNT_RMB")
    private String totalDebitAmountRMB;        // 总的借计金额(domestic card)
    @Property(nameInDb = "TOTAL_CREDIT_NUM_RMB")
    private int totalCreditNumRMB;             // 总的贷计笔数(domestic card)
    @Property(nameInDb = "TOTAL_CREDIT_AMOUNT_RMB")
    private String totalCreditAmountRMB;       // 总的贷计金额(domestic card)

    @Property(nameInDb = "TOTAL_SALE_NUM_RMB")
    private int totalSaleNumRMB;               //消费交易总笔数(不包括已撤销)(domestic card)
    @Property(nameInDb = "TOTAL_SALE_AMOUNT_RMB")
    private String totalSaleAmountRMB;         //消费交易总金额(不包括已撤销)(domestic card)

    @Property(nameInDb = "TOTAL_VOID_NUM_RMB")
    private int totalVoidNumRMB;               //消费撤销交易总笔数(domestic card)
    @Property(nameInDb = "TOTAL_VOID_AMOUNT_RMB")
    private String totalVoidAmountRMB;         //消费撤销(domestic card)

    @Property(nameInDb = "TOTAL_REFUND_NUM_RMB")
    private int totalRefundNumRMB;             //退货交易总笔数(domestic card)
    @Property(nameInDb = "TOTAL_REFUND_AMOUNT_RMB")
    private String totalRefundAmountRMB;       //退货交易总额(domestic card)




    @Property(nameInDb = "RFU_1")
    private String rfu1;            //Reserved
    @Property(nameInDb = "RFU_2")
    private String rfu2;            //Reserved
    @Property(nameInDb = "RFU_3")
    private String rfu3;            //Reserved
    @Generated(hash = 1323681531)
    public SettleInfoEntity(Long id, int batchStatus, int batchUploadTotal, int settleStatus, String merchantID,
            String terminalID, String batchNO, String dateTime, String cashierNO, boolean isBalanced,
            int totalDebitNum, String totalDebitAmount, int totalCreditNum, String totalCreditAmount,
            int totalSaleNum, String totalSaleAmount, int totalVoidNum, String totalVoidAmount,
            int totalRefundNum, String totalRefundAmount, boolean isBalancedRMB, int totalDebitNumRMB,
            String totalDebitAmountRMB, int totalCreditNumRMB, String totalCreditAmountRMB, int totalSaleNumRMB,
            String totalSaleAmountRMB, int totalVoidNumRMB, String totalVoidAmountRMB, int totalRefundNumRMB,
            String totalRefundAmountRMB, String rfu1, String rfu2, String rfu3) {
        this.id = id;
        this.batchStatus = batchStatus;
        this.batchUploadTotal = batchUploadTotal;
        this.settleStatus = settleStatus;
        this.merchantID = merchantID;
        this.terminalID = terminalID;
        this.batchNO = batchNO;
        this.dateTime = dateTime;
        this.cashierNO = cashierNO;
        this.isBalanced = isBalanced;
        this.totalDebitNum = totalDebitNum;
        this.totalDebitAmount = totalDebitAmount;
        this.totalCreditNum = totalCreditNum;
        this.totalCreditAmount = totalCreditAmount;
        this.totalSaleNum = totalSaleNum;
        this.totalSaleAmount = totalSaleAmount;
        this.totalVoidNum = totalVoidNum;
        this.totalVoidAmount = totalVoidAmount;
        this.totalRefundNum = totalRefundNum;
        this.totalRefundAmount = totalRefundAmount;
        this.isBalancedRMB = isBalancedRMB;
        this.totalDebitNumRMB = totalDebitNumRMB;
        this.totalDebitAmountRMB = totalDebitAmountRMB;
        this.totalCreditNumRMB = totalCreditNumRMB;
        this.totalCreditAmountRMB = totalCreditAmountRMB;
        this.totalSaleNumRMB = totalSaleNumRMB;
        this.totalSaleAmountRMB = totalSaleAmountRMB;
        this.totalVoidNumRMB = totalVoidNumRMB;
        this.totalVoidAmountRMB = totalVoidAmountRMB;
        this.totalRefundNumRMB = totalRefundNumRMB;
        this.totalRefundAmountRMB = totalRefundAmountRMB;
        this.rfu1 = rfu1;
        this.rfu2 = rfu2;
        this.rfu3 = rfu3;
    }
    @Generated(hash = 1022766188)
    public SettleInfoEntity() {
    }


    /**
     *  More customized getters and setters for user
     */
    public DataConstant.BatchStatus getBatchStatusEnum() {
        for (DataConstant.BatchStatus batchStatus : DataConstant.BatchStatus.values()){
            if(batchStatus.ordinal() == getBatchStatus()){
                return batchStatus;
            }
        }
        return null;
    }
    public void setBatchStatus(DataConstant.BatchStatus batchStatus) {
        this.batchStatus = batchStatus.ordinal();
    }

    public DataConstant.SettleStatus getSettleStatusEnum() {
        for (DataConstant.SettleStatus status : DataConstant.SettleStatus.values()){
            if(status.ordinal() == getSettleStatus()){
                return status;
            }
        }
        return null;
    }
    public void setSettleStatus(DataConstant.SettleStatus status) {
        this.settleStatus = status.ordinal();
    }

    /**
     *   end of customized getters and setters
     */

    public Long getId() {
        return this.id;
    }
    public void setId(Long id) {
        this.id = id;
    }
    public String getRfu1() {
        return this.rfu1;
    }
    public void setRfu1(String rfu1) {
        this.rfu1 = rfu1;
    }
    public String getRfu2() {
        return this.rfu2;
    }
    public void setRfu2(String rfu2) {
        this.rfu2 = rfu2;
    }
    public String getRfu3() {
        return this.rfu3;
    }
    public void setRfu3(String rfu3) {
        this.rfu3 = rfu3;
    }
    public int getSettleStatus() {
        return this.settleStatus;
    }
    public void setSettleStatus(int settleStatus) {
        this.settleStatus = settleStatus;
    }
    public String getMerchantID() {
        return this.merchantID;
    }
    public void setMerchantID(String merchantID) {
        this.merchantID = merchantID;
    }
    public String getTerminalID() {
        return this.terminalID;
    }
    public void setTerminalID(String terminalID) {
        this.terminalID = terminalID;
    }
    public String getBatchNO() {
        return this.batchNO;
    }
    public void setBatchNO(String batchNO) {
        this.batchNO = batchNO;
    }
    public String getDateTime() {
        return this.dateTime;
    }
    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }
    public String getCashierNO() {
        return this.cashierNO;
    }
    public void setCashierNO(String cashierNO) {
        this.cashierNO = cashierNO;
    }
    public int getBatchStatus() {
        return this.batchStatus;
    }
    public void setBatchStatus(int batchStatus) {
        this.batchStatus = batchStatus;
    }
    public int getBatchUploadTotal() {
        return this.batchUploadTotal;
    }
    public void setBatchUploadTotal(int batchUploadTotal) {
        this.batchUploadTotal = batchUploadTotal;
    }
    public boolean getIsBalanced() {
        return this.isBalanced;
    }
    public void setIsBalanced(boolean isBalanced) {
        this.isBalanced = isBalanced;
    }
    public int getTotalDebitNum() {
        return this.totalDebitNum;
    }
    public void setTotalDebitNum(int totalDebitNum) {
        this.totalDebitNum = totalDebitNum;
    }
    public String getTotalDebitAmount() {
        return this.totalDebitAmount;
    }
    public void setTotalDebitAmount(String totalDebitAmount) {
        this.totalDebitAmount = totalDebitAmount;
    }
    public int getTotalCreditNum() {
        return this.totalCreditNum;
    }
    public void setTotalCreditNum(int totalCreditNum) {
        this.totalCreditNum = totalCreditNum;
    }
    public String getTotalCreditAmount() {
        return this.totalCreditAmount;
    }
    public void setTotalCreditAmount(String totalCreditAmount) {
        this.totalCreditAmount = totalCreditAmount;
    }
    public int getTotalSaleNum() {
        return this.totalSaleNum;
    }
    public void setTotalSaleNum(int totalSaleNum) {
        this.totalSaleNum = totalSaleNum;
    }
    public String getTotalSaleAmount() {
        return this.totalSaleAmount;
    }
    public void setTotalSaleAmount(String totalSaleAmount) {
        this.totalSaleAmount = totalSaleAmount;
    }
    public int getTotalVoidNum() {
        return this.totalVoidNum;
    }
    public void setTotalVoidNum(int totalVoidNum) {
        this.totalVoidNum = totalVoidNum;
    }
    public String getTotalVoidAmount() {
        return this.totalVoidAmount;
    }
    public void setTotalVoidAmount(String totalVoidAmount) {
        this.totalVoidAmount = totalVoidAmount;
    }
    public int getTotalRefundNum() {
        return this.totalRefundNum;
    }
    public void setTotalRefundNum(int totalRefundNum) {
        this.totalRefundNum = totalRefundNum;
    }
    public String getTotalRefundAmount() {
        return this.totalRefundAmount;
    }
    public void setTotalRefundAmount(String totalRefundAmount) {
        this.totalRefundAmount = totalRefundAmount;
    }
    public boolean getIsBalancedRMB() {
        return this.isBalancedRMB;
    }
    public void setIsBalancedRMB(boolean isBalancedRMB) {
        this.isBalancedRMB = isBalancedRMB;
    }
    public int getTotalDebitNumRMB() {
        return this.totalDebitNumRMB;
    }
    public void setTotalDebitNumRMB(int totalDebitNumRMB) {
        this.totalDebitNumRMB = totalDebitNumRMB;
    }
    public String getTotalDebitAmountRMB() {
        return this.totalDebitAmountRMB;
    }
    public void setTotalDebitAmountRMB(String totalDebitAmountRMB) {
        this.totalDebitAmountRMB = totalDebitAmountRMB;
    }
    public int getTotalCreditNumRMB() {
        return this.totalCreditNumRMB;
    }
    public void setTotalCreditNumRMB(int totalCreditNumRMB) {
        this.totalCreditNumRMB = totalCreditNumRMB;
    }
    public String getTotalCreditAmountRMB() {
        return this.totalCreditAmountRMB;
    }
    public void setTotalCreditAmountRMB(String totalCreditAmountRMB) {
        this.totalCreditAmountRMB = totalCreditAmountRMB;
    }
    public int getTotalSaleNumRMB() {
        return this.totalSaleNumRMB;
    }
    public void setTotalSaleNumRMB(int totalSaleNumRMB) {
        this.totalSaleNumRMB = totalSaleNumRMB;
    }
    public String getTotalSaleAmountRMB() {
        return this.totalSaleAmountRMB;
    }
    public void setTotalSaleAmountRMB(String totalSaleAmountRMB) {
        this.totalSaleAmountRMB = totalSaleAmountRMB;
    }
    public int getTotalVoidNumRMB() {
        return this.totalVoidNumRMB;
    }
    public void setTotalVoidNumRMB(int totalVoidNumRMB) {
        this.totalVoidNumRMB = totalVoidNumRMB;
    }
    public String getTotalVoidAmountRMB() {
        return this.totalVoidAmountRMB;
    }
    public void setTotalVoidAmountRMB(String totalVoidAmountRMB) {
        this.totalVoidAmountRMB = totalVoidAmountRMB;
    }
    public int getTotalRefundNumRMB() {
        return this.totalRefundNumRMB;
    }
    public void setTotalRefundNumRMB(int totalRefundNumRMB) {
        this.totalRefundNumRMB = totalRefundNumRMB;
    }
    public String getTotalRefundAmountRMB() {
        return this.totalRefundAmountRMB;
    }
    public void setTotalRefundAmountRMB(String totalRefundAmountRMB) {
        this.totalRefundAmountRMB = totalRefundAmountRMB;
    }

}
