package cn.nexgo.inbas.components.data.bean;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.NotNull;
import org.greenrobot.greendao.annotation.Property;
import org.greenrobot.greendao.annotation.Generated;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * File Name     : OperatorEntity.java
 * Usage         : Entity for an Operator Entity
 * Version       : 1
 * Author        : Brad
 * Date          : 2017/12/12 
 * Modification  : Created file

 **************************************************************************************************/
@Entity(
    nameInDb = "OPERATOR_TABLE",   // Table Name
    createInDb = true,             // if create a tablE
    generateConstructors = true,   // if generate constructors.
    generateGettersSetters = true  // If generate getters and setters' methods
)
public class OperatorEntity {
    @Id(autoincrement = true)
    private Long id;                            // Unique id for each record

    @NotNull
    @Property(nameInDb = "OPERATOR_NO")
    private String operatorNo;                  // Operator NO.
    @NotNull
    @Property(nameInDb = "PASSWORD")
    private String password;                    // Operator password

    @Property(nameInDb = "RFU_1")
    private String rfu1;
    @Property(nameInDb = "RFU_2")
    private String rfu2;
    @Property(nameInDb = "RFU_3")
    private String rfu3;
    @Generated(hash = 990223058)
    public OperatorEntity(Long id, @NotNull String operatorNo, @NotNull String password, String rfu1,
            String rfu2, String rfu3) {
        this.id = id;
        this.operatorNo = operatorNo;
        this.password = password;
        this.rfu1 = rfu1;
        this.rfu2 = rfu2;
        this.rfu3 = rfu3;
    }
    @Generated(hash = 1676063986)
    public OperatorEntity() {
    }
    public Long getId() {
        return this.id;
    }
    public void setId(Long id) {
        this.id = id;
    }
    public String getOperatorNo() {
        return this.operatorNo;
    }
    public void setOperatorNo(String operatorNo) {
        this.operatorNo = operatorNo;
    }
    public String getPassword() {
        return this.password;
    }
    public void setPassword(String password) {
        this.password = password;
    }
    public String getRfu1() {
        return this.rfu1;
    }
    public void setRfu1(String rfu1) {
        this.rfu1 = rfu1;
    }
    public String getRfu2() {
        return this.rfu2;
    }
    public void setRfu2(String rfu2) {
        this.rfu2 = rfu2;
    }
    public String getRfu3() {
        return this.rfu3;
    }
    public void setRfu3(String rfu3) {
        this.rfu3 = rfu3;
    }


}
