package cn.nexgo.inbas.components.commu.socket.factory;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2017/12/10
 * Modify          : create file
 **************************************************************************************************/
public class Socket implements ISocket {
    private java.net.Socket mSocket;
    private Logger log = LoggerFactory.getLogger(Socket.class.getSimpleName());

    @Override
    public void close() {
        if (!isConnect()) {
            return;
        }
        try {
            mSocket.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String ip;
    private String port;
    private InputStream inStream = null;
    private DataOutputStream output = null;

    @Override
    public boolean socket(String ip, String port, int timeout) {

        if (ip.equals(this.ip) && (port.equals(this.port)) && isConnect() && mSocket != null && !mSocket.isClosed()) {  // if has connected & ip port is same
            return true;
        } else {
            close();
        }

        this.ip = ip;
        this.port = port;

        SocketAddress sa = new InetSocketAddress(this.ip, Integer.parseInt(this.port));
        log.debug("connect address:{}", sa.toString());
        mSocket = new java.net.Socket();

        try {   //  set connect params
            mSocket.setSoTimeout(timeout);
            mSocket.setTcpNoDelay(true);
        } catch (SocketException e) {
            e.printStackTrace();
            return false;
        }
        try {  // connect
            mSocket.connect(sa, timeout);
        } catch (IOException e) {
            e.printStackTrace();
            return false;
        }

        try {  // get stream
            output = new DataOutputStream(mSocket.getOutputStream());
            inStream = mSocket.getInputStream();
        } catch (IOException e) {
            e.printStackTrace();
            close();
            return false;
        }
        return true;
    }

    @Override
    public boolean sendDatas(byte[] sendDatas, int timeout) {
        if (!isConnect()) {
            return false;
        }

        try {
            output.write(sendDatas);
            output.flush();
        } catch (IOException e) {
            e.printStackTrace();
            close();
            return false;
        }

        return true;
    }

    @Override
    public int readDatas(byte b[], int off, int len, int timeout) {
        if (!isConnect()) {
            return -1;
        }

        int realReadLen = 0;
        try {
            realReadLen = inStream.read(b, off, len);
        } catch (IOException e) {
            e.printStackTrace();
            close();
//            return -1;
        }

        return realReadLen;
    }

    @Override
    public boolean isConnect() {
        return !((mSocket == null) || (!mSocket.isConnected()) || mSocket.isClosed());
    }
}
