package cn.nexgo.inbas.components.commu.bean;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2017/12/9
 * Modify          : create file
 **************************************************************************************************/
public class CommuObject {

    public interface CommonResultListener{
        void onSuccess();
        void onFail(ErrorCode error);
    }

    public interface StatusListener{
        void onStatus(Status status);
    }

    public interface RecvDataListener{
        void onGetData(byte[] data);
        void onFail(ErrorCode error);
    }

    public interface UnZipDataAction{
        byte[] getRealData(byte[] recvData);

        ErrorCode getErrorCode();
    }

    public interface TransListener{
        void onConnectError(ErrorCode errorCode);
        void onConnectSuccess();
        void onSendError(ErrorCode errorCode);
        void onSendSuccess();
        void onReceiveError(ErrorCode errorCode);
        void onReceiveSuccess(byte[] data);
//        void onFinish();
        void onCancel();
    }

    public enum Status{
        CONNECTTING,
        CONNECTED,
        DISCONNECTNIG,
        DISCONNECTED,
    }

    public static class ErrorCode{
        private int code;
        private String msg;

        public ErrorCode(){

        }

        public ErrorCode(int code, String msg){
            this.code = code;
            this.msg = msg;
        }

        public int getCode() {
            return code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMsg() {
            return msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }
}
