package cn.nexgo.inbas.components.commu;


import android.support.annotation.NonNull;

import cn.nexgo.inbas.components.commu.bean.CommuObject;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2017/12/9
 * Modify          : create file
 **************************************************************************************************/
public interface ICommu {
    /**
     * init
     * @param initData
     * @param timeout
     * @param listener
     */
    void init(Object initData, int timeout, CommuObject.CommonResultListener listener);

    /**
     * startListenStatus
     * @param listener
     */
    void startListenStatus(CommuObject.StatusListener listener);

    /**
     * stopListenStatus
     */
    void stopListenStatus();

    /**
     * connect
     * @param connectData
     * @param timeout
     * @param listener
     */
    void connect(Object connectData, int timeout, CommuObject.CommonResultListener listener);

    /**
     * disconnect
     * @param timeout
     * @param listener
     */
    void disconnect(int timeout, CommuObject.CommonResultListener listener);

    /**
     * getConnectStatus
     * @return
     */
    @NonNull
    CommuObject.Status getConnectStatus();

    /**
     * sendData
     * @param data
     * @param timeout
     * @param listener
     */
    void sendData(byte[] data, int timeout, CommuObject.CommonResultListener listener);

    /**
     * startRecData
     * @param timeout
     * @param listener
     */
    void startRecData(int timeout, CommuObject.RecvDataListener listener);

    /**
     * stopRecData
     */
    void stopRecData();

    /**
     * exchangeMsg
     * @param connectData
     * @param sendData
     * @param disconnectAfterRecv
     * @param unzipAction
     * @param timeout
     * @param listener
     * @return
     */
    int exchangeMsg(Object connectData, byte[] sendData, boolean disconnectAfterRecv, CommuObject.UnZipDataAction unzipAction, int timeout, CommuObject.TransListener listener);

    /**
     * cancelExchangeMsg
     * @param id
     */
    void cancelExchangeMsg(int id);

    void enDebug(boolean enable);
}
