package cn.nexgo.inbas.common.widget.keyboard;

import android.content.Context;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;

/**
 * Created by Kol(Fang Qiang) on 2017/8/2.
 * usage:
 */

public class NumStrKeyBoard extends NumKeyBoard {
    private Context context;

    public NumStrKeyBoard(@NonNull Context context) {
        super(context);
        init(context);
    }

    public NumStrKeyBoard(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public NumStrKeyBoard(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private void init(Context context) {
        this.context = context;

        super.setCallback(_callback);

        keyboardConfirm.setEnabled(false);
        keyboard00.setVisibility(View.INVISIBLE);
    }

    private StringBuilder sb = new StringBuilder();

    // 设置初始值
    public void setDefaultValue(String value) {
        sb = new StringBuilder();
        appendStr(value);
    }

    private void appendStr(String value){
        sb.append(value);
        btnEnableLogic();
    }

    private void btnEnableLogic(){
//        if(sb.length() >= maxLen){
//            keyboard1.setEnabled(false);
//            keyboard2.setEnabled(false);
//            keyboard3.setEnabled(false);
//            keyboard4.setEnabled(false);
//            keyboard5.setEnabled(false);
//            keyboard6.setEnabled(false);
//            keyboard7.setEnabled(false);
//            keyboard8.setEnabled(false);
//            keyboard9.setEnabled(false);
//            keyboard0.setEnabled(false);
//            keyboard00.setEnabled(false);
//        }else{
//            keyboard1.setEnabled(true);
//            keyboard2.setEnabled(true);
//            keyboard3.setEnabled(true);
//            keyboard4.setEnabled(true);
//            keyboard5.setEnabled(true);
//            keyboard6.setEnabled(true);
//            keyboard7.setEnabled(true);
//            keyboard8.setEnabled(true);
//            keyboard9.setEnabled(true);
//            keyboard0.setEnabled(true);
//            keyboard00.setEnabled(true);
//        }

        if(sb.length() < minLen){
            keyboardConfirm.setEnabled(false);
        }else{
            keyboardConfirm.setEnabled(true);
        }

        if(sb.length() == 0){
            keyboardBackspace.setEnabled(false);
            keyboardClear.setEnabled(false);
        }else{
            keyboardBackspace.setEnabled(true);
            keyboardClear.setEnabled(true);
        }
    }

    // 设置最大值
    private int maxLen = Integer.MAX_VALUE;
    private int minLen = 0;

    public void setMaxLen(int maxLen) {
        this.maxLen = maxLen;
    }

    public void setMinLen(int minLen) {
        this.minLen = minLen;
    }

    // 获取结果
    public String getRet() {
        return sb.toString();
    }

    private Callback _callback = new Callback() {
        @Override
        public void onKey(KEY_TYPE keyType) {
            if(callback == null){
                return;
            }
            switch (keyType) {
                case KEY_0:
                case KEY_1:
                case KEY_2:
                case KEY_3:
                case KEY_4:
                case KEY_5:
                case KEY_6:
                case KEY_7:
                case KEY_8:
                case KEY_9:
                    if(sb.length() < maxLen){
                        appendStr(keyType.getKeyValue());
                    }
                    break;
                case KEY_BACKSPACE:
                    if(sb.length() == 0){
                        return;
                    }
                    sb.deleteCharAt(sb.length()-1);
                    btnEnableLogic();
                    break;
                case KEY_CLEAR:
                    sb = new StringBuilder();
                    btnEnableLogic();
                    break;
            }

            callback.onKey(keyType);
        }
    };

    // 设置回调
    private Callback callback;

    @Override
    public void setCallback(Callback callback) {
        this.callback = callback;
    }
}
