package cn.nexgo.inbas.common.widget.creditcarddesign.pager;

import android.os.Bundle;
import android.text.Editable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;

import cn.nexgo.inbas.R;
import cn.nexgo.utils.FormatUtils;

import static cn.nexgo.inbas.common.widget.creditcarddesign.CreditCardUtils.EXTRA_CARD_NUMBER;


/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           :
 * Version         : 1
 * Author          : zhouxie
 * Date            : 2018/1/28
 * Modify          : create file
 **************************************************************************************************/

public class CardNumberFragment extends CreditCardFragment {
    public static final int MAX_CARDNUM_LENGTH = 19;
    public static final int MIN_CARDNUM_LENGTH = 13;
    EditText mCardNumberView;

    public CardNumberFragment() {
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup group, Bundle state) {
        View v = inflater.inflate(R.layout.input_lyt_card_number, group, false);
        mCardNumberView = v.findViewById(R.id.card_number_field);

        String number = "";

        if (getArguments() != null && getArguments().containsKey(EXTRA_CARD_NUMBER)) {
            number = getArguments().getString(EXTRA_CARD_NUMBER);
        }

        if (number == null) {
            number = "";
        }

        mCardNumberView.setText(number);
        mCardNumberView.addTextChangedListener(this);

        return v;
    }

    @Override
    public void afterTextChanged(Editable s) {
        int cursorPosition = mCardNumberView.getSelectionEnd();
        int previousLength = mCardNumberView.getText().length();

        String cardNumber = FormatUtils.formatCardNo(s.toString());
        int modifiedLength = cardNumber.length();

        mCardNumberView.removeTextChangedListener(this);
        mCardNumberView.setText(cardNumber);
        mCardNumberView.addTextChangedListener(this);

        if (modifiedLength <= previousLength && cursorPosition < modifiedLength) {
            mCardNumberView.setSelection(cursorPosition);
        }

        onEdit(cardNumber);
//        if (s.length() == MAX_CARDNUM_LENGTH) {
//            onComplete();
//        }
    }

    @Override
    public void focus() {
        if (isAdded()) {
            mCardNumberView.selectAll();
        }
    }

    @Override
    public void edit(String edit) {
        mCardNumberView.setText(edit);
    }
}
