package cn.nexgo.inbas.common.widget.creditcarddesign.pager;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           :
 * Version         : 1
 * Author          : zhouxie
 * Date            : 2018/1/28
 * Modify          : create file
 **************************************************************************************************/

public class CardFragmentAdapter extends FragmentStatePagerAdapter implements IActionListener {

    public void focus(int position) {
        getItem(position).focus();
    }

    public interface ICardEntryCompleteListener {
        void onCardEntryComplete(int currentIndex);

        void onCardEntryEdit(int currentIndex, String entryValue);
    }

    private final CardNumberFragment mCardNumberFragment;
    private final CardExpiryFragment mCardExpiryFragment;

    private ICardEntryCompleteListener mCardEntryCompleteListener;

    public CardFragmentAdapter(FragmentManager fm, Bundle args) {
        super(fm);

        mCardNumberFragment = new CardNumberFragment();
        mCardNumberFragment.setArguments(args);

        mCardExpiryFragment = new CardExpiryFragment();
        mCardExpiryFragment.setArguments(args);

        mCardNumberFragment.setActionListener(this);
        mCardExpiryFragment.setActionListener(this);
    }

    public void setOnCardEntryCompleteListener(ICardEntryCompleteListener listener) {
        this.mCardEntryCompleteListener = listener;
    }

    @Override
    public CreditCardFragment getItem(int position) {
        return new CreditCardFragment[]{mCardNumberFragment, mCardExpiryFragment}[position];
    }

    @Override
    public int getCount() {
        return 2;
    }


    @Override
    public void onActionComplete(CreditCardFragment fragment) {
        int index = getIndex(fragment);
        if (index >= 0 && mCardEntryCompleteListener != null) {
            mCardEntryCompleteListener.onCardEntryComplete(index);
        }
    }

    public int getIndex(CreditCardFragment fragment) {
        int index = -1;
        if (fragment == mCardNumberFragment) {
            index = 0;
        } else if (fragment == mCardExpiryFragment) {
            index = 1;
        }

        return index;
    }

    @Override
    public void onEdit(CreditCardFragment fragment, String edit) {
        int index = getIndex(fragment);

        if (index >= 0 && mCardEntryCompleteListener != null) {
            mCardEntryCompleteListener.onCardEntryEdit(index, edit);
        }
    }

    @Override
    public void restoreState(Parcelable parcelable, ClassLoader classLoader) {

    }
}
