package cn.nexgo.inbas.common.widget.creditcarddesign;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.TextView;

import cn.nexgo.inbas.R;
import cn.nexgo.utils.FormatUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           :
 * Version         : 1
 * Author          : zhouxie
 * Date            : 2018/1/28
 * Modify          : create file
 **************************************************************************************************/

public class CreditCardView extends FrameLayout {

    private int mCurrentDrawable;
    private String mRawCardNumber;

    private String mCardHolderName, mExpiry;

    int mCardnameLen;

    public CreditCardView(Context context) {
        super(context);
        init();
    }

    public CreditCardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(attrs);
    }

    public CreditCardView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(attrs);
    }

    public String getCardHolderName() {
        return mCardHolderName;
    }

    public String getExpiry() {
        return mExpiry;
    }

    interface ICustomCardSelector {
        CardSelector getCardSelector(String cardNumber);
    }

    private void init() {

        mCurrentDrawable = R.drawable.card_color_round_rect_default;
        mRawCardNumber = "";
        mCardnameLen = getResources().getInteger(R.integer.card_name_len);
        LayoutInflater inflater = (LayoutInflater) getContext()
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        //noinspection ConstantConditions
        inflater.inflate(R.layout.widget_creditcard_view, this, true);

    }

    private void init(AttributeSet attrs) {

        init();

        TypedArray a = getContext().obtainStyledAttributes(attrs,
                R.styleable.creditcard, 0, 0);

        String expiry = a.getString(R.styleable.creditcard_card_expiration);
        String cardNumber = a.getString(R.styleable.creditcard_card_number);

        int cvv = a.getInt(R.styleable.creditcard_cvv, 0);
        int cardSide = a.getInt(R.styleable.creditcard_card_side, CreditCardUtils.CARD_SIDE_FRONT);

        setCardNumber(cardNumber);
        setCardExpiry(expiry);

        if (cardSide == CreditCardUtils.CARD_SIDE_BACK) {
            showBackImmediate();
        }

        paintCard();

        a.recycle();

    }


    private void flip(final boolean ltr, boolean isImmediate) {

        View layoutContainer = findViewById(R.id.card_outline_container);
        View frontView = findViewById(R.id.front_card_outline);
        View backView = findViewById(R.id.back_card_outline);

        final View frontContentView = findViewById(R.id.front_card_container);
        final View backContentView = findViewById(R.id.back_card_container);
        View layoutContentContainer = findViewById(R.id.card_container);


        if (isImmediate) {
            frontContentView.setVisibility(ltr ? VISIBLE : GONE);
            backContentView.setVisibility(ltr ? GONE : VISIBLE);

        } else {

            int duration = 600;

            FlipAnimator flipAnimator = new FlipAnimator(frontView, backView, frontView.getWidth() / 2, backView.getHeight() / 2);
            flipAnimator.setInterpolator(new OvershootInterpolator(0.5f));
            flipAnimator.setDuration(duration);

            if (ltr) {
                flipAnimator.reverse();
            }

            flipAnimator.setTranslateDirection(FlipAnimator.DIRECTION_Z);
            flipAnimator.setRotationDirection(FlipAnimator.DIRECTION_Y);
            layoutContainer.startAnimation(flipAnimator);

            FlipAnimator flipAnimator1 = new FlipAnimator(frontContentView, backContentView, frontContentView.getWidth() / 2, backContentView.getHeight() / 2);
            flipAnimator1.setInterpolator(new OvershootInterpolator(0.5f));
            flipAnimator1.setDuration(duration);

            if (ltr) {
                flipAnimator1.reverse();
            }

            flipAnimator1.setTranslateDirection(FlipAnimator.DIRECTION_Z);
            flipAnimator1.setRotationDirection(FlipAnimator.DIRECTION_Y);

            layoutContentContainer.startAnimation(flipAnimator1);
        }

    }

    public void setCardNumber(String rawCardNumber) {

        this.mRawCardNumber = rawCardNumber == null ? "" : rawCardNumber;
        String cardNumber = FormatUtils.formatCardNo(this.mRawCardNumber);

        ((TextView) findViewById(R.id.front_card_number)).setText(cardNumber);

        paintCard();
    }


    public void showFront() {
        flip(true, false);
    }

    public void showFrontImmediate() {
        flip(true, true);
    }

    public void showBack() {
        flip(false, false);
    }

    public void showBackImmediate() {
        flip(false, true);
    }

    public void setCardExpiry(String dateYear) {

        dateYear = dateYear == null ? "" : dateYear;

        this.mExpiry = dateYear;

        ((TextView) findViewById(R.id.front_card_expiry)).setText(dateYear);
    }

    public void setCardHolderName(String cardHolderName) {

        cardHolderName = cardHolderName == null ? "" : cardHolderName;
        if (cardHolderName.length() > mCardnameLen) {
            cardHolderName = cardHolderName.substring(0, mCardnameLen);
        }

        this.mCardHolderName = cardHolderName;

        ((TextView) findViewById(R.id.front_card_holder_name)).setText(cardHolderName);
    }

    public void paintCard() {

        CardSelector card = CardSelector.getDefaultCard();

        View chipContainer = findViewById(R.id.chip_container);
        View chipInner = findViewById(R.id.chip_inner_view);

        View cardBack = findViewById(R.id.back_card_outline);
        View cardFront = findViewById(R.id.front_card_outline);

        chipContainer.setBackgroundResource(card.getResChipOuterId());
        chipInner.setBackgroundResource(card.getResChipInnerId());


        cardBack.setBackgroundResource(card.getResCardId());
        cardFront.setBackgroundResource(card.getResCardId());
    }


    public void revealCardAnimation() {

        CardSelector card = CardSelector.getDefaultCard();

        View cardFront = findViewById(R.id.front_card_outline);
        View cardContainer = findViewById(R.id.card_outline_container);

        paintCard();

        animateChange(cardContainer, cardFront, card.getResCardId());
    }

    public void animateChange(final View cardContainer, final View v, final int drawableId) {
        showAnimation(cardContainer, v, drawableId);
    }

    public void showAnimation(final View cardContainer, final View v, final int drawableId) {

        final View mRevealView = v;
        mRevealView.setBackgroundResource(drawableId);

        if (mCurrentDrawable == drawableId) {
            return;
        }

        int duration = 1000;
        int cx = mRevealView.getLeft();
        int cy = mRevealView.getTop();

        int radius = Math.max(mRevealView.getWidth(), mRevealView.getHeight()) * 4;

        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {

            Animator animator =
                    ViewAnimationUtils.createCircularReveal(mRevealView, cx, cy, 0, radius);
            animator.setInterpolator(new AccelerateDecelerateInterpolator());
            animator.setDuration(duration);

            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    cardContainer.setBackgroundResource(drawableId);
                }
            }, duration);

            mRevealView.setVisibility(View.VISIBLE);
            animator.start();
            mCurrentDrawable = drawableId;

        } else {
            Animator anim = android.view.ViewAnimationUtils.createCircularReveal(mRevealView, cx, cy, 0, radius);
            mRevealView.setVisibility(View.VISIBLE);
            anim.setDuration(duration);
            anim.start();
            anim.addListener(new AnimatorListenerAdapter() {
                @Override
                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);

                    cardContainer.setBackgroundResource(drawableId);
                }
            });

            mCurrentDrawable = drawableId;
        }
    }

    public String getCardNumber() {
        return mRawCardNumber;
    }

}
