package cn.nexgo.inbas.common.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

import cn.nexgo.inbas.R;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2018/2/1
 * Modify          : create file
 **************************************************************************************************/
public class ToolBar extends FrameLayout{
    public ToolBar(@NonNull Context context) {
        super(context);

        init(context);
    }

    public ToolBar(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public ToolBar(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    public ToolBar(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init(context);
    }

    private FrameLayout flBack;
    private TextView tvTitle;
    private TextView tvRightlab;
    private void init(Context context){
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        //noinspection ConstantConditions
        inflater.inflate(R.layout.widget_toolbar, this);

        flBack = findViewById(R.id.flBack);
        tvTitle = findViewById(R.id.tv_title);
        tvRightlab = findViewById(R.id.tv_rightlab);
    }

    public void showBackBtn(boolean enable){
        if(enable){
            flBack.setVisibility(View.VISIBLE);
        }else{
            flBack.setVisibility(View.GONE);
        }
    }

    public void showRightlab(boolean enable){
        if(enable){
            tvRightlab.setVisibility(View.VISIBLE);
        }else{
            tvRightlab.setVisibility(View.GONE);
        }
    }

    public void setTitle(String title){
        tvTitle.setText(title);
    }

    public void setRightlab(String rightlab){
        tvRightlab.setText(rightlab);
    }

    public void setBackOnclickListener(OnClickListener onclickListener){
        flBack.setOnClickListener(onclickListener);
    }
}
