package cn.nexgo.inbas.common.widget;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;

import cn.nexgo.inbas.R;
import cn.nexgo.inbas.common.GData;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : ruandong
 * Date            : 2018/1/17
 * Modify          : create file
 **************************************************************************************************/
public class LoadingDialog extends Dialog {

    private TextView titleTv;
    private TextView messageTv;
    private String titleStr;
    private String messageStr;
    private TextView countDownTv;
    private MyDownTimer mDownTimer; //倒计时

    public LoadingDialog(Context context) {
        super(context, R.style.loading_dialog);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.widget_loading_dialog);
        //set CanceledOnTouchOutside
        setCanceledOnTouchOutside(false);
        setCancelable(false);

        initView();
        initData();
        //modify by lee on 2018/12/04   add down timer
        mDownTimer = new MyDownTimer(GData.getInstance().getSetupEntity().getCommuConnectTimeout() * 1000);
        mDownTimer.start();
    }

    @Override
    public void dismiss() {
        super.dismiss();
        if (mDownTimer != null) mDownTimer.cancel();
    }

    private void initData() {

        if (titleStr != null) {
            titleTv.setText(titleStr);
        }
        if (messageStr != null) {
            messageTv.setText(messageStr);
        }

    }

    private void initView() {

        titleTv = findViewById(R.id.tv_title);
        messageTv = findViewById(R.id.tv_msg);
        countDownTv = findViewById(R.id.tv_countdown);

        ImageView spaceshipImage = findViewById(R.id.img_loading);
        Animation hyperspaceJumpAnimation = AnimationUtils.loadAnimation(
                getContext(), R.anim.loading_animation);
        spaceshipImage.startAnimation(hyperspaceJumpAnimation);

    }


    public void setTitle(String title) {
        titleStr = title;
        if (titleTv != null) {
            titleTv.setText(titleStr);
            if (mDownTimer != null) {
                mDownTimer.cancel();
                mDownTimer.start();
            }
        }
    }


    public void setMessage(String message) {
        messageStr = message;
        if (messageTv != null) {
            messageTv.setText(messageStr);
        }
    }

    /**
     * 倒计时
     */
    class MyDownTimer extends CountDownTimer {

        MyDownTimer(long millisInFuture) {
            super(millisInFuture, 1000);
        }

        @Override
        public void onTick(long millisUntilFinished) {
            String txt = millisUntilFinished / 1000 + "";
            countDownTv.setText(txt);
        }

        @Override
        public void onFinish() {
            String txt = "0";
            countDownTv.setText(txt);
//            dismiss();
            if(mDownTimer != null){
                mDownTimer.start();
            }
        }
    }

}

