package cn.nexgo.inbas.common.widget;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.text.InputFilter;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import cn.nexgo.inbas.R;
import cn.nexgo.inbas.common.widget.autofittext.AutoFitTextView;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : ruandong
 * Date            : 2018/1/17
 * Modify          : create file
 **************************************************************************************************/
public class EditSettingsDialog extends Dialog {

    private AutoFitTextView tvTitle;
    private String titleStr;
    private OnBackClickListener onBackClickListener;
    private OnOkClickListener onOkClickListener;

    private EditText etInputContent;
    private TextView tvErrormsg;
    private Button btnOk;
    private ImageView ivCancel;
    private String defaultValue = "";

    private InputType isInputTypeNumber;

    private int maxLen = -1;
    private int minLen = -1;

    private long minValue = 0;
    private long maxValue = -1;

    public EditSettingsDialog(Context context, InputType isInputTypeNumber, int minLen, int maxLen) {
        super(context, R.style.add_dialog);
        this.isInputTypeNumber = isInputTypeNumber;
        this.minLen = minLen;
        this.maxLen = maxLen;
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }

    public void setDefaultValue(String defaultValue){
        this.defaultValue = defaultValue;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.widget_edit_dialog);
        //set CanceledOnTouchOutside
        setCanceledOnTouchOutside(true);

        initView();
        initData();
        initEvent();

        //noinspection ConstantConditions
        getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_VISIBLE);
    }

    /**
     * init back click event
     */
    private void initEvent() {

        ivCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                if (onBackClickListener != null) {
                    onBackClickListener.onBackClick();
                }
            }
        });

        btnOk.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                if((etInputContent.getText().length() < minLen) || (etInputContent.getText().length() > maxLen)){
                    tvErrormsg.setVisibility(View.VISIBLE);
                    return;
                }

                if((minValue <= maxValue) && (isInputTypeNumber == InputType.NUM)){
                    String tmp = etInputContent.getText().toString();

                    if(tmp.length() == 0){
                        tvErrormsg.setVisibility(View.VISIBLE);
                        return;
                    }
                    long tmpLong = Long.parseLong(tmp);
                    if((tmpLong < minValue) || (tmpLong > maxValue)){
                        tvErrormsg.setVisibility(View.VISIBLE);
                        return;
                    }
                }
                if (onOkClickListener != null) {
                    onOkClickListener.onOkClick();
                }
            }
        });

    }

    private void initData() {

        if (titleStr != null) {
            if(maxValue >= minValue){
                tvTitle.setText(titleStr+"("+minValue+"-"+maxValue+")");
            }else{
                tvTitle.setText(titleStr);
            }
        }

    }

    private void initView() {

        tvTitle = findViewById(R.id.tv_title);
        btnOk = findViewById(R.id.btn_ok);
        ivCancel = findViewById(R.id.iv_cancel);
        tvErrormsg = findViewById(R.id.tv_errormsg);

        switch (isInputTypeNumber){
            case IP:
                etInputContent = findViewById(R.id.et_ip);
                break;
            case NUM:
                etInputContent = findViewById(R.id.et_num);
                break;
            default:
                etInputContent = findViewById(R.id.et_str);
                break;
        }

        if(maxLen > 0){
            InputFilter[] filters = {new InputFilter.LengthFilter(maxLen)};
            etInputContent.setFilters(filters);
        }
        etInputContent.setVisibility(View.VISIBLE);

        etInputContent.setText(defaultValue);
        etInputContent.setSelection(defaultValue.length());
    }

    public void setTitle(String title) {
        titleStr = title;
    }


    public String getLine2text() {
        return etInputContent.getText().toString();
    }

    public void setOnBackClickListener(OnBackClickListener onBackclicListener) {

        this.onBackClickListener = onBackclicListener;
    }

    public interface OnBackClickListener {
        void onBackClick();
    }

    public void setOnOkClickListener(OnOkClickListener onOkclicListener) {

        this.onOkClickListener = onOkclicListener;
    }

    public interface OnOkClickListener {
        void onOkClick();
    }

    public enum InputType{
        NUM, STR, IP
    }
}