package cn.nexgo.inbas.common.widget;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.provider.Settings;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;

import cn.nexgo.inbas.R;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 继续打印提示框 Continue Print Dialog
 * Version         : 1
 * Author          : lee
 * Date            : 2018/11/22
 * Modify          : create file
 **************************************************************************************************/
public class ContinuePrintDialog extends Dialog {

    private OnContinueListener onContinueListener;
    private Button btnOk;
    private ImageView ivCancel;
    private Context mContext;
    private MyDownTimer mDownTimer; //倒计时

    public ContinuePrintDialog(Context context) {
        super(context, R.style.add_dialog);
        mContext = context;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.widget_continue_print_dialog);
        setCanceledOnTouchOutside(false);
        setCancelable(false);

        //keep screen on
        Window win = ((Activity)mContext).getWindow();
        win.setFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON, WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
//        //close menu
        win.addFlags(5);
//        //close home
        win.addFlags(3);
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {//当系统版本是5.1.1时，可以使用Settings
            //close pull down window
            Settings.System.putInt(getContext().getContentResolver(), "status_bar_disabled", 1);
        }
        initView();
        initEvent();
        mDownTimer = new MyDownTimer(60 * 1000);//默认30秒
        mDownTimer.start();
    }

    @Override
    public void dismiss() {
        super.dismiss();
        if (mDownTimer != null) mDownTimer.cancel();
    }

    /**
     * init back click event
     */
    private void initEvent() {
        ivCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                if (onContinueListener != null) {
                    onContinueListener.onCancel();
                }
                if (mDownTimer != null) mDownTimer.cancel();
            }
        });

        btnOk.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dismiss();
                if (onContinueListener != null) {
                    onContinueListener.onConfirm();
                }
                if (mDownTimer != null) mDownTimer.cancel();
            }
        });

    }

    private void initView() {
        btnOk = findViewById(R.id.btn_ok);
        ivCancel = findViewById(R.id.iv_cancel);
    }

    public void setOnContinueListener(OnContinueListener onClickListener) {
        this.onContinueListener = onClickListener;
    }

    public interface OnContinueListener {
        void onConfirm();

        void onCancel();
    }

    /**
     * 倒计时
     */
    class MyDownTimer extends CountDownTimer {

        public MyDownTimer(long millisInFuture) {
            super(millisInFuture, 1000);
        }

        @Override
        public void onTick(long millisUntilFinished) {
            String txt = mContext.getString(R.string.ok) + "（" + millisUntilFinished / 1000 + "）";
            btnOk.setText(txt);
        }

        @Override
        public void onFinish() {
            String txt = mContext.getString(R.string.ok) + "（0）";
            btnOk.setText(txt);
            dismiss();
            if (onContinueListener != null) {
                onContinueListener.onConfirm();
            }
        }
    }
}