package cn.nexgo.inbas.common.widget;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import cn.nexgo.inbas.R;
import cn.nexgo.utils.FormatUtils;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : ruandong
 * Date            : 2018/1/17
 * Modify          : create file
 **************************************************************************************************/
public class CardNoConfirmDialog extends Dialog {

    private TextView tvCardNo;
    private OnClickListener onClickListener;

    private Button btnOk;
    private ImageView ivCancel;

    private String cardNo;

    public CardNoConfirmDialog(Context context) {
        super(context, R.style.add_dialog);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.widget_cardno_confirm_dialog);
        setCanceledOnTouchOutside(false);
        setCancelable(false);

        initView();
        initEvent();
    }

    /**
     * init back click event
     */
    private void initEvent() {

        ivCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                if (onClickListener != null) {
                    onClickListener.onCancel();
                }
            }
        });

        btnOk.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dismiss();
                if (onClickListener != null) {
                    onClickListener.onConfirm();
                }
            }
        });

    }

    private void initView() {

        tvCardNo = findViewById(R.id.tv_card_no);
        btnOk = findViewById(R.id.btn_ok);
        ivCancel = findViewById(R.id.iv_cancel);

        tvCardNo.setText(cardNo);
    }

    public void setCardNo(String cardNo) {
        this.cardNo = FormatUtils.formatCardNo(cardNo);
        if(tvCardNo != null){
            tvCardNo.setText(cardNo);
        }
    }

    public void setOnClickListener(OnClickListener onClicListener) {

        this.onClickListener = onClicListener;
    }

    public interface OnClickListener {
        void onConfirm();
        void onCancel();
    }
}