package cn.nexgo.inbas.common.widget;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import cn.nexgo.inbas.R;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : ruandong
 * Date            : 2018/1/17
 * Modify          : create file
 **************************************************************************************************/
public class AppAlertDialog extends Dialog {

    private TextView tvTitle;
    private String titleStr;
    private Listener listener;

    private Button btnOk;
    private Button btnCancel;
    private boolean isShowCancel = true;

    public AppAlertDialog(Context context) {
        super(context, R.style.add_dialog);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.widget_appalsert_dialog);
        setCanceledOnTouchOutside(false);
        setCancelable(false);

        initView();
        initEvent();
    }

    /**
     * init back click event
     */
    private void initEvent() {

        btnCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                if (listener != null) {
                    listener.onCancel();
                }
            }
        });

        btnOk.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dismiss();
                if (listener != null) {
                    listener.onConfirm();
                }
            }
        });

    }

    private void initView() {

        tvTitle = findViewById(R.id.tv_title);
        btnOk = findViewById(R.id.btn_confirm);
        btnCancel = findViewById(R.id.btn_cancel);
        if (!isShowCancel) {
            btnCancel.setVisibility(View.GONE);
        }

        tvTitle.setText(titleStr);

        if(cancelName != null){
            btnCancel.setText(cancelName);
        }
        if(confirmName != null){
            btnOk.setText(confirmName);
        }
    }

    public void setTitle(String title) {
        titleStr = title;
    }

    public void showCancelBtn(boolean enable){
        this.isShowCancel = enable;
    }

    private String cancelName;
    private String confirmName;
    public void setBtnName(String cancelName, String confirmName){
        this.cancelName = cancelName;
        this.confirmName = confirmName;
    }

    public void setListener(Listener listener) {

        this.listener = listener;
    }

    public interface Listener {
        void onConfirm();
        void onCancel();
    }
}