package cn.nexgo.inbas.common.utils;

import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2018/1/2
 * Modify          : create file
 **************************************************************************************************/
public class TimeCounter {

    private Listener listener;
    private long totalUserSet;
    private long total;
    public void startTimer(long total, Listener listener){
        this.listener = listener;
        this.total = total;
        this.totalUserSet = this.total;
        resume();
    }

    private Observable<Long> observable;
    private Disposable disposable;
    private Observer<Long> observer = new Observer<Long>() {
        @Override
        public void onSubscribe(Disposable d) {
            disposable = d;
        }

        @Override
        public void onNext(Long aLong) {
            total--;
            if(listener != null){
                listener.onTimerProcess(total);
            }
            if(total == 0){
                cancel();
                listener.onFinish();
            }
        }

        @Override
        public void onError(Throwable e) {
        }

        @Override
        public void onComplete() {
        }
    };

    public void restart(){
        this.total = this.totalUserSet;
        cancel();
        resume();
    }

    public void pause(){
        if(disposable == null){
            return;
        }
        if(!disposable.isDisposed()){
            disposable.dispose();
        }
    }

    public void resume(){
        if(total <= 0){
            if(listener == null){
                return;
            }
            listener.onTimerProcess(0);
            listener.onFinish();
            return;
        }
        observable = Observable.interval(0, 1, TimeUnit.SECONDS);
        observable.observeOn(AndroidSchedulers.mainThread()).subscribe(observer);
    }

    public void cancel(){
        pause();
    }

    public interface Listener{
        void onTimerProcess(long time);
        void onFinish();
    }

}
