package cn.nexgo.inbas.common.base;

import android.app.Activity;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;

import com.nexgo.oaf.apiv3.APIProxy;
import com.nexgo.oaf.apiv3.device.reader.CardReader;
import com.nexgo.oaf.apiv3.device.reader.CardSlotTypeEnum;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.TimeUnit;

import butterknife.ButterKnife;
import butterknife.Unbinder;
import cn.nexgo.hwdriver.AppBeeper;
import cn.nexgo.inbas.R;
import cn.nexgo.inbas.common.widget.AppAlertDialog;
import cn.nexgo.inbas.common.widget.ContinuePrintDialog;
import cn.nexgo.inbas.common.widget.LoadingDialog;
import cn.nexgo.utils.BaseUtils;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

/***************************************************************************************************
 *                                  Copyright (C), Nexgo Inc.                                      *
 *                                    http://www.nexgo.cn                                          *
 ***************************************************************************************************
 * usage           : 
 * Version         : 1
 * Author          : Truth
 * Date            : 2017/12/19
 * Modify          : create file
 **************************************************************************************************/
public abstract class BaseFragmentActivity extends AppCompatActivity {
    private Logger log = LoggerFactory.getLogger(BaseFragmentActivity.class.getSimpleName());

    protected abstract int getContextViewId();

    protected abstract int getLayoutId();

    private Unbinder unbinder;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(getLayoutId());
        unbinder = ButterKnife.bind(this);
    }

    @Override
    protected void onDestroy() {
        if ((dialog != null) && (dialog.isShowing())) {
            dialog.dismiss();
        }
        if ((mustConfirmDialog != null) && (mustConfirmDialog.isShowing())) {
            mustConfirmDialog.dismiss();
        }
        if ((confirmAndCancelDialog != null) && (confirmAndCancelDialog.isShowing())) {
            confirmAndCancelDialog.dismiss();
        }
        unbinder.unbind();

        destoryCardCheckAction();
        super.onDestroy();
    }

    private boolean firstFragment = true;

    public void startFragment(Fragment fragment, boolean intoStack) {
        // FIXME: lee 2019/9/23 修改当息屏状态下切换fragment导致的崩溃
        PowerManager pm = (PowerManager) this.getSystemService(Context.POWER_SERVICE);
        if (pm != null && !pm.isInteractive()) {
            log.debug("current is screen off, start screen on");
            //点亮屏幕
            PowerManager.WakeLock wl = pm.newWakeLock(PowerManager.ACQUIRE_CAUSES_WAKEUP | PowerManager.SCREEN_BRIGHT_WAKE_LOCK, "bright");
            wl.acquire(10000);
            wl.release();
            //解锁屏幕，如果有密码则解锁不了
            KeyguardManager keyguardManager = (KeyguardManager) this.getSystemService(KEYGUARD_SERVICE);
            if(keyguardManager != null) {
                KeyguardManager.KeyguardLock keyguardLock = keyguardManager.newKeyguardLock("unLock");
                keyguardLock.disableKeyguard();
            }
        }
        String tagName = fragment.getClass().getSimpleName();
        if (intoStack && !firstFragment) {
            getSupportFragmentManager()
                    .beginTransaction()
//                .setCustomAnimations(transitionConfig.enter, transitionConfig.exit, transitionConfig.popenter, transitionConfig.popout)
                    .replace(getContextViewId(), fragment, tagName)
                    .addToBackStack(tagName)
                    .commitAllowingStateLoss();
            return;
        }

        getSupportFragmentManager()
                .beginTransaction()
                .replace(getContextViewId(), fragment, tagName)
                .commitAllowingStateLoss();

        firstFragment = false;
    }

    /**
     * jump to other activity
     *
     * @param tarActivity target Activity
     */
    public void intent2Activity(Class<? extends Activity> tarActivity) {
        Intent intent = new Intent(BaseFragmentActivity.this, tarActivity);
        startActivity(intent);
    }

    /**
     * jump to other activity-with params
     *
     * @param tarActivity target Activity
     * @param bundle      params
     */
    public void intent2Activity(Class<? extends Activity> tarActivity, Bundle bundle) {
        Intent intent = new Intent(BaseFragmentActivity.this, tarActivity);
        intent.putExtras(bundle);
        startActivity(intent);
    }

    /**
     * jump to other activity - for result
     *
     * @param tarActivity target Activity
     */
    protected void intent2ActivityForResult(Class<? extends Activity> tarActivity) {
        Intent intent = new Intent(BaseFragmentActivity.this, tarActivity);
        startActivityForResult(intent, 1000);
    }

    /**
     * jump to other activity - for result and with params
     *
     * @param tarActivity target Activity
     * @param bundle      params
     */
    protected void intent2ActivityForResult(Class<? extends Activity> tarActivity, Bundle bundle) {
        Intent intent = new Intent(BaseFragmentActivity.this, tarActivity);
        intent.putExtras(bundle);
        startActivityForResult(intent, 1000);
    }

    private Handler handler = new Handler(Looper.getMainLooper());
    //    private ProgressDialog pd;
    private LoadingDialog dialog;

    public void processDialog(final boolean enable, final String title, final String msg) {
        handler.post(new Runnable() {
            @Override
            public void run() {
                if (enable) {
                    if (dialog != null) {
                        dialog.setMessage(msg);
                        return;
                    }
                    dialog = new LoadingDialog(BaseFragmentActivity.this);//.createLoadingDialog(BaseFragmentActivity.this, title, msg);
                    dialog.setTitle(title);
                    dialog.setMessage(msg);
                    dialog.show();
//                    pd = ProgressDialog.show(BaseFragmentActivity.this, title, msg, true, false);
                    return;
                }

                if (dialog == null) {
                    return;
                }

                dialog.dismiss();
                dialog = null;
            }
        });
    }

    private AppAlertDialog mustConfirmDialog;

    /**
     * a dialog user must confirm
     *
     * @param title          dialog title
     * @param msg            dialog content
     * @param confirListener callback
     */
    public void mustConfirmDialog(final String title, final String msg, final MustConfirmListener confirListener) {
        handler.post(new Runnable() {
            @Override
            public void run() {
                mustConfirmDialog = new AppAlertDialog(BaseFragmentActivity.this);
                mustConfirmDialog.showCancelBtn(false);
                if (TextUtils.isEmpty(title)) {
                    mustConfirmDialog.setTitle(msg);
                } else {
                    mustConfirmDialog.setTitle(msg);
                }
                mustConfirmDialog.setListener(new AppAlertDialog.Listener() {
                    @Override
                    public void onConfirm() {
                        if (confirListener != null) {
                            confirListener.onConfirm();
                        }
                    }

                    @Override
                    public void onCancel() {

                    }
                });
                mustConfirmDialog.show();

//                final AlertDialog.Builder normalDialog =
//                        new AlertDialog.Builder(BaseFragmentActivity.this);
//                normalDialog.setTitle(title);
//                normalDialog.setMessage(msg);
//                normalDialog.setCancelable(false);
//                normalDialog.setPositiveButton(getResources().getString(R.string.appcontinue),
//                        new DialogInterface.OnClickListener() {
//                            @Override
//                            public void onClick(DialogInterface dialog, int which) {
//                                if (confirListener != null) {
//                                    confirListener.onConfirm();
//                                }
//                            }
//                        });
//                mustConfirmDialog = normalDialog.show();
            }
        });
    }

    private AppAlertDialog confirmAndCancelDialog;

    public void confirmAndCancelDialog(final String title, final String msg, final String cancelBtnStr, final String confirmBtnStr, final ConfirmAndCancelListener listener) {
        handler.post(new Runnable() {
            @Override
            public void run() {
                confirmAndCancelDialog = new AppAlertDialog(BaseFragmentActivity.this);
                if (TextUtils.isEmpty(title)) {
                    confirmAndCancelDialog.setTitle(msg);
                } else {
                    confirmAndCancelDialog.setTitle(msg);
                }
                confirmAndCancelDialog.setBtnName(cancelBtnStr, confirmBtnStr);
                confirmAndCancelDialog.setListener(new AppAlertDialog.Listener() {
                    @Override
                    public void onConfirm() {
                        if (listener != null) {
                            listener.onConfirm();
                        }
                    }

                    @Override
                    public void onCancel() {
                        if (listener != null) {
                            listener.onCancel();
                        }
                    }
                });
                confirmAndCancelDialog.show();
//                final AlertDialog.Builder normalDialog =
//                        new AlertDialog.Builder(BaseFragmentActivity.this);
//                normalDialog.setTitle(title);
//                normalDialog.setMessage(msg);
//                normalDialog.setCancelable(false);
//                normalDialog.setPositiveButton(confirmBtnStr,
//                        new DialogInterface.OnClickListener() {
//                            @Override
//                            public void onClick(DialogInterface dialog, int which) {
//                                if (listener != null) {
//                                    listener.onConfirm();
//                                }
//                            }
//                        });
//                normalDialog.setNegativeButton(cancelBtnStr, new DialogInterface.OnClickListener() {
//                    @Override
//                    public void onClick(DialogInterface dialog, int which) {
//                        if (listener != null) {
//                            listener.onCancel();
//                        }
//                    }
//                });
//                confirmAndCancelDialog = normalDialog.show();
            }
        });
    }

    public void continuePrintDialog(final ContinuePrintDialog.OnContinueListener continueListener) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                ContinuePrintDialog continuePrintDialog = new ContinuePrintDialog(BaseFragmentActivity.this);
                continuePrintDialog.show();
                continuePrintDialog.setOnContinueListener(continueListener);
            }
        });
    }

    @Override
    public void onBackPressed() {
        if (!backPressEn) {
            return;
        }
        if (checkCardInterceptBackPress()) {
            return;
        }
        super.onBackPressed();
    }

    private boolean backPressEn = true;

    /**
     * enable back press key
     *
     * @param enable true:open
     */
    public void enableBackPress(boolean enable) {
        backPressEn = enable;
    }

    //*****************************************
    private Disposable checkCardDisposable;
    private CardReader cardReader;
    private AppBeeper beeper;
    private boolean cardExist = true;

    public void startCheckCardExist() {
        cardReader = APIProxy.getDeviceEngine(BaseUtils.getApp().getApplicationContext()).getCardReader();
        beeper = new AppBeeper();
        checkCardDisposable = Observable.interval(0, 1, TimeUnit.SECONDS)
                .observeOn(Schedulers.io())
                .subscribe(new Consumer<Long>() {
                    @Override
                    public void accept(Long aLong) throws Exception {
                        cardExist = cardReader.isCardExist(CardSlotTypeEnum.ICC1);
                        if ((!cardExist) && (showDialog)) {
                            dismissCardExistDialogAndExist();
                        }
                    }
                });
    }

    private boolean showDialog = false;

    private void showCardExistDialog() {
        beeper.startBeeper(500, 50, -1);
        showDialog = true;
        mustConfirmDialog("", getString(R.string.transresult_plstakeoffcard), confirListener);
    }

    private MustConfirmListener confirListener = new MustConfirmListener() {
        @Override
        public void onConfirm() {
            beeper.stopBeeper();
            checkCardDisposable.dispose();
            cardExist = false;
            onBackPressed();
        }
    };

    private void dismissCardExistDialogAndExist() {
        beeper.stopBeeper();
        Observable.create(new ObservableOnSubscribe<Object>() {
            @Override
            public void subscribe(ObservableEmitter<Object> e) throws Exception {
                onBackPressed();
            }
        }).subscribeOn(AndroidSchedulers.mainThread()).subscribe();
    }

    private boolean checkCardInterceptBackPress() {
        if (checkCardDisposable == null) {
            return false;
        }
        if (cardExist) {
            showCardExistDialog();
            return true;
        }
        return false;
    }

    private void destoryCardCheckAction() {
        if (checkCardDisposable == null) {
            return;
        }
        beeper.stopBeeper();
        if ((checkCardDisposable != null) && (!checkCardDisposable.isDisposed())) {
            checkCardDisposable.dispose();
        }
    }
}
