# Add project specific ProGuard rules here.
# By default, the flags in this file are appended to flags specified
# in /Users/xiaox/Library/Android/sdk/tools/proguard/proguard-android.txt
# You can edit the include path and order by changing the proguardFiles
# directive in build.gradle.
#
# For more details, see
#   http://developer.android.com/guide/developing/tools/proguard.html

# Add any project specific keep options here:

# If your project uses WebView with JS, uncomment the following
# and specify the fully qualified class name to the JavaScript interface
# class:
#-keepclassmembers class fqcn.of.javascript.interface.for.webview {
#   public *;
#}

# Uncomment this to preserve the line number information for
# debugging stack traces.
#-keepattributes SourceFile,LineNumberTable

# If you keep the line number information, uncomment this to
# hide the original source file name.
#-renamesourcefileattribute SourceFile
-keepclassmembers class fqcn.of.javascript.interface.for.webview {
   public *;
}
-optimizationpasses 5
-dontusemixedcaseclassnames
-dontskipnonpubliclibraryclasses
-dontoptimize
-dontpreverify
-verbose
-optimizations !code/simplification/arithmetic,!field/*,!class/merging/*

-keepattributes *Annotation*
-keep public class * extends android.app.Fragment
-keep public class * extends android.app.Activity
-keep public class * extends android.app.Application
-keep public class * extends android.app.Service
-keep public class * extends android.content.BroadcastReceiver
-keep public class * extends android.content.ContentProvider
-keep public class * extends android.app.backup.BackupAgentHelper
-keep public class * extends android.preference.Preference
-keep public class com.android.vending.licensing.ILicensingService
-keep public class * extends android.support.v4.app.Fragment
-ignorewarning
-dump proguard/class_files.txt
-printseeds proguard/seeds.txt
-printusage proguard/unused.txt
-printmapping proguard/mapping.txt

-dontwarn android.support.**

-keepclasseswithmembernames class * {
    native <methods>;
}

-keepclasseswithmembers class * {
    public <init>(android.content.Context, android.util.AttributeSet);
}

-keepclassmembers class * extends android.app.Activity {
   public void *(android.view.View);
}

-keep public class * extends android.view.View {
    public <init>(android.content.Context);
    public <init>(android.content.Context, android.util.AttributeSet);
    public <init>(android.content.Context, android.util.AttributeSet, int);
    public void set*(...);
}

-keep class * implements android.os.Parcelable {
  public static final android.os.Parcelable$Creator *;
}

-keepnames class * implements java.io.Serializable

-keepclassmembers class * implements java.io.Serializable {
    static final long serialVersionUID;
    private static final java.io.ObjectStreamField[] serialPersistentFields;
    !static !transient <fields>;
    !private <fields>;
    !private <methods>;
    private void writeObject(java.io.ObjectOutputStream);
    private void readObject(java.io.ObjectInputStream);
    java.lang.Object writeReplace();
    java.lang.Object readResolve();
}

-keepclassmembers enum * {
  public static **[] values();
  public static ** valueOf(java.lang.String);
}

-keepclassmembers class * {
    public void *ButtonClicked(android.view.View);
}

-keepclassmembers class **.R$* {
    public static <fields>;
}

-keepattributes Signature
-keepattributes Exceptions

-assumenosideeffects class android.util.Log {
    public static *** v(...);
    public static *** i(...);
    public static *** d(...);
    public static *** w(...);
    public static *** e(...);
}

################################### Base #########################################

################keep tms josn########################
-keep class cn.nexgo.czgpe.components.tms.bean.**{*;}

############## support #############
-keep class android.support.** { *; }
-dontwarn android.support.**

############# ButterKnife ################
-keep class butterknife.** { *; }
-dontwarn butterknife.internal.**
-keep class **$$ViewBinder { *; }
-keepclasseswithmembernames class * {
    @butterknife.* <fields>;
}
-keepclasseswithmembernames class * {
    @butterknife.* <methods>;
}

############## char_unicode #############
#-libraryjars libs/char_unicode.jar
-keep class antlr.** { *; }
-dontwarn antlr.**
-keep class info.monitorenter.** { *; }
-dontwarn info.monitorenter.**
-keep class org.mozilla.intl.chardet.** { *; }
-dontwarn org.mozilla.intl.chardet.**

############## nexgo-smart-sdk #############
#-libraryjars libs/nexgo-smart-sdk.jar
-keep class com.nexgo.oaf.apiv3.** { *; }
-keep class com.nexgo.oaf.smartpos.** { *; }
-keep class com.nexgo.libpboc.**{*;}
-keep class com.nexgo.common.**{*;}
-keep class com.nexgo.libgencode.**{*;}
-dontwarn com.nexgo.**
-keep class com.srt.decoder.** { *; }
-dontwarn com.srt.decoder.**
-keep class com.xinguodu.** { *; }
-dontwarn com.xinguodu.**

############## EventBus ##############
-dontwarn de.greenrobot.event.**
-keep class de.greenrobot.event.** { *; }
-keepclassmembers class ** {
    public void onEvent(**);
    void onEvent*(**);
}

################ logbak slf4j #################
-keep class ch.qos.** { *; }
-keep class org.slf4j.** { *; }
-keepattributes *Annotation*

################ XBanner ###################
-keep class com.stx.xhb.xbanner.**{*;}

################ findbugs ###################
-keep class javax.annotation.**{*;}

################ StreamSupport ###################
-keep class java8.lang.**{*;}
-keep class java8.util.**{*;}

################ greendao #################
-keep class org.greenrobot.greendao.**{*;}
-keep public interface org.greenrobot.greendao.**
-keepclassmembers class * extends org.greenrobot.greendao.AbstractDao {
    public static java.lang.String TABLENAME;
}
-keep class **$Properties
-keep class net.sqlcipher.database.**{*;}
-keep public interface net.sqlcipher.database.**
-dontwarn net.sqlcipher.database.**
-dontwarn org.greenrobot.greendao.**

############## RxJava RxAndroid ################
-dontwarn sun.misc.**
-keep class rx.schedulers.Schedulers {
    public static <methods>;
}
-keep class rx.schedulers.ImmediateScheduler {
    public <methods>;
}
-keep class rx.schedulers.TestScheduler {
    public <methods>;
}
-keep class rx.schedulers.Schedulers {
    public static ** test();
}
-keepclassmembers class rx.internal.util.unsafe.*ArrayQueue*Field* {
    long producerIndex;
    long consumerIndex;
}
-keepclassmembers class rx.internal.util.unsafe.BaseLinkedQueueProducerNodeRef {
    long producerNode;
    long consumerNode;
}

############## download key ################
    #保持对外的类不被混淆
    -keep class com.nexgo.downloadkey.downloadflow.DownloadFlow{*;}
    -keep interface com.nexgo.downloadkey.downloadflow.DownloadFlowProcessListener{*;}
    -keep class com.nexgo.downloadkey.downloadflow.DownloadFEntity{*;}
    -keep class com.nexgo.downloadkey.downloadflow.DownloadFlowResultEntity{*;}
    -keep class com.nexgo.downloadkey.downloadflow.DownloadResult{*;}
    -keep class com.nexgo.downloadkey.downloadflow.Provider{*;}
    -keep class com.nexgo.downloadkey.jniinterface.CallNative{*;}
